/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.util;

import com.oracle.truffle.api.CompilerDirectives;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DotExport {
    private static final Pattern specialChars = Pattern.compile("[\"\\\\]");

    public static void printConnection(BufferedWriter writer, String from, String to, String label) throws IOException {
        writer.write(String.format("    \"%s\" -> \"%s\" [ label = \"%s\" ];", DotExport.escape(from), DotExport.escape(to), DotExport.escape(label)));
        writer.newLine();
    }

    public static String escape(String str) {
        StringBuffer escapedString = new StringBuffer();
        Matcher m2 = specialChars.matcher(str);
        while (m2.find()) {
            m2.appendReplacement(escapedString, switch (str.charAt(m2.start())) {
                case '\"' -> "\\\\\"";
                case '\\' -> "";
                default -> throw CompilerDirectives.shouldNotReachHere();
            });
        }
        m2.appendTail(escapedString);
        return escapedString.toString();
    }
}

