/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.dfa;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.regex.RegexOptions;
import com.oracle.truffle.regex.UnsupportedRegexException;
import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.charset.CodePointSetAccumulator;
import com.oracle.truffle.regex.charset.CompressedCodePointSet;
import com.oracle.truffle.regex.charset.Constants;
import com.oracle.truffle.regex.result.PreCalculatedResultFactory;
import com.oracle.truffle.regex.tregex.TRegexCompilationRequest;
import com.oracle.truffle.regex.tregex.automaton.AbstractTransition;
import com.oracle.truffle.regex.tregex.automaton.BasicState;
import com.oracle.truffle.regex.tregex.automaton.StateSet;
import com.oracle.truffle.regex.tregex.automaton.TransitionBuilder;
import com.oracle.truffle.regex.tregex.automaton.TransitionSet;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.buffer.IntArrayBuffer;
import com.oracle.truffle.regex.tregex.buffer.IntRangesBuffer;
import com.oracle.truffle.regex.tregex.buffer.ObjectArrayBuffer;
import com.oracle.truffle.regex.tregex.buffer.ShortArrayBuffer;
import com.oracle.truffle.regex.tregex.dfa.DFACaptureGroupLazyTransitionBuilder;
import com.oracle.truffle.regex.tregex.dfa.DFACaptureGroupTransitionBuilder;
import com.oracle.truffle.regex.tregex.dfa.DFAStateNodeBuilder;
import com.oracle.truffle.regex.tregex.dfa.DFAStateTransitionBuilder;
import com.oracle.truffle.regex.tregex.dfa.DFATransitionCanonicalizer;
import com.oracle.truffle.regex.tregex.nfa.NFA;
import com.oracle.truffle.regex.tregex.nfa.NFAState;
import com.oracle.truffle.regex.tregex.nfa.NFAStateTransition;
import com.oracle.truffle.regex.tregex.nodes.dfa.AllTransitionsInOneTreeMatcher;
import com.oracle.truffle.regex.tregex.nodes.dfa.BackwardDFAStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.CGTrackingDFAStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAAbstractStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFACaptureGroupLazyTransition;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFACaptureGroupPartialTransition;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAFindInnerLiteralStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAInitialStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFASimpleCG;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFASimpleCGTransition;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.Matchers;
import com.oracle.truffle.regex.tregex.nodes.dfa.SequentialMatchers;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorDebugRecorder;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorProperties;
import com.oracle.truffle.regex.tregex.nodes.dfa.TraceFinderDFAStateNode;
import com.oracle.truffle.regex.tregex.nodesplitter.DFANodeSplit;
import com.oracle.truffle.regex.tregex.nodesplitter.DFANodeSplitBailoutException;
import com.oracle.truffle.regex.tregex.parser.Counter;
import com.oracle.truffle.regex.tregex.parser.RegexProperties;
import com.oracle.truffle.regex.tregex.parser.ast.CharacterClass;
import com.oracle.truffle.regex.tregex.parser.ast.GroupBoundaries;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTNode;
import com.oracle.truffle.regex.tregex.parser.ast.Sequence;
import com.oracle.truffle.regex.tregex.parser.ast.Term;
import com.oracle.truffle.regex.tregex.parser.ast.visitors.AddToSetVisitor;
import com.oracle.truffle.regex.tregex.string.Encodings;
import com.oracle.truffle.regex.tregex.util.MathUtil;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;
import com.oracle.truffle.regex.util.BitSets;
import com.oracle.truffle.regex.util.EmptyArrays;
import com.oracle.truffle.regex.util.TBitSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PrimitiveIterator;
import org.cyclops.integratedscripting.vendors.org.graalvm.collections.EconomicMap;
import org.cyclops.integratedscripting.vendors.org.graalvm.collections.UnmodifiableMapCursor;

public final class DFAGenerator
implements JsonConvertible {
    private static final DFAStateTransitionBuilder[] EMPTY_TRANSITIONS_ARRAY = new DFAStateTransitionBuilder[0];
    private final TRegexCompilationRequest compilationRequest;
    private final NFA nfa;
    private final TRegexDFAExecutorProperties executorProps;
    private final CompilationBuffer compilationBuffer;
    private final boolean pruneUnambiguousPaths;
    private final Map<DFAStateNodeBuilder, DFAStateNodeBuilder> stateMap = new HashMap<DFAStateNodeBuilder, DFAStateNodeBuilder>();
    private final ArrayDeque<DFAStateNodeBuilder> expansionQueue = new ArrayDeque();
    private DFAStateNodeBuilder[] stateIndexMap = null;
    private short nextID = 1;
    private final DFAStateNodeBuilder lookupDummyState;
    private final Counter transitionIDCounter;
    private final Counter cgPartialTransitionIDCounter = new Counter.ThresholdCounter(3000, "too many partial transitions");
    private int maxNumberOfNfaStates = 1;
    private boolean hasAmbiguousStates = false;
    private boolean doSimpleCG = false;
    private boolean simpleCGMustCopy = false;
    private final StateSet<NFA, NFAState> nfaFirstStates;
    private DFAStateNodeBuilder[] entryStates;
    private DFACaptureGroupTransitionBuilder[] initialCGTransitions;
    private final List<DFACaptureGroupTransitionBuilder.PartialTransitionDebugInfo> cgPartialTransitions;
    private final DFATransitionCanonicalizer canonicalizer;
    private List<DFAStateTransitionBuilder[]> bfsTraversalCur;
    private List<DFAStateTransitionBuilder[]> bfsTraversalNext;
    private EconomicMap<Integer, DFAAbstractStateNode> stateReplacements;
    private TRegexDFAExecutorNode innerLiteralPrefixMatcher = null;
    private final SequentialMatchers.Builder matchersBuilder;
    private final List<TruffleString.CodePointSet> indexOfParams = new ArrayList<TruffleString.CodePointSet>();

    public DFAGenerator(TRegexCompilationRequest compilationRequest, NFA nfa, TRegexDFAExecutorProperties executorProps, CompilationBuffer compilationBuffer) {
        this.transitionIDCounter = new Counter.ThresholdCounter(nfa.getAst().getOptions().getMaxDFASize(), "too many transitions");
        this.compilationRequest = compilationRequest;
        this.nfa = nfa;
        this.executorProps = executorProps;
        this.pruneUnambiguousPaths = executorProps.isBackward() && nfa.isTraceFinderNFA() && nfa.hasReverseUnAnchoredEntry();
        this.compilationBuffer = compilationBuffer;
        this.cgPartialTransitions = this.debugMode() ? new ArrayList() : null;
        this.bfsTraversalCur = this.needBFSTraversalLists() ? new ArrayList() : null;
        this.bfsTraversalNext = this.needBFSTraversalLists() ? new ArrayList() : null;
        this.cgPartialTransitionIDCounter.inc();
        this.lookupDummyState = new DFAStateNodeBuilder(-1, null, false, false, this.isForward(), this.isForward() && !this.isBooleanMatch());
        if (this.debugMode()) {
            this.registerCGPartialTransitionDebugInfo(new DFACaptureGroupTransitionBuilder.PartialTransitionDebugInfo(DFACaptureGroupPartialTransition.getEmptyInstance()));
        }
        assert (!nfa.isDead());
        this.canonicalizer = new DFATransitionCanonicalizer(this);
        this.matchersBuilder = nfa.getAst().getEncoding().createMatchersBuilder();
        this.nfaFirstStates = StateSet.create(nfa);
    }

    public NFA getNfa() {
        return this.nfa;
    }

    public DFAStateNodeBuilder[] getEntryStates() {
        return this.entryStates;
    }

    private DFAStateNodeBuilder getUnanchoredInitialState() {
        return this.entryStates[this.nfa.getAnchoredEntry().length];
    }

    public Map<DFAStateNodeBuilder, DFAStateNodeBuilder> getStateMap() {
        return this.stateMap;
    }

    public TRegexDFAExecutorProperties getProps() {
        return this.executorProps;
    }

    public boolean isForward() {
        return this.executorProps.isForward();
    }

    public boolean isGenericCG() {
        return this.executorProps.isGenericCG();
    }

    public boolean isSearching() {
        return this.executorProps.isSearching();
    }

    public RegexOptions getOptions() {
        return this.nfa.getAst().getOptions();
    }

    private Encodings.Encoding getEncoding() {
        return this.nfa.getAst().getEncoding();
    }

    private boolean isBooleanMatch() {
        return this.getOptions().isBooleanMatch();
    }

    public CompilationBuffer getCompilationBuffer() {
        return this.compilationBuffer;
    }

    private DFAStateNodeBuilder[] getStateIndexMap() {
        if (this.stateIndexMap == null) {
            this.createStateIndexMap(this.nextID);
        }
        return this.stateIndexMap;
    }

    public DFAStateNodeBuilder getState(short stateNodeID) {
        assert (this.debugMode());
        this.getStateIndexMap();
        return this.stateIndexMap[stateNodeID];
    }

    private void createStateIndexMap(int size) {
        assert (this.debugMode());
        this.stateIndexMap = new DFAStateNodeBuilder[size];
        Iterator<DFAStateNodeBuilder> iterator = this.stateMap.values().iterator();
        while (iterator.hasNext()) {
            DFAStateNodeBuilder s2;
            this.stateIndexMap[s2.getId()] = s2 = iterator.next();
        }
    }

    public void nodeSplitSetNewDFASize(int size) {
        assert (this.debugMode());
        assert (this.stateIndexMap == null);
        this.createStateIndexMap(size);
    }

    public void nodeSplitRegisterDuplicateState(short oldID, short newID) {
        DFAStateNodeBuilder copy;
        assert (this.debugMode());
        this.stateIndexMap[newID] = copy = this.stateIndexMap[oldID].createNodeSplitCopy(newID);
        for (DFAStateTransitionBuilder t2 : (DFAStateTransitionBuilder[])copy.getSuccessors()) {
            t2.setId(this.transitionIDCounter.inc());
            t2.setSource(copy);
        }
    }

    public void nodeSplitUpdateSuccessors(short stateID, short[] newSuccessors) {
        assert (this.debugMode());
        assert (this.stateIndexMap[stateID] != null);
        this.stateIndexMap[stateID].nodeSplitUpdateSuccessors(newSuccessors, this.stateIndexMap);
    }

    public Counter getCgPartialTransitionIDCounter() {
        return this.cgPartialTransitionIDCounter;
    }

    public void registerCGPartialTransitionDebugInfo(DFACaptureGroupTransitionBuilder.PartialTransitionDebugInfo partialTransition) {
        if (this.cgPartialTransitions.size() == partialTransition.getNode().getId()) {
            this.cgPartialTransitions.add(partialTransition);
        } else assert (partialTransition.getNode() == this.cgPartialTransitions.get(partialTransition.getNode().getId()).getNode());
    }

    private boolean needBFSTraversalLists() {
        return this.pruneUnambiguousPaths || this.nfa.getAst().getProperties().hasInnerLiteral();
    }

    private void bfsExpand(DFAStateNodeBuilder s2) {
        if (s2.getSuccessors() != null) {
            this.bfsTraversalNext.add((DFAStateTransitionBuilder[])s2.getSuccessors());
        }
    }

    private void bfsSwapLists() {
        List<DFAStateTransitionBuilder[]> tmp = this.bfsTraversalCur;
        this.bfsTraversalCur = this.bfsTraversalNext;
        this.bfsTraversalNext = tmp;
    }

    @CompilerDirectives.TruffleBoundary
    public void calcDFA() {
        if (this.isForward()) {
            this.createInitialStatesForward();
            this.addSuccessors(this.nfaFirstStates, this.nfa.getUnAnchoredInitialState());
            this.addSuccessors(this.nfaFirstStates, this.nfa.getAnchoredInitialState());
        } else {
            this.createInitialStatesBackward();
        }
        while (!this.expansionQueue.isEmpty()) {
            this.expandState(this.expansionQueue.pop());
        }
        this.optimizeDFA();
    }

    private void addSuccessors(StateSet<NFA, NFAState> stateSet, NFAState state) {
        if (state != null) {
            for (NFAStateTransition t2 : (NFAStateTransition[])state.getSuccessors()) {
                stateSet.add((NFAState)t2.getTarget(this.isForward()));
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    public TRegexDFAExecutorNode createDFAExecutor() {
        DFAAbstractStateNode[] states = this.createDFAExecutorStates();
        assert (states[0] == null);
        short[] entryStateIDs = new short[this.entryStates.length];
        short[] cgLastTransition = this.isGenericCG() ? new short[this.entryStates.length] : null;
        for (int i2 = 0; i2 < this.entryStates.length; ++i2) {
            if (this.entryStates[i2] == null) {
                entryStateIDs[i2] = -1;
                continue;
            }
            entryStateIDs[i2] = (short)this.entryStates[i2].getId();
            if (!this.isGenericCG()) continue;
            DFACaptureGroupLazyTransitionBuilder lt = this.getLazyTransition(this.initialCGTransitions[i2]);
            cgLastTransition[i2] = lt.getLastTransitionIndex();
        }
        if (this.executorProps.canFindStart()) {
            assert (this.getReplacement(this.getUnanchoredInitialState().getId()) instanceof DFAFindInnerLiteralStateNode);
            entryStateIDs = new short[]{(short)this.getUnanchoredInitialState().getId(), (short)this.getUnanchoredInitialState().getId()};
        }
        states[0] = new DFAInitialStateNode(entryStateIDs, cgLastTransition);
        this.executorProps.setSimpleCG(this.doSimpleCG);
        this.executorProps.setSimpleCGMustCopy(this.simpleCGMustCopy);
        TRegexDFAExecutorDebugRecorder debugRecorder = TRegexDFAExecutorDebugRecorder.create(this.getOptions(), this);
        return new TRegexDFAExecutorNode(this.nfa.getAst().getSource(), this.executorProps, this.getNfa().getAst().getNumberOfCaptureGroups(), this.maxNumberOfNfaStates, (TruffleString.CodePointSet[])this.indexOfParams.toArray(TruffleString.CodePointSet[]::new), states, debugRecorder, this.innerLiteralPrefixMatcher);
    }

    private void createInitialStatesForward() {
        int numberOfEntryPoints = this.nfa.getAnchoredEntry().length;
        this.entryStates = new DFAStateNodeBuilder[numberOfEntryPoints * 2];
        this.nfa.setInitialLoopBack(this.isSearching() && !this.nfa.getAst().getFlags().isSticky());
        for (int i2 = 0; i2 < numberOfEntryPoints; ++i2) {
            if (this.nfa.getAnchoredEntry()[i2] == null) {
                assert (this.nfa.getUnAnchoredEntry()[i2] == null);
                this.entryStates[i2] = null;
                this.entryStates[numberOfEntryPoints + i2] = null;
                continue;
            }
            if (this.nfa.getUnAnchoredEntry()[i2] == null) {
                this.entryStates[i2] = this.createInitialState(this.createTransitionBuilder(this.createNFATransitionSet(this.nfa.getAnchoredEntry()[i2])));
                this.entryStates[numberOfEntryPoints + i2] = null;
                continue;
            }
            this.entryStates[i2] = this.createInitialState(this.createTransitionBuilder(this.createNFATransitionSet(this.nfa.getAnchoredEntry()[i2], this.nfa.getUnAnchoredEntry()[i2])));
            this.entryStates[numberOfEntryPoints + i2] = this.createInitialState(this.createTransitionBuilder(this.createNFATransitionSet(this.nfa.getUnAnchoredEntry()[i2])));
        }
    }

    private void createInitialStatesBackward() {
        this.entryStates = new DFAStateNodeBuilder[]{null, null};
        if (this.nfa.hasReverseUnAnchoredEntry()) {
            this.entryStates[0] = this.createInitialState(this.createTransitionBuilder(this.createNFATransitionSet(this.nfa.getReverseAnchoredEntry(), this.nfa.getReverseUnAnchoredEntry())));
            this.entryStates[1] = this.createInitialState(this.createTransitionBuilder(this.createNFATransitionSet(this.nfa.getReverseUnAnchoredEntry())));
        } else {
            this.entryStates[0] = this.createInitialState(this.createTransitionBuilder(this.createNFATransitionSet(this.nfa.getReverseAnchoredEntry())));
            this.entryStates[1] = null;
        }
    }

    private DFAStateNodeBuilder createInitialState(DFAStateTransitionBuilder transition) {
        DFAStateNodeBuilder lookup = this.lookupState(transition.getTransitionSet(), false);
        if (lookup == null) {
            lookup = this.createState(transition.getTransitionSet(), false, true);
            lookup.updateFinalStateData(this);
            if (this.isGenericCG()) {
                lookup.incPredecessors();
            }
        }
        transition.setTarget(lookup);
        return lookup;
    }

    private void expandState(DFAStateNodeBuilder state) {
        if (this.pruneUnambiguousPaths && this.tryPruneTraceFinderState(state)) {
            return;
        }
        boolean anyPrefixStateSuccessors = false;
        boolean allPrefixStateSuccessors = true;
        block0: for (NFAStateTransition transition : (NFAStateTransition[])state.getNfaTransitionSet().getTransitions()) {
            NFAState nFAState = (NFAState)transition.getTarget(this.isForward());
            for (NFAStateTransition nfaTransition : (NFAStateTransition[])nFAState.getSuccessors(this.isForward())) {
                NFAState target = (NFAState)nfaTransition.getTarget(this.isForward());
                if (!(target.isFinalState(this.isForward()) || state.isBackwardPrefixState() && !target.hasPrefixStates())) {
                    anyPrefixStateSuccessors |= target.hasPrefixStates();
                    allPrefixStateSuccessors &= target.hasPrefixStates();
                    this.canonicalizer.addArgument(nfaTransition, this.isForward() ? nfaTransition.getCodePointSet() : target.getCharSet());
                    continue;
                }
                if (!this.isForward() || !target.isUnAnchoredFinalState()) continue;
                assert (target == this.nfa.getReverseUnAnchoredEntry().getSource());
                break block0;
            }
        }
        if (!this.isForward() && anyPrefixStateSuccessors) {
            if (allPrefixStateSuccessors) {
                state.setBackwardPrefixState((short)state.getId());
            } else {
                assert (!state.isBackwardPrefixState());
                DFAStateNodeBuilder lookup = this.lookupState(state.getNfaTransitionSet(), true);
                if (lookup == null) {
                    lookup = this.createState(state.getNfaTransitionSet(), true, false);
                }
                state.setBackwardPrefixState((short)lookup.getId());
            }
        }
        AbstractTransition[] transitions = (DFAStateTransitionBuilder[])this.canonicalizer.run(this.compilationBuffer);
        Arrays.sort(transitions, Comparator.comparing(TransitionBuilder::getCodePointSet));
        for (DFAStateTransitionBuilder dFAStateTransitionBuilder : transitions) {
            assert (!dFAStateTransitionBuilder.getTransitionSet().isEmpty());
            dFAStateTransitionBuilder.setId(this.transitionIDCounter.inc());
            dFAStateTransitionBuilder.setSource(state);
            DFAStateNodeBuilder successorState = this.lookupState(dFAStateTransitionBuilder.getTransitionSet(), state.isBackwardPrefixState());
            if (successorState == null) {
                successorState = this.createState(dFAStateTransitionBuilder.getTransitionSet(), state.isBackwardPrefixState(), false);
            } else if (this.pruneUnambiguousPaths) {
                this.reScheduleFinalStateSuccessors(state, successorState);
            }
            if (this.pruneUnambiguousPaths && (state.isUnAnchoredFinalState() || state.isFinalStateSuccessor())) {
                state.setFinalStateSuccessor();
                successorState.setFinalStateSuccessor();
            }
            dFAStateTransitionBuilder.setTarget(successorState);
            successorState.updateFinalStateData(this);
            if (this.isGenericCG()) {
                dFAStateTransitionBuilder.getTarget().incPredecessors();
            }
            if (!state.isUnAnchoredFinalState() || successorState == state) continue;
            this.simpleCGMustCopy = true;
        }
        state.setSuccessors(transitions);
    }

    private DFAStateTransitionBuilder createTransitionBuilder(TransitionSet<NFA, NFAState, NFAStateTransition> transitionSet) {
        return this.createTransitionBuilder(null, transitionSet);
    }

    private DFAStateTransitionBuilder createTransitionBuilder(CodePointSet matcherBuilder, TransitionSet<NFA, NFAState, NFAStateTransition> transitionSet) {
        if (this.isGenericCG()) {
            return new DFACaptureGroupTransitionBuilder(matcherBuilder, transitionSet, this);
        }
        return new DFAStateTransitionBuilder(transitionSet, matcherBuilder);
    }

    private TransitionSet<NFA, NFAState, NFAStateTransition> createNFATransitionSet(NFAStateTransition initialTransition) {
        return new TransitionSet((AbstractTransition[])new NFAStateTransition[]{initialTransition}, StateSet.create(this.nfa, (NFAState)initialTransition.getTarget(this.isForward())));
    }

    private TransitionSet<NFA, NFAState, NFAStateTransition> createNFATransitionSet(NFAStateTransition t1, NFAStateTransition t2) {
        if (t1 == t2) {
            return this.createNFATransitionSet(t1);
        }
        StateSet<NFA, NFAState> targetStateSet = StateSet.create(this.nfa, (NFAState)t1.getTarget(this.isForward()));
        targetStateSet.add((NFAState)t2.getTarget(this.isForward()));
        return new TransitionSet((AbstractTransition[])new NFAStateTransition[]{t1, t2}, targetStateSet);
    }

    private boolean tryPruneTraceFinderState(DFAStateNodeBuilder state) {
        assert (this.nfa.isTraceFinderNFA());
        if (state.isFinalStateSuccessor()) {
            return false;
        }
        PreCalculatedResultFactory result = null;
        int resultIndex = -1;
        assert (!state.getNfaTransitionSet().isEmpty());
        for (NFAStateTransition transition : (NFAStateTransition[])state.getNfaTransitionSet().getTransitions()) {
            NFAState nfaState = (NFAState)transition.getTarget(this.isForward());
            PrimitiveIterator.OfInt ofInt = nfaState.getPossibleResults().iterator();
            while (ofInt.hasNext()) {
                int i2 = (Integer)ofInt.next();
                if (result == null) {
                    result = this.nfa.getPreCalculatedResults()[i2];
                    resultIndex = (byte)i2;
                    continue;
                }
                if (result == this.nfa.getPreCalculatedResults()[i2]) continue;
                return false;
            }
        }
        if (resultIndex >= 0) {
            state.setOverrideFinalState(true);
            state.updatePreCalcUnAnchoredResult(resultIndex);
            state.setSuccessors(EMPTY_TRANSITIONS_ARRAY);
            return true;
        }
        return false;
    }

    private void reScheduleFinalStateSuccessors(DFAStateNodeBuilder state, DFAStateNodeBuilder successorState) {
        assert (this.nfa.isTraceFinderNFA());
        if ((state.isUnAnchoredFinalState() || state.isFinalStateSuccessor()) && !successorState.isFinalStateSuccessor()) {
            this.reScheduleFinalStateSuccessor(successorState);
            this.bfsTraversalCur.clear();
            if (successorState.getSuccessors() != null) {
                this.bfsTraversalCur.add((DFAStateTransitionBuilder[])successorState.getSuccessors());
            }
            while (!this.bfsTraversalCur.isEmpty()) {
                this.bfsTraversalNext.clear();
                for (DFAStateTransitionBuilder[] cur : this.bfsTraversalCur) {
                    for (DFAStateTransitionBuilder t2 : cur) {
                        if (t2.getTarget().isFinalStateSuccessor()) continue;
                        this.bfsExpand(t2.getTarget());
                        this.reScheduleFinalStateSuccessor(t2.getTarget());
                    }
                }
                this.bfsSwapLists();
            }
        }
    }

    private void reScheduleFinalStateSuccessor(DFAStateNodeBuilder finalStateSuccessor) {
        finalStateSuccessor.setFinalStateSuccessor();
        finalStateSuccessor.setOverrideFinalState(false);
        finalStateSuccessor.clearPreCalculatedResults();
        finalStateSuccessor.updateFinalStateData(this);
        this.expansionQueue.push(finalStateSuccessor);
    }

    private DFAStateNodeBuilder lookupState(TransitionSet<NFA, NFAState, NFAStateTransition> transitionSet, boolean isBackWardPrefixState) {
        this.lookupDummyState.setNfaTransitionSet(transitionSet);
        this.lookupDummyState.setIsBackwardPrefixState(isBackWardPrefixState);
        return this.stateMap.get(this.lookupDummyState);
    }

    private DFAStateNodeBuilder createState(TransitionSet<NFA, NFAState, NFAStateTransition> transitionSet, boolean isBackwardPrefixState, boolean isInitialState) {
        assert (this.stateIndexMap == null) : "state index map created before dfa generation!";
        short s2 = this.nextID;
        this.nextID = (short)(s2 + 1);
        DFAStateNodeBuilder dfaState = new DFAStateNodeBuilder(s2, transitionSet, isBackwardPrefixState, isInitialState, this.isForward(), this.isForward() && !this.isBooleanMatch());
        this.stateMap.put(dfaState, dfaState);
        if (this.stateMap.size() + (this.isForward() ? this.expansionQueue.size() : 0) > 1300) {
            throw new UnsupportedRegexException((this.isForward() ? (this.isGenericCG() ? "CG" : "Forward") : "Backward") + " DFA explosion");
        }
        if (!this.hasAmbiguousStates && (transitionSet.size() > 2 || transitionSet.size() == 2 && transitionSet.getTransition(1) != this.nfa.getInitialLoopBackTransition())) {
            this.hasAmbiguousStates = true;
        }
        if (!this.isBooleanMatch() || !dfaState.updateFinalStateData(this).isUnAnchoredFinalState()) {
            this.expansionQueue.push(dfaState);
        }
        return dfaState;
    }

    private void optimizeDFA() {
        RegexProperties props = this.nfa.getAst().getProperties();
        this.doSimpleCG = !(!this.isForward() && (this.nfa.getAst().getProperties().hasQuantifiers() || this.nfa.getAst().getProperties().hasEmptyCaptureGroups()) || this.isBooleanMatch() || !this.executorProps.isAllowSimpleCG() || this.hasAmbiguousStates || this.nfa.isTraceFinderNFA() || this.isGenericCG() || !this.isSearching() && !props.hasCaptureGroups() || !props.hasAlternations() && !props.hasLookAroundAssertions());
        this.tryInnerLiteralOptimization();
    }

    private void tryInnerLiteralOptimization() {
        RegexProperties props = this.nfa.getAst().getProperties();
        if (!this.isForward() || !this.isSearching() || this.isGenericCG() || this.nfa.getAst().getFlags().isSticky() || !props.hasInnerLiteral() || this.getUnanchoredInitialState() == null) {
            return;
        }
        int literalEnd = props.getInnerLiteralEnd();
        int literalStart = props.getInnerLiteralStart();
        Sequence rootSeq = this.nfa.getAst().getRoot().getFirstAlternative();
        boolean prefixHasLookAhead = false;
        StateSet<RegexAST, RegexASTNode> prefixAstNodes = StateSet.create(this.nfa.getAst());
        for (int i2 = 0; i2 < literalStart; ++i2) {
            Term t2 = rootSeq.getTerms().get(i2);
            prefixHasLookAhead |= t2.hasLookAheads();
            AddToSetVisitor.addCharacterClasses(prefixAstNodes, t2);
        }
        StateSet<NFA, NFAState> prefixNFAStates = StateSet.create(this.nfa);
        if (this.nfa.getUnAnchoredInitialState() != null) {
            prefixNFAStates.add(this.nfa.getUnAnchoredInitialState());
        }
        NFAState literalFirstState = null;
        NFAState literalLastState = null;
        for (NFAState s2 : this.nfa.getStates()) {
            if (s2 == null) continue;
            if (!prefixHasLookAhead && !s2.getStateSet().isEmpty() && prefixAstNodes.containsAll(s2.getStateSet())) {
                prefixNFAStates.add(s2);
            }
            if (s2.getStateSet().contains(rootSeq.getTerms().get(literalStart))) {
                if (literalFirstState != null) {
                    return;
                }
                literalFirstState = s2;
            }
            if (!s2.getStateSet().contains(rootSeq.getTerms().get(literalEnd - 1))) continue;
            if (literalLastState != null) {
                return;
            }
            literalLastState = s2;
        }
        if (prefixHasLookAhead) {
            ArrayList<NFAState> bfsCur = new ArrayList<NFAState>(prefixNFAStates);
            ArrayList<NFAState> bfsNext = new ArrayList<NFAState>();
            if (this.nfa.getAnchoredInitialState() != null) {
                bfsCur.add(this.nfa.getAnchoredInitialState());
            }
            while (!bfsCur.isEmpty()) {
                for (NFAState s2 : bfsCur) {
                    for (NFAStateTransition t3 : (NFAStateTransition[])s2.getSuccessors()) {
                        NFAState target = t3.getTarget();
                        if (target == literalFirstState || !prefixNFAStates.add(target)) continue;
                        bfsNext.add(target);
                    }
                }
                ArrayList<NFAState> tmp = bfsCur;
                bfsCur = bfsNext;
                bfsNext = tmp;
                bfsNext.clear();
            }
        }
        assert (literalFirstState != null);
        assert (literalLastState != null);
        DFAStateNodeBuilder literalFirstDFAState = null;
        BasicState literalLastDFAState = null;
        DFAStateNodeBuilder unanchoredInitialState = this.getUnanchoredInitialState();
        TBitSet visited = new TBitSet(this.nextID);
        visited.set(unanchoredInitialState.getId());
        this.bfsTraversalCur.clear();
        this.bfsTraversalCur.add((DFAStateTransitionBuilder[])unanchoredInitialState.getSuccessors());
        block5: while (!this.bfsTraversalCur.isEmpty()) {
            this.bfsTraversalNext.clear();
            Iterator<DFAStateTransitionBuilder[]> iterator = this.bfsTraversalCur.iterator();
            while (iterator.hasNext()) {
                DFAStateTransitionBuilder[] cur;
                for (DFAStateTransitionBuilder t4 : cur = (DFAStateTransitionBuilder[])iterator.next()) {
                    DFAStateNodeBuilder target = t4.getTarget();
                    if (visited.get(target.getId())) continue;
                    visited.set(target.getId());
                    StateSet<NFA, NFAState> targetStateSet = target.getNfaTransitionSet().getTargetStateSet();
                    if (literalFirstDFAState == null && targetStateSet.contains(literalFirstState)) {
                        literalFirstDFAState = target;
                    }
                    if (targetStateSet.contains(literalLastState)) {
                        literalLastDFAState = target;
                        this.bfsTraversalNext.clear();
                        break block5;
                    }
                    this.bfsExpand(target);
                }
            }
            this.bfsSwapLists();
        }
        assert (literalFirstDFAState != null);
        assert (literalLastDFAState != null);
        if (literalStart > 0) {
            this.nfa.setInitialLoopBack(false);
            if (this.innerLiteralMatchesPrefix(prefixNFAStates)) {
                this.nfa.setInitialLoopBack(true);
                return;
            }
            this.nfa.setInitialLoopBack(true);
            CodePointSetAccumulator acc = this.compilationBuffer.getCodePointSetAccumulator1();
            for (DFAStateNodeBuilder s3 : this.stateMap.values()) {
                acc.clear();
                if (prefixNFAStates.containsAll(s3.getNfaTransitionSet().getTargetStateSet())) continue;
                TransitionBuilder mergedTransition = null;
                ObjectArrayBuffer<DFAStateTransitionBuilder> newTransitions = null;
                for (int i3 = 0; i3 < ((DFAStateTransitionBuilder[])s3.getSuccessors()).length; ++i3) {
                    DFAStateTransitionBuilder t5 = ((DFAStateTransitionBuilder[])s3.getSuccessors())[i3];
                    if (prefixNFAStates.containsAll(t5.getTarget().getNfaTransitionSet().getTargetStateSet())) {
                        if (mergedTransition == null) {
                            t5.setTarget(unanchoredInitialState);
                            mergedTransition = t5;
                            continue;
                        }
                        if (newTransitions == null) {
                            newTransitions = this.compilationBuffer.getObjectBuffer1();
                            newTransitions.addAll(s3.getSuccessors(), 0, i3);
                            acc.addSet(mergedTransition.getCodePointSet());
                            acc.addSet(t5.getCodePointSet());
                            continue;
                        }
                        acc.addSet(t5.getCodePointSet());
                        continue;
                    }
                    if (newTransitions == null) continue;
                    newTransitions.add(t5);
                }
                if (newTransitions == null || mergedTransition == null) continue;
                mergedTransition.setMatcherBuilder(acc.toCodePointSet());
                s3.setSuccessors(newTransitions.toArray(new DFAStateTransitionBuilder[newTransitions.length()]));
                Arrays.sort((DFAStateTransitionBuilder[])s3.getSuccessors(), Comparator.comparing(TransitionBuilder::getCodePointSet));
            }
            this.nfa.setInitialLoopBack(false);
            NFAState reverseAnchoredInitialState = this.nfa.getReverseAnchoredEntry().getSource();
            NFAState reverseUnAnchoredInitialState = this.nfa.getReverseUnAnchoredEntry().getSource();
            this.nfa.getReverseAnchoredEntry().setSource(literalFirstState);
            this.nfa.getReverseUnAnchoredEntry().setSource(literalFirstState);
            assert (this.innerLiteralPrefixMatcher == null);
            this.innerLiteralPrefixMatcher = this.compilationRequest.createDFAExecutor(this.nfa, new TRegexDFAExecutorProperties(false, false, false, this.doSimpleCG, false, rootSeq.getTerms().get(literalStart - 1).getMinPath()), "innerLiteralPrefix");
            this.innerLiteralPrefixMatcher.getProperties().setSimpleCGMustCopy(false);
            this.doSimpleCG = this.doSimpleCG && this.innerLiteralPrefixMatcher.isSimpleCG();
            this.nfa.setInitialLoopBack(true);
            this.nfa.getReverseAnchoredEntry().setSource(reverseAnchoredInitialState);
            this.nfa.getReverseUnAnchoredEntry().setSource(reverseUnAnchoredInitialState);
        }
        this.executorProps.setCanFindStart(this.innerLiteralCanFindMatchStart(unanchoredInitialState, (DFAStateNodeBuilder)literalLastDFAState));
        this.registerStateReplacement(unanchoredInitialState.getId(), new DFAFindInnerLiteralStateNode((short)unanchoredInitialState.getId(), new short[]{(short)literalLastDFAState.getId()}, this.nfa.getAst().extractInnerLiteral()));
    }

    private boolean innerLiteralCanFindMatchStart(DFAStateNodeBuilder unanchoredInitialState, DFAStateNodeBuilder literalLastDFAState) {
        if (!literalLastDFAState.getNfaTransitionSet().getTargetStateSet().isDisjoint(this.nfaFirstStates)) {
            return false;
        }
        TBitSet visited = new TBitSet(this.nextID);
        visited.set(literalLastDFAState.getId());
        visited.set(unanchoredInitialState.getId());
        this.bfsTraversalCur.clear();
        this.bfsTraversalCur.add((DFAStateTransitionBuilder[])literalLastDFAState.getSuccessors());
        while (!this.bfsTraversalCur.isEmpty()) {
            this.bfsTraversalNext.clear();
            for (DFAStateTransitionBuilder[] cur : this.bfsTraversalCur) {
                for (DFAStateTransitionBuilder t2 : cur) {
                    DFAStateNodeBuilder target = t2.getTarget();
                    if (visited.get(target.getId())) continue;
                    visited.set(target.getId());
                    if (!target.getNfaTransitionSet().getTargetStateSet().isDisjoint(this.nfaFirstStates)) {
                        this.bfsTraversalNext.clear();
                        return false;
                    }
                    this.bfsExpand(target);
                }
            }
            this.bfsSwapLists();
        }
        return true;
    }

    private boolean innerLiteralMatchesPrefix(StateSet<NFA, NFAState> prefixNFAStates) {
        if (this.innerLiteralTryMatchPrefix(prefixNFAStates, this.entryStates[0].getNfaTransitionSet().getTargetStateSet().copy())) {
            return true;
        }
        for (NFAState s2 : prefixNFAStates) {
            StateSet<NFA, NFAState> start = StateSet.create(this.nfa);
            start.add(s2);
            if (!this.innerLiteralTryMatchPrefix(prefixNFAStates, start)) continue;
            return true;
        }
        return false;
    }

    private boolean innerLiteralTryMatchPrefix(StateSet<NFA, NFAState> prefixNFAStates, StateSet<NFA, NFAState> start) {
        int literalEnd = this.nfa.getAst().getProperties().getInnerLiteralEnd();
        int literalStart = this.nfa.getAst().getProperties().getInnerLiteralStart();
        Sequence rootSeq = this.nfa.getAst().getRoot().getFirstAlternative();
        StateSet<NFA, NFAState> curState = start.copy();
        StateSet<NFA, Object> nextState = StateSet.create(this.nfa);
        for (int i2 = literalStart; i2 < literalEnd; ++i2) {
            CodePointSet c2 = ((CharacterClass)rootSeq.getTerms().get(i2)).getCharSet();
            for (NFAState s2 : curState) {
                for (NFAStateTransition t2 : (NFAStateTransition[])s2.getSuccessors()) {
                    if (i2 == literalStart && !prefixNFAStates.contains(t2.getTarget()) || !c2.intersects(t2.getCodePointSet())) continue;
                    nextState.add(t2.getTarget());
                }
            }
            if (nextState.isEmpty()) {
                return false;
            }
            StateSet<NFA, NFAState> tmp = curState;
            curState = nextState;
            nextState = tmp;
            nextState.clear();
        }
        return true;
    }

    private void registerStateReplacement(int id, DFAAbstractStateNode replacement) {
        if (this.stateReplacements == null) {
            this.stateReplacements = EconomicMap.create();
        }
        this.stateReplacements.put(id, replacement);
    }

    private DFAAbstractStateNode getReplacement(int id) {
        return this.stateReplacements == null ? null : (DFAAbstractStateNode)this.stateReplacements.get(id);
    }

    private DFAAbstractStateNode[] createDFAExecutorStates() {
        if (this.isGenericCG()) {
            this.initialCGTransitions = new DFACaptureGroupTransitionBuilder[this.entryStates.length];
            for (DFAStateNodeBuilder s2 : this.stateMap.values()) {
                int i2;
                if (s2.isInitialState()) {
                    DFACaptureGroupTransitionBuilder initialCGTransition = this.createInitialCGTransition(s2);
                    s2.addPredecessorUnchecked(initialCGTransition);
                    for (i2 = 0; i2 < this.entryStates.length; ++i2) {
                        if (this.entryStates[i2] != s2) continue;
                        assert (this.initialCGTransitions[i2] == null);
                        this.initialCGTransitions[i2] = initialCGTransition;
                    }
                }
                DFAStateTransitionBuilder[] dFAStateTransitionBuilderArray = (DFAStateTransitionBuilder[])s2.getSuccessors();
                i2 = dFAStateTransitionBuilderArray.length;
                for (int i3 = 0; i3 < i2; ++i3) {
                    Object t2 = dFAStateTransitionBuilderArray[i3];
                    ((DFAStateTransitionBuilder)t2).getTarget().addPredecessor(t2);
                }
            }
        }
        boolean utf16MustDecode = false;
        DFAAbstractStateNode[] ret = new DFAAbstractStateNode[this.stateMap.values().size() + 1];
        for (DFAStateNodeBuilder s3 : this.stateMap.values()) {
            this.matchersBuilder.reset(((DFAStateTransitionBuilder[])s3.getSuccessors()).length);
            assert (s3.getId() <= Short.MAX_VALUE);
            short id = (short)s3.getId();
            DFAAbstractStateNode replacement = this.getReplacement(id);
            if (replacement != null) {
                ret[id] = replacement;
                continue;
            }
            DFASimpleCGTransition[] simpleCGTransitions = this.doSimpleCG ? new DFASimpleCGTransition[((DFAStateTransitionBuilder[])s3.getSuccessors()).length] : null;
            int nRanges = 0;
            int estimatedTransitionsCost = 0;
            boolean coversCharSpace = s3.coversFullCharSpace(this.compilationBuffer);
            for (int i4 = 0; i4 < ((DFAStateTransitionBuilder[])s3.getSuccessors()).length; ++i4) {
                DFAStateTransitionBuilder t3 = ((DFAStateTransitionBuilder[])s3.getSuccessors())[i4];
                CodePointSet cps = t3.getCodePointSet();
                utf16MustDecode |= Constants.ASTRAL_SYMBOLS_AND_LONE_SURROGATES.intersects(cps);
                if (i4 == ((DFAStateTransitionBuilder[])s3.getSuccessors()).length - 1 && (coversCharSpace || this.pruneUnambiguousPaths && !s3.isFinalStateSuccessor())) {
                    this.matchersBuilder.setNoMatchSuccessor((short)i4);
                } else {
                    nRanges += cps.size();
                    this.getEncoding().createMatcher(this.matchersBuilder, i4, cps, this.compilationBuffer);
                }
                estimatedTransitionsCost += this.matchersBuilder.estimatedCost(i4);
                if (!this.doSimpleCG) continue;
                assert (t3.getTransitionSet().size() <= 2);
                assert (t3.getTransitionSet().size() == 1 || t3.getTransitionSet().getTransition(0) != this.nfa.getInitialLoopBackTransition());
                simpleCGTransitions[i4] = this.createSimpleCGTransition((NFAStateTransition)t3.getTransitionSet().getTransition(0));
            }
            boolean useTreeTransitionMatcher = nRanges > 1 && MathUtil.log2ceil(nRanges + 2) * 8 < estimatedTransitionsCost;
            Matchers matchers = useTreeTransitionMatcher ? this.createAllTransitionsInOneTreeMatcher(s3, coversCharSpace) : this.getEncoding().toMatchers(this.matchersBuilder);
            short[] successors = s3.getNumberOfSuccessors() > 0 ? new short[s3.getNumberOfSuccessors()] : EmptyArrays.SHORT;
            short indexOfNodeId = -1;
            byte indexOfIsFast = 0;
            short loopToSelf = -1;
            for (int i5 = 0; i5 < ((DFAStateTransitionBuilder[])s3.getSuccessors()).length; ++i5) {
                successors[i5] = (short)((DFAStateTransitionBuilder[])s3.getSuccessors())[i5].getTarget().getId();
                if (successors[i5] == id) {
                    TruffleString.CodePointSet indexOfParam;
                    loopToSelf = (short)i5;
                    CodePointSet loopMB = ((DFAStateTransitionBuilder[])s3.getSuccessors())[i5].getCodePointSet();
                    CodePointSet inverse = loopMB.createInverse(this.getEncoding());
                    if (!(!coversCharSpace || loopMB.matchesEverything(this.getEncoding()) || this.getEncoding() == Encodings.UTF_16 && inverse.intersects(Constants.SURROGATES) || (indexOfIsFast = DFAGenerator.checkIndexOfIsFast(indexOfParam = TruffleString.CodePointSet.fromRanges(inverse.getRanges(), this.getEncoding().getTStringEncoding()))) == 0)) {
                        this.indexOfParams.add(indexOfParam);
                        assert (this.indexOfParams.size() <= Short.MAX_VALUE);
                        indexOfNodeId = (short)(this.indexOfParams.size() - 1);
                    }
                }
                assert (successors[i5] >= 0 && successors[i5] < ret.length);
            }
            if (s3.hasBackwardPrefixState()) {
                successors[successors.length - 1] = s3.getBackwardPrefixState();
            }
            byte flags = DFAStateNode.buildFlags(s3.isUnAnchoredFinalState(), s3.isAnchoredFinalState(), s3.hasBackwardPrefixState(), utf16MustDecode);
            DFASimpleCG simpleCG = null;
            if (this.doSimpleCG) {
                simpleCG = DFASimpleCG.create(simpleCGTransitions, this.createSimpleCGTransition(s3.getUnAnchoredFinalStateTransition()), this.createSimpleCGTransition(s3.getAnchoredFinalStateTransition()));
            }
            DFAStateNode stateNode = this.isGenericCG() ? this.createCGTrackingDFAState(s3, id, matchers, successors, indexOfNodeId, indexOfIsFast, loopToSelf, flags) : (this.nfa.isTraceFinderNFA() ? new TraceFinderDFAStateNode(id, flags, loopToSelf, indexOfNodeId, indexOfIsFast, successors, matchers, s3.getPreCalculatedUnAnchoredResult(), s3.getPreCalculatedAnchoredResult()) : (this.isForward() ? new DFAStateNode(id, flags, loopToSelf, indexOfNodeId, indexOfIsFast, successors, matchers, simpleCG) : new BackwardDFAStateNode(id, flags, loopToSelf, indexOfNodeId, indexOfIsFast, successors, matchers, simpleCG)));
            ret[id] = stateNode;
        }
        if (this.isGenericCG()) {
            for (DFAStateNodeBuilder s4 : this.stateMap.values()) {
                short[] lastTransitionIndex = ((CGTrackingDFAStateNode)ret[s4.getId()]).getLastTransitionIndex();
                for (int i6 = 0; i6 < ((DFAStateTransitionBuilder[])s4.getSuccessors()).length; ++i6) {
                    lastTransitionIndex[i6] = this.getLazyTransition(((DFAStateTransitionBuilder[])s4.getSuccessors())[i6]).getLastTransitionIndex();
                }
            }
        }
        return ret;
    }

    private static byte checkIndexOfIsFast(TruffleString.CodePointSet indexOfParam) {
        byte indexOfIsFast = 0;
        for (TruffleString.CodeRange codeRange : TruffleString.CodeRange.values()) {
            if (!indexOfParam.isIntrinsicCandidate(codeRange)) continue;
            assert (codeRange.ordinal() < 8);
            indexOfIsFast = (byte)(indexOfIsFast | 1 << codeRange.ordinal());
        }
        return indexOfIsFast;
    }

    private CGTrackingDFAStateNode createCGTrackingDFAState(DFAStateNodeBuilder s2, short id, Matchers matchers, short[] successors, short indexOfNodeId, byte indexOfIsFast, short loopToSelf, byte flags) {
        DFACaptureGroupLazyTransition lazyPreFinalTransition;
        DFACaptureGroupLazyTransition lazyPreAnchoredFinalTransition;
        int i2;
        DFACaptureGroupLazyTransition[] lazyTransitions = new DFACaptureGroupLazyTransition[((DFAStateTransitionBuilder[])s2.getSuccessors()).length];
        DFACaptureGroupLazyTransitionBuilder firstPredecessor = this.getLazyTransition(s2.getPredecessors()[0]);
        int nMaps = ((DFAStateTransitionBuilder[])s2.getSuccessors()).length;
        int iTransitionToFinalState = firstPredecessor.getTransitionToFinalState() == null ? -1 : nMaps++;
        int iTransitionToAnchoredFinalState = firstPredecessor.getTransitionToAnchoredFinalState() == null ? -1 : nMaps++;
        EconomicMap[] maps = new EconomicMap[nMaps];
        int maxDedupSize = 0;
        for (i2 = 0; i2 < maps.length; ++i2) {
            EconomicMap dedup;
            maps[i2] = dedup = EconomicMap.create();
            for (int j2 = 0; j2 < s2.getPredecessors().length; ++j2) {
                DFACaptureGroupPartialTransition partialTransition;
                DFACaptureGroupLazyTransitionBuilder predecessor = this.getLazyTransition(s2.getPredecessors()[j2]);
                assert (iTransitionToFinalState >= 0 || predecessor.getTransitionToFinalState() == null);
                assert (iTransitionToAnchoredFinalState >= 0 || predecessor.getTransitionToAnchoredFinalState() == null);
                if (i2 < predecessor.getPartialTransitions().length) {
                    partialTransition = predecessor.getPartialTransitions()[i2];
                } else if (i2 == iTransitionToAnchoredFinalState) {
                    partialTransition = predecessor.getTransitionToAnchoredFinalState();
                } else {
                    assert (i2 == iTransitionToFinalState);
                    partialTransition = predecessor.getTransitionToFinalState();
                }
                assert (partialTransition != null);
                if (dedup.containsKey(partialTransition)) {
                    ((ArrayList)dedup.get(partialTransition)).add(j2);
                    continue;
                }
                ArrayList<Integer> list = new ArrayList<Integer>();
                list.add(j2);
                dedup.put(partialTransition, list);
            }
            maxDedupSize = Math.max(maxDedupSize, dedup.size());
        }
        if (nMaps == 0 || maxDedupSize == 1) {
            for (DFAStateTransitionBuilder p2 : s2.getPredecessors()) {
                this.getLazyTransition(p2).setLastTransitionIndex(-1);
            }
            lazyPreAnchoredFinalTransition = DFAGenerator.createSingleLazyTransition(maps, iTransitionToAnchoredFinalState);
            lazyPreFinalTransition = DFAGenerator.createSingleLazyTransition(maps, iTransitionToFinalState);
            for (i2 = 0; i2 < lazyTransitions.length; ++i2) {
                lazyTransitions[i2] = DFAGenerator.createSingleLazyTransition(maps, i2);
            }
        } else if (DFAGenerator.allSameValues(maps)) {
            int iPartialTransition = 0;
            UnmodifiableMapCursor cursor = maps[0].getEntries();
            while (cursor.advance()) {
                Iterator j2 = ((ArrayList)cursor.getValue()).iterator();
                while (j2.hasNext()) {
                    int i3 = (Integer)j2.next();
                    this.getLazyTransition(s2.getPredecessors()[i3]).setLastTransitionIndex(iPartialTransition);
                }
                ++iPartialTransition;
            }
            for (int i4 = 0; i4 < lazyTransitions.length; ++i4) {
                lazyTransitions[i4] = this.createBranchesDirect(s2, maps, i4);
            }
            lazyPreAnchoredFinalTransition = this.createBranchesDirect(s2, maps, iTransitionToAnchoredFinalState);
            lazyPreFinalTransition = this.createBranchesDirect(s2, maps, iTransitionToFinalState);
        } else {
            for (i2 = 0; i2 < s2.getPredecessors().length; ++i2) {
                this.getLazyTransition(s2.getPredecessors()[i2]).setLastTransitionIndex(i2);
            }
            for (i2 = 0; i2 < lazyTransitions.length; ++i2) {
                lazyTransitions[i2] = this.createWithLookup(s2, maps, i2);
            }
            lazyPreAnchoredFinalTransition = this.createWithLookup(s2, maps, iTransitionToAnchoredFinalState);
            lazyPreFinalTransition = this.createWithLookup(s2, maps, iTransitionToFinalState);
        }
        DFACaptureGroupPartialTransition cgLoopToSelf = null;
        boolean cgLoopToSelfHasDependency = false;
        if (loopToSelf >= 0) {
            cgLoopToSelf = this.getLazyTransition(((DFAStateTransitionBuilder[])s2.getSuccessors())[loopToSelf]).getPartialTransitions()[loopToSelf];
            cgLoopToSelfHasDependency = this.calcCGLoopToSelfDependency(cgLoopToSelf);
        }
        short[] lastTransitionIndex = new short[((DFAStateTransitionBuilder[])s2.getSuccessors()).length];
        return new CGTrackingDFAStateNode(id, flags, loopToSelf, indexOfNodeId, indexOfIsFast, successors, matchers, lastTransitionIndex, lazyTransitions, lazyPreAnchoredFinalTransition, lazyPreFinalTransition, this.createCGFinalTransition(s2.getAnchoredFinalStateTransition()), this.createCGFinalTransition(s2.getUnAnchoredFinalStateTransition()), cgLoopToSelf, cgLoopToSelfHasDependency);
    }

    /*
     * WARNING - void declaration
     */
    private boolean calcCGLoopToSelfDependency(DFACaptureGroupPartialTransition cgLoopToSelf) {
        void var7_10;
        byte[] arrayCopies = cgLoopToSelf.getArrayCopies();
        if (cgLoopToSelf.doesReorderResults() || arrayCopies.length == 0) {
            return false;
        }
        int maxArrayIndex = 0;
        for (byte by : arrayCopies) {
            maxArrayIndex = Math.max(maxArrayIndex, Byte.toUnsignedInt(by));
        }
        TBitSet[] updates = new TBitSet[maxArrayIndex + 1];
        DFACaptureGroupPartialTransition.IndexOperation[] indexOperationArray = cgLoopToSelf.getIndexUpdates();
        int n2 = indexOperationArray.length;
        boolean bl = false;
        while (var7_10 < n2) {
            DFACaptureGroupPartialTransition.IndexOperation op = indexOperationArray[var7_10];
            if (op.getTargetArray() <= maxArrayIndex) {
                TBitSet bs = new TBitSet(this.nfa.getAst().getNumberOfCaptureGroups() * 2);
                for (int i3 = 0; i3 < op.getNumberOfIndices(); ++i3) {
                    bs.set(op.getIndex(i3));
                }
                assert (updates[op.getTargetArray()] == null);
                updates[op.getTargetArray()] = bs;
            }
            ++var7_10;
        }
        TBitSet cmp = new TBitSet(this.nfa.getAst().getNumberOfCaptureGroups() * 2);
        for (int i4 = 0; i4 < arrayCopies.length; i4 += 2) {
            int n3 = Byte.toUnsignedInt(arrayCopies[i4]);
            int dst = Byte.toUnsignedInt(arrayCopies[i4 + 1]);
            if (updates[n3] == null) continue;
            if (updates[dst] == null) {
                return true;
            }
            cmp.clear();
            cmp.union(updates[n3]);
            cmp.subtract(updates[dst]);
            if (cmp.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private DFACaptureGroupLazyTransition createWithLookup(DFAStateNodeBuilder s2, EconomicMap<DFACaptureGroupPartialTransition, ArrayList<Integer>>[] maps, int i2) {
        if (i2 < 0) {
            return null;
        }
        EconomicMap<DFACaptureGroupPartialTransition, ArrayList<Integer>> map = maps[i2];
        if (map.size() == 1) {
            return DFAGenerator.createSingleLazyTransition(maps, i2);
        }
        DFACaptureGroupPartialTransition[] transitions = new DFACaptureGroupPartialTransition[map.size()];
        if (DFAGenerator.lookupTableRequired(map)) {
            if (map.size() > 255) {
                throw new UnsupportedRegexException("too many branches in capture group tracking DFA", this.getNfa().getAst().getSource());
            }
            byte[] lookupTable = new byte[s2.getPredecessors().length];
            UnmodifiableMapCursor cursor = map.getEntries();
            int iCursor = 0;
            while (cursor.advance()) {
                transitions[iCursor] = (DFACaptureGroupPartialTransition)cursor.getKey();
                Iterator iterator = ((ArrayList)cursor.getValue()).iterator();
                while (iterator.hasNext()) {
                    int t2 = (Integer)iterator.next();
                    lookupTable[t2] = (byte)iCursor;
                }
                ++iCursor;
            }
            return DFACaptureGroupLazyTransition.BranchesWithLookupTable.create(transitions, lookupTable);
        }
        short[] possibleValues = new short[map.size() - 1];
        UnmodifiableMapCursor cursor = map.getEntries();
        int iCursor = 0;
        DFACaptureGroupPartialTransition last = null;
        while (cursor.advance()) {
            if (((ArrayList)cursor.getValue()).size() == 1 && iCursor < transitions.length - 1) {
                transitions[iCursor] = (DFACaptureGroupPartialTransition)cursor.getKey();
                possibleValues[iCursor] = ((Integer)((ArrayList)cursor.getValue()).get(0)).shortValue();
                ++iCursor;
                continue;
            }
            assert (last == null);
            last = (DFACaptureGroupPartialTransition)cursor.getKey();
        }
        if (last != null) {
            transitions[transitions.length - 1] = last;
        }
        return DFACaptureGroupLazyTransition.BranchesIndirect.create(transitions, possibleValues);
    }

    private static boolean lookupTableRequired(EconomicMap<DFACaptureGroupPartialTransition, ArrayList<Integer>> map) {
        boolean foundSizeGreaterOne = false;
        for (ArrayList l2 : map.getValues()) {
            if (l2.size() <= 1) continue;
            if (foundSizeGreaterOne) {
                return true;
            }
            foundSizeGreaterOne = true;
        }
        return false;
    }

    private DFACaptureGroupLazyTransition.BranchesDirect createBranchesDirect(DFAStateNodeBuilder s2, EconomicMap<DFACaptureGroupPartialTransition, ArrayList<Integer>>[] maps, int i2) {
        if (i2 < 0) {
            return null;
        }
        DFACaptureGroupPartialTransition[] transitions = new DFACaptureGroupPartialTransition[maps[0].size()];
        UnmodifiableMapCursor cursor = maps[i2].getEntries();
        while (cursor.advance()) {
            short iT = this.getLazyTransition(s2.getPredecessors()[(Integer)((ArrayList)cursor.getValue()).get(0)]).getLastTransitionIndex();
            assert (iT >= 0);
            Iterator iterator = ((ArrayList)cursor.getValue()).iterator();
            while (iterator.hasNext()) {
                int j2 = (Integer)iterator.next();
                assert (this.getLazyTransition(s2.getPredecessors()[j2]).getLastTransitionIndex() == iT);
            }
            assert (transitions[iT] == null);
            transitions[iT] = (DFACaptureGroupPartialTransition)cursor.getKey();
        }
        return DFACaptureGroupLazyTransition.BranchesDirect.create(transitions);
    }

    private static DFACaptureGroupLazyTransition.Single createSingleLazyTransition(EconomicMap<DFACaptureGroupPartialTransition, ArrayList<Integer>>[] maps, int i2) {
        if (i2 < 0) {
            return null;
        }
        return DFACaptureGroupLazyTransition.Single.create((DFACaptureGroupPartialTransition)maps[i2].getKeys().iterator().next());
    }

    private DFACaptureGroupTransitionBuilder createInitialCGTransition(DFAStateNodeBuilder target) {
        assert (target.isInitialState());
        DFACaptureGroupTransitionBuilder ret = new DFACaptureGroupTransitionBuilder(null, null, null);
        Object[] partialTransitions = new DFACaptureGroupPartialTransition[((DFAStateTransitionBuilder[])target.getSuccessors()).length];
        Arrays.fill(partialTransitions, DFACaptureGroupPartialTransition.getEmptyInstance());
        short id = (short)this.transitionIDCounter.inc();
        DFACaptureGroupLazyTransitionBuilder emptyInitialTransition = new DFACaptureGroupLazyTransitionBuilder(id, (DFACaptureGroupPartialTransition[])partialTransitions, target.isUnAnchoredFinalState() ? DFACaptureGroupPartialTransition.getEmptyInstance() : null, target.isAnchoredFinalState() ? DFACaptureGroupPartialTransition.getEmptyInstance() : null);
        ret.setId(id);
        ret.setLazyTransition(emptyInitialTransition);
        return ret;
    }

    private DFACaptureGroupLazyTransitionBuilder getLazyTransition(DFAStateTransitionBuilder precedingTransitions) {
        return ((DFACaptureGroupTransitionBuilder)precedingTransitions).toLazyTransition(this.compilationBuffer);
    }

    private static boolean allSameValues(EconomicMap<DFACaptureGroupPartialTransition, ArrayList<Integer>>[] maps) {
        for (int i2 = 1; i2 < maps.length; ++i2) {
            if (maps[0].size() == maps[i2].size()) continue;
            return false;
        }
        for (ArrayList value : maps[0].getValues()) {
            for (int i3 = 1; i3 < maps.length; ++i3) {
                if (DFAGenerator.allSameValuesInner(maps[i3], value)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean allSameValuesInner(EconomicMap<DFACaptureGroupPartialTransition, ArrayList<Integer>> map, ArrayList<Integer> value) {
        for (ArrayList v2 : map.getValues()) {
            if (!value.equals(v2)) continue;
            return true;
        }
        return false;
    }

    private DFASimpleCGTransition createSimpleCGTransition(NFAStateTransition nfaTransition) {
        return DFASimpleCGTransition.create(nfaTransition, this.isForward() && nfaTransition != null && this.nfa.getInitialLoopBackTransition() != null && nfaTransition.getSource() == this.nfa.getInitialLoopBackTransition().getSource());
    }

    private AllTransitionsInOneTreeMatcher createAllTransitionsInOneTreeMatcher(DFAStateNodeBuilder state, boolean coversCharSpace) {
        DFAStateTransitionBuilder[] transitions = (DFAStateTransitionBuilder[])state.getSuccessors();
        CompressedCodePointSet[] ccpss = new CompressedCodePointSet[coversCharSpace ? transitions.length - 1 : transitions.length];
        for (int i2 = 0; i2 < ccpss.length; ++i2) {
            ccpss[i2] = CompressedCodePointSet.create(transitions[i2].getCodePointSet(), this.compilationBuffer);
        }
        IntRangesBuffer ranges = this.compilationBuffer.getIntRangesBuffer1();
        IntArrayBuffer iterators = this.compilationBuffer.getIntRangesBuffer2().asFixedSizeArray(ccpss.length, 0);
        IntRangesBuffer byteRanges = this.compilationBuffer.getIntRangesBuffer3();
        ShortArrayBuffer successors = this.compilationBuffer.getShortArrayBuffer1();
        ShortArrayBuffer byteSuccessors = this.compilationBuffer.getShortArrayBuffer2();
        ObjectArrayBuffer<long[]> byteBitSets = this.compilationBuffer.getObjectBuffer1();
        ObjectArrayBuffer<AllTransitionsInOneTreeMatcher.AllTransitionsInOneTreeLeafMatcher> byteMatchers = this.compilationBuffer.getObjectBuffer2();
        short noMatchSuccessor = (short)(coversCharSpace ? transitions.length - 1 : -1);
        int lastHi = 0;
        while (true) {
            int i3;
            int minLo = Integer.MAX_VALUE;
            int minCPS = -1;
            for (i3 = 0; i3 < ccpss.length; ++i3) {
                if (iterators.get(i3) >= ccpss[i3].size() || ccpss[i3].getLo(iterators.get(i3)) >= minLo) continue;
                minLo = ccpss[i3].getLo(iterators.get(i3));
                minCPS = i3;
            }
            if (minCPS == -1) break;
            if (minLo != lastHi) {
                successors.add(noMatchSuccessor);
                ranges.add(minLo);
            }
            lastHi = ccpss[minCPS].getHi(iterators.get(minCPS)) + 1;
            if (ccpss[minCPS].hasBitSet(iterators.get(minCPS))) {
                byteRanges.clear();
                byteSuccessors.clear();
                byteBitSets.clear();
                for (i3 = 0; i3 < ccpss.length; ++i3) {
                    if (iterators.get(i3) >= ccpss[i3].size() || !ccpss[i3].hasBitSet(iterators.get(i3)) || BitSets.highByte(ccpss[i3].getLo(iterators.get(i3))) != BitSets.highByte(lastHi - 1)) continue;
                    byteBitSets.add(ccpss[i3].getBitSet(iterators.get(i3)));
                    lastHi = Math.max(lastHi, ccpss[i3].getHi(iterators.get(i3)) + 1);
                    iterators.inc(i3);
                    byteSuccessors.add((short)i3);
                }
                int byteLastHi = minLo;
                while (true) {
                    int byteMinLo = lastHi;
                    int byteMinCPS = -1;
                    for (int i4 = 0; i4 < ccpss.length; ++i4) {
                        if (iterators.get(i4) >= ccpss[i4].size() || ccpss[i4].getLo(iterators.get(i4)) >= byteMinLo) continue;
                        assert (!ccpss[i4].hasBitSet(iterators.get(i4)));
                        assert (ccpss[i4].getHi(iterators.get(i4)) < lastHi);
                        byteMinLo = ccpss[i4].getLo(iterators.get(i4));
                        byteMinCPS = i4;
                    }
                    if (byteMinCPS == -1) break;
                    if (byteMinLo != byteLastHi) {
                        byteSuccessors.add(noMatchSuccessor);
                        byteRanges.add(byteMinLo);
                    }
                    byteSuccessors.add((short)byteMinCPS);
                    byteLastHi = ccpss[byteMinCPS].getHi(iterators.get(byteMinCPS)) + 1;
                    if (byteLastHi < lastHi) {
                        byteRanges.add(byteLastHi);
                    }
                    iterators.inc(byteMinCPS);
                }
                if (byteLastHi != lastHi) {
                    byteSuccessors.add(noMatchSuccessor);
                }
                successors.add((short)((byteMatchers.length() + 2) * -1));
                byteMatchers.add(new AllTransitionsInOneTreeMatcher.AllTransitionsInOneTreeLeafMatcher((long[][])byteBitSets.toArray((ST[])new long[byteBitSets.length()][]), byteSuccessors.toArray(), byteRanges.toArray()));
            } else {
                successors.add((short)minCPS);
                iterators.inc(minCPS);
            }
            if (lastHi > this.getEncoding().getMaxValue()) continue;
            ranges.add(lastHi);
        }
        if (lastHi != this.getEncoding().getMaxValue() + 1) {
            successors.add(noMatchSuccessor);
        }
        return new AllTransitionsInOneTreeMatcher(ranges.toArray(), successors.toArray(), byteMatchers.toArray(new AllTransitionsInOneTreeMatcher.AllTransitionsInOneTreeLeafMatcher[byteMatchers.length()]));
    }

    private DFACaptureGroupPartialTransition createCGFinalTransition(NFAStateTransition transition) {
        if (transition == null) {
            return null;
        }
        GroupBoundaries groupBoundaries = transition.getGroupBoundaries();
        DFACaptureGroupPartialTransition.IndexOperation[] indexUpdates = DFACaptureGroupPartialTransition.EMPTY_INDEX_OPS;
        DFACaptureGroupPartialTransition.IndexOperation[] indexClears = DFACaptureGroupPartialTransition.EMPTY_INDEX_OPS;
        DFACaptureGroupPartialTransition.LastGroupUpdate[] lastGroupUpdates = DFACaptureGroupPartialTransition.EMPTY_LAST_GROUP_UPDATES;
        if (groupBoundaries.hasIndexUpdates()) {
            indexUpdates = new DFACaptureGroupPartialTransition.IndexOperation[]{new DFACaptureGroupPartialTransition.IndexOperation(0, groupBoundaries.updatesToByteArray())};
        }
        if (groupBoundaries.hasIndexClears()) {
            indexClears = new DFACaptureGroupPartialTransition.IndexOperation[]{new DFACaptureGroupPartialTransition.IndexOperation(0, groupBoundaries.clearsToByteArray())};
        }
        if (groupBoundaries.hasLastGroup()) {
            lastGroupUpdates = new DFACaptureGroupPartialTransition.LastGroupUpdate[]{new DFACaptureGroupPartialTransition.LastGroupUpdate(0, groupBoundaries.getLastGroup())};
        }
        DFACaptureGroupPartialTransition partialTransitionNode = DFACaptureGroupPartialTransition.create(this, DFACaptureGroupPartialTransition.EMPTY, DFACaptureGroupPartialTransition.EMPTY, indexUpdates, indexClears, lastGroupUpdates, (byte)0);
        if (this.debugMode()) {
            DFACaptureGroupTransitionBuilder.PartialTransitionDebugInfo debugInfo = new DFACaptureGroupTransitionBuilder.PartialTransitionDebugInfo(partialTransitionNode, 1);
            debugInfo.mapResultToNFATransition(0, transition);
            this.registerCGPartialTransitionDebugInfo(debugInfo);
        }
        return partialTransitionNode;
    }

    void updateMaxNumberOfNFAStatesInOneTransition(int value) {
        if (value > this.maxNumberOfNfaStates) {
            this.maxNumberOfNfaStates = value;
            if (this.maxNumberOfNfaStates > 255) {
                throw new UnsupportedRegexException("DFA transition size explosion");
            }
        }
    }

    private DFAAbstractStateNode[] tryMakeReducible(DFAAbstractStateNode[] states) {
        try {
            if (this.debugMode()) {
                return DFANodeSplit.createReducibleGraphAndUpdateDFAGen(this, states);
            }
            return DFANodeSplit.createReducibleGraph(states);
        }
        catch (DFANodeSplitBailoutException e2) {
            return states;
        }
    }

    private boolean debugMode() {
        return this.getOptions().isDumpAutomata() || this.getOptions().isStepExecution();
    }

    public String getDebugDumpName(String name) {
        return name == null ? this.getDebugDumpName() : name;
    }

    public String getDebugDumpName() {
        if (this.isForward()) {
            if (this.isGenericCG()) {
                if (this.isSearching()) {
                    return "eagerCG";
                }
                return "lazyCG";
            }
            return "forward";
        }
        if (this.nfa.isTraceFinderNFA()) {
            return "traceFinder";
        }
        return "backward";
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        if (this.isForward()) {
            this.nfa.setInitialLoopBack(this.isSearching() && !this.nfa.getAst().getFlags().isSticky());
        }
        DFAStateTransitionBuilder[] transitionList = new DFAStateTransitionBuilder[this.transitionIDCounter.getCount()];
        for (DFAStateNodeBuilder s2 : this.getStateIndexMap()) {
            if (s2 == null) continue;
            DFAStateTransitionBuilder[] dFAStateTransitionBuilderArray = (DFAStateTransitionBuilder[])s2.getSuccessors();
            int n2 = dFAStateTransitionBuilderArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                DFAStateTransitionBuilder t2;
                transitionList[t2.getId()] = t2 = dFAStateTransitionBuilderArray[i2];
            }
        }
        return Json.obj(Json.prop("pattern", this.nfa.getAst().getSource().toString()), Json.prop("nfa", this.nfa.toJson(this.isForward())), Json.prop("dfa", Json.obj(Json.prop("states", Arrays.stream(this.getStateIndexMap())), Json.prop("transitions", Arrays.stream(transitionList)), Json.prop("captureGroupPartialTransitions", this.cgPartialTransitions), Json.prop("entryStates", Arrays.stream(this.entryStates).filter(Objects::nonNull).map(x2 -> Json.val(x2.getId()))))));
    }
}

