/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.errors;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.tregex.parser.Token;

public interface JavaErrorMessages {
    public static final String EXPECTED_BRACE = "expected }";
    public static final String EXPECTED_PAREN = "expected )";
    public static final String MISSING_DASH_COLON_PAREN = "missing -, : or )";
    public static final String MISSING_FLAG_DASH_COLON_PAREN = "missing flag, -, : or )";
    public static final String INVALID_GROUP_NAME_START = "capturing group name does not start with a Latin letter";
    public static final String INVALID_GROUP_NAME_REST = "named capturing group is missing trailing '>'";
    public static final String ILLEGAL_REPETITION = "Illegal repetition range";
    public static final String ILLEGAL_CHARACTER_RANGE = "Illegal character range";
    public static final String ILLEGAL_HEX_ESCAPE = "Illegal hexadecimal escape sequence";
    public static final String TOO_BIG_NUMBER = "too big number";
    public static final String UNBALANCED_PARENTHESIS = "unbalanced parenthesis";
    public static final String UNDEFINED_GROUP_OPTION = "undefined group option";
    public static final String UNCLOSED_GROUP = "Unclosed group";
    public static final String UNEXPECTED_END_OF_PATTERN = "unexpected end of pattern";
    public static final String UNTERMINATED_CHARACTER_SET = "unterminated character set";
    public static final String UNTERMINATED_SUBPATTERN = "missing ), unterminated subpattern";
    public static final String UNCLOSED_COUNTED_CLOSURE = "Unclosed counted closure";
    public static final String UNCLOSED_CHARACTER_CLASS = "Unclosed character class";
    public static final String NAMED_CAPTURE_GROUP_REFERENCE_MISSING_BEGIN = "\\k is not followed by '<' for named capturing group";
    public static final String UNKNOWN_INLINE_MODIFIER = "Unknown inline modifier";
    public static final String ILLEGAL_OCT_ESCAPE = "Illegal octal escape sequence";
    public static final String UNESCAPED_TRAILING_BACKSLASH = "Unescaped trailing backslash";
    public static final String BAD_CLASS_SYNTAX = "Bad class syntax";
    public static final String BAD_INTERSECTION_SYNTAX = "Bad intersection syntax";
    public static final String UNCLOSED_CHAR_FAMILY = "Unclosed character family";
    public static final String EMPTY_CHAR_FAMILY = "Empty character family";
    public static final String HEX_TOO_BIG = "Hexadecimal codepoint is too big";
    public static final String UNCLOSED_HEX = "Unclosed hexadecimal escape sequence";
    public static final String UNCLOSED_CHAR_NAME = "Unclosed character name escape sequence";
    public static final String ILLEGAL_CHARACTER_NAME = "Illegal character name escape sequence";
    public static final String ILLEGAL_CTRL_SEQ = "Illegal control escape sequence";
    public static final String ILLEGAL_UNICODE_ESC_SEQ = "Illegal Unicode escape sequence";
    public static final String ILLEGAL_ESCAPE_SEQUENCE = "Illegal/unsupported escape sequence";

    @CompilerDirectives.TruffleBoundary
    public static String badCharacterRange(String range) {
        return "bad character range " + range;
    }

    @CompilerDirectives.TruffleBoundary
    public static String badEscape(String code) {
        return "bad escape \\u" + code;
    }

    @CompilerDirectives.TruffleBoundary
    public static String incompleteEscape(String code) {
        return "incomplete escape \\u" + code;
    }

    @CompilerDirectives.TruffleBoundary
    public static String invalidUnicodeEscape(String code) {
        return "unicode escape value " + code + " outside of range 0-0x10FFFF";
    }

    @CompilerDirectives.TruffleBoundary
    public static String unknownExtension(int c2) {
        return "unknown extension ?" + new String(Character.toChars(c2));
    }

    @CompilerDirectives.TruffleBoundary
    public static String unterminatedName(char terminator) {
        return "missing " + terminator + ", unterminated name";
    }

    @CompilerDirectives.TruffleBoundary
    public static String groupRedefinition(String name) {
        return "Named capturing group <" + name + "> is already defined";
    }

    @CompilerDirectives.TruffleBoundary
    public static String unknownGroupReference(String name) {
        return "named capturing group <" + name + "> does not exist";
    }

    @CompilerDirectives.TruffleBoundary
    public static String unknownUnicodeProperty(String name, String value) {
        return "Unknown Unicode property {name=<" + name + ">, value=<" + value + ">}";
    }

    @CompilerDirectives.TruffleBoundary
    public static String unknownUnicodeCharacterProperty(String name) {
        return "Unknown character property name {" + name + "}";
    }

    @CompilerDirectives.TruffleBoundary
    public static String unknownCharacterName(String name) {
        return "Unknown character name [" + name + "]";
    }

    @CompilerDirectives.TruffleBoundary
    public static String danglingMetaCharacter(Token.Quantifier quantifier) {
        return "Dangling meta character '" + quantifier.toStringNoSuffix() + "'";
    }
}

