/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins.temporal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalCalendarHolder;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainTime;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import java.time.LocalTime;

@ExportLibrary(value=InteropLibrary.class)
public final class JSTemporalPlainTimeObject
extends JSTemporalCalendarHolder {
    private final int hour;
    private final int minute;
    private final int second;
    private final int millisecond;
    private final int microsecond;
    private final int nanosecond;

    protected JSTemporalPlainTimeObject(Shape shape, JSDynamicObject proto, int hour, int minute, int second, int millisecond, int microsecond, int nanosecond, Object calendar) {
        super(shape, proto, calendar);
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.millisecond = millisecond;
        this.microsecond = microsecond;
        this.nanosecond = nanosecond;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public int getMillisecond() {
        return this.millisecond;
    }

    public int getMicrosecond() {
        return this.microsecond;
    }

    public int getNanosecond() {
        return this.nanosecond;
    }

    @ExportMessage
    boolean isTime() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    LocalTime asTime() {
        int ns = this.millisecond * 1000000 + this.microsecond * 1000 + this.nanosecond;
        return LocalTime.of(this.hour, this.minute, this.second, ns);
    }

    @Override
    public TruffleString getClassName() {
        return JSTemporalPlainTime.TO_STRING_TAG;
    }
}

