/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.ToDisplayStringFormat;
import com.oracle.truffle.js.runtime.builtins.JSString;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSNonProxyObject;

@ExportLibrary(value=InteropLibrary.class)
public final class JSStringObject
extends JSNonProxyObject {
    private final TruffleString string;

    protected JSStringObject(Shape shape, JSDynamicObject proto, TruffleString string) {
        super(shape, proto);
        this.string = string;
    }

    public TruffleString getString() {
        return this.string;
    }

    public static JSStringObject create(Shape shape, JSDynamicObject proto, TruffleString value) {
        return new JSStringObject(shape, proto, value);
    }

    @Override
    public TruffleString getClassName() {
        return this.getBuiltinToStringTag();
    }

    @Override
    public TruffleString getBuiltinToStringTag() {
        return JSString.CLASS_NAME;
    }

    @ExportMessage
    public boolean isString() {
        return true;
    }

    @ExportMessage
    public String asString() {
        return Strings.toJavaString(JSString.getString(this));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public TruffleString toDisplayStringImpl(boolean allowSideEffects, ToDisplayStringFormat format, int depth) {
        if (JavaScriptLanguage.get(null).getJSContext().isOptionNashornCompatibilityMode()) {
            return Strings.concatAll(Strings.BRACKET_OPEN, JSString.CLASS_NAME, Strings.SPACE, JSString.getString(this), Strings.BRACKET_CLOSE);
        }
        return JSRuntime.objectToDisplayString(this, allowSideEffects, format, depth, this.getBuiltinToStringTag(), new TruffleString[]{Strings.PRIMITIVE_VALUE}, new Object[]{JSString.getString(this)});
    }
}

