/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.intl;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.cast.JSToBooleanNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.intl.GetStringOrBooleanOptionNodeGen;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.List;

public abstract class GetStringOrBooleanOptionNode
extends JavaScriptBaseNode {
    private final List<String> values;
    private final Object trueValue;
    private final Object falsyValue;
    private final Object fallback;
    @Node.Child
    PropertyGetNode propertyGetNode;

    protected GetStringOrBooleanOptionNode(JSContext context, TruffleString property, List<String> values, Object trueValue, Object falsyValue, Object fallback) {
        this.values = values;
        this.trueValue = trueValue;
        this.falsyValue = falsyValue;
        this.fallback = fallback;
        this.propertyGetNode = PropertyGetNode.create(property, false, context);
    }

    public abstract Object executeValue(Object var1);

    public static GetStringOrBooleanOptionNode create(JSContext context, TruffleString property, List<String> values, Object trueValue, Object falsyValue, Object fallback) {
        return GetStringOrBooleanOptionNodeGen.create(context, property, values, trueValue, falsyValue, fallback);
    }

    @Specialization
    public Object getOption(Object options, @Cached(inline=true) JSToBooleanNode toBooleanNode, @Cached JSToStringNode toStringNode, @Cached TruffleString.ToJavaStringNode toJavaStringNode) {
        Object value = this.propertyGetNode.getValue(options);
        if (value == Undefined.instance) {
            return this.fallback;
        }
        if (value == Boolean.TRUE) {
            return this.trueValue;
        }
        boolean valueBoolean = toBooleanNode.executeBoolean(this, value);
        if (this.propertyGetNode.getContext().getEcmaScriptVersion() < 14) {
            return valueBoolean ? this.trueValue : this.falsyValue;
        }
        if (!valueBoolean) {
            return this.falsyValue;
        }
        String stringValue = toJavaStringNode.execute(toStringNode.executeString(value));
        if ("true".equals(stringValue) || "false".equals(stringValue)) {
            return this.fallback;
        }
        this.checkIfAllowed(stringValue);
        return stringValue;
    }

    @CompilerDirectives.TruffleBoundary
    private void checkIfAllowed(String value) {
        if (!this.values.contains(value)) {
            throw Errors.createRangeError(String.format("invalid option %s", value));
        }
    }
}

