/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.temporal.JSTemporalBuiltinOperation;
import com.oracle.truffle.js.builtins.temporal.TemporalCalendarPrototypeBuiltinsFactory;
import com.oracle.truffle.js.nodes.access.GetIteratorNode;
import com.oracle.truffle.js.nodes.access.IteratorCloseNode;
import com.oracle.truffle.js.nodes.access.IteratorStepNode;
import com.oracle.truffle.js.nodes.access.IteratorValueNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerOrInfinityNode;
import com.oracle.truffle.js.nodes.cast.JSToObjectNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.temporal.GetTemporalUnitNode;
import com.oracle.truffle.js.nodes.temporal.SnapshotOwnPropertiesNode;
import com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalDateNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalDurationNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSDate;
import com.oracle.truffle.js.runtime.builtins.temporal.ISODateRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalCalendar;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalCalendarObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDuration;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDurationRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDate;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTimeObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainMonthDay;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainMonthDayObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainYearMonth;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainYearMonthObject;
import com.oracle.truffle.js.runtime.builtins.temporal.TimeDurationRecord;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.util.ArrayList;
import java.util.EnumSet;

public class TemporalCalendarPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<TemporalCalendarPrototype> {
    public static final TemporalCalendarPrototypeBuiltins BUILTINS = new TemporalCalendarPrototypeBuiltins();

    protected TemporalCalendarPrototypeBuiltins() {
        super(JSTemporalCalendar.PROTOTYPE_NAME, TemporalCalendarPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, TemporalCalendarPrototype builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: 
            case 21: 
            case 22: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarIDNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
            case 1: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarMergeFieldsNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 2: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarFieldsNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 3: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarDateFromFieldsNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(2).createArgumentNodes(context));
            }
            case 4: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarYearMonthFromFieldsNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(3).createArgumentNodes(context));
            }
            case 5: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarMonthDayFromFieldsNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(3).createArgumentNodes(context));
            }
            case 6: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarDateAddNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(4).createArgumentNodes(context));
            }
            case 7: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarDateUntilNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(3).createArgumentNodes(context));
            }
            case 8: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarYearNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 9: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarMonthNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 10: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarMonthCodeNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 11: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarDayNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 12: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarDayOfWeekNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 13: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarDayOfYearNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 16: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarDaysInWeekNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 14: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarWeekOfYearNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 15: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarYearOfWeekNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 17: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarDaysInMonthNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 18: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarDaysInYearNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 19: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarMonthsInYearNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case 20: {
                return TemporalCalendarPrototypeBuiltinsFactory.JSTemporalCalendarInLeapYearNodeGen.create(context, builtin, TemporalCalendarPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum TemporalCalendarPrototype implements BuiltinEnum<TemporalCalendarPrototype>
    {
        id(0),
        mergeFields(2),
        fields(1),
        dateFromFields(1),
        yearMonthFromFields(1),
        monthDayFromFields(1),
        dateAdd(2),
        dateUntil(2),
        year(1),
        month(1),
        monthCode(1),
        day(1),
        dayOfWeek(1),
        dayOfYear(1),
        weekOfYear(1),
        yearOfWeek(1),
        daysInWeek(1),
        daysInMonth(1),
        daysInYear(1),
        monthsInYear(1),
        inLeapYear(1),
        toString(0),
        toJSON(0);

        private final int length;

        private TemporalCalendarPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public boolean isGetter() {
            return EnumSet.of(id).contains(this);
        }
    }

    public static abstract class JSTemporalCalendarIDNode
    extends JSBuiltinNode {
        protected JSTemporalCalendarIDNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object id(JSTemporalCalendarObject calendar) {
            return calendar.getId();
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarMergeFields
    extends JSTemporalBuiltinOperation {
        private static final Object[] EMPTY = new Object[0];
        private static final Object[] UNDEFINED_IN_ARRAY = new Object[]{Undefined.instance};

        protected JSTemporalCalendarMergeFields(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSDynamicObject mergeFields(JSTemporalCalendarObject calendar, Object fields, Object additionalFields, @Cached JSToObjectNode toObject, @Cached SnapshotOwnPropertiesNode snapshotOwnProperties) {
            assert (calendar.getId().equals(TemporalConstants.ISO8601));
            JSObject fieldsCopy = snapshotOwnProperties.snapshot(toObject.execute(fields), Null.instance, EMPTY, UNDEFINED_IN_ARRAY);
            JSObject additionalFieldsCopy = snapshotOwnProperties.snapshot(toObject.execute(additionalFields), Null.instance, EMPTY, UNDEFINED_IN_ARRAY);
            return TemporalUtil.defaultMergeFields(this.getContext(), fieldsCopy, additionalFieldsCopy);
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object fieldsParam, Object additionalFieldsParam) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarFields
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarFields(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSDynamicObject fields(JSTemporalCalendarObject calendar, Object fieldsParam, @Cached(inline=true) GetIteratorNode getIteratorNode, @Cached(value="create(getContext())") IteratorCloseNode iteratorCloseNode, @Cached IteratorValueNode getIteratorValueNode, @Cached IteratorStepNode iteratorStepNode) {
            Object next;
            assert (calendar.getId().equals(TemporalConstants.ISO8601));
            IteratorRecord iter = getIteratorNode.execute(this, fieldsParam);
            ArrayList fieldNames = new ArrayList();
            while ((next = iteratorStepNode.execute(iter)) != Boolean.FALSE) {
                Object nextValue = getIteratorValueNode.execute(next);
                if (nextValue instanceof TruffleString) {
                    TruffleString str = (TruffleString)nextValue;
                    if (Boundaries.listContains(fieldNames, str)) {
                        iteratorCloseNode.executeAbrupt(iter.getIterator());
                        throw Errors.createRangeErrorFormat("Duplicate field: %s", null, str);
                    }
                    if (!(TemporalConstants.YEAR.equals(str) || TemporalConstants.MONTH.equals(str) || TemporalConstants.MONTH_CODE.equals(str) || TemporalConstants.DAY.equals(str))) {
                        iteratorCloseNode.executeAbrupt(iter.getIterator());
                        throw Errors.createRangeErrorFormat("Invalid field: %s", null, str);
                    }
                    Boundaries.listAdd(fieldNames, str);
                    continue;
                }
                iteratorCloseNode.executeAbrupt(iter.getIterator());
                throw Errors.createTypeErrorNotAString(nextValue);
            }
            return JSRuntime.createArrayFromList(this.getContext(), this.getRealm(), fieldNames);
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object fieldsParam) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarDateFromFields
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarDateFromFields(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object dateFromFields(JSTemporalCalendarObject calendar, Object fieldsParam, Object optionsParam, @Cached TemporalGetOptionNode getOptionNode, @Cached JSToIntegerOrInfinityNode toIntOrInfinityNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            assert (calendar.getId().equals(TemporalConstants.ISO8601));
            if (!this.isObject(fieldsParam)) {
                errorBranch.enter(this);
                throw TemporalErrors.createTypeErrorFieldsNotAnObject();
            }
            JSDynamicObject options = this.getOptionsObject(optionsParam, this, errorBranch, optionUndefined);
            JSObject fields = TemporalUtil.prepareTemporalFields(this.getContext(), fieldsParam, TemporalUtil.listDMMCY, TemporalUtil.listYD);
            TemporalUtil.Overflow overflow = TemporalUtil.toTemporalOverflow(options, getOptionNode);
            TemporalUtil.isoResolveMonth(this.getContext(), fields, toIntOrInfinityNode);
            ISODateRecord result = TemporalUtil.isoDateFromFields(fields, overflow);
            return JSTemporalPlainDate.create(this.getContext(), this.getRealm(), result.year(), result.month(), result.day(), calendar.getId(), this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object fields, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarYearMonthFromFields
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarYearMonthFromFields(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object yearMonthFromFields(JSTemporalCalendarObject calendar, Object fieldsParam, Object optionsParam, @Cached TemporalGetOptionNode getOptionNode, @Cached JSToIntegerOrInfinityNode toIntOrInfinityNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            assert (calendar.getId().equals(TemporalConstants.ISO8601));
            if (!this.isObject(fieldsParam)) {
                errorBranch.enter(this);
                throw TemporalErrors.createTypeErrorFieldsNotAnObject();
            }
            JSDynamicObject options = this.getOptionsObject(optionsParam, this, errorBranch, optionUndefined);
            JSObject fields = TemporalUtil.prepareTemporalFields(this.getContext(), fieldsParam, TemporalUtil.listMMCY, TemporalUtil.listY);
            TemporalUtil.Overflow overflow = TemporalUtil.toTemporalOverflow(options, getOptionNode);
            TemporalUtil.isoResolveMonth(this.getContext(), fields, toIntOrInfinityNode);
            ISODateRecord result = TemporalUtil.isoYearMonthFromFields(fields, overflow);
            return JSTemporalPlainYearMonth.create(this.getContext(), this.getRealm(), result.year(), result.month(), calendar.getId(), result.day(), this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object fields, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarMonthDayFromFields
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarMonthDayFromFields(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object monthDayFromFields(JSTemporalCalendarObject calendar, Object fieldsParam, Object optionsParam, @Cached TemporalGetOptionNode getOptionNode, @Cached JSToIntegerOrInfinityNode toIntOrInfinityNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            assert (calendar.getId().equals(TemporalConstants.ISO8601));
            if (!this.isObject(fieldsParam)) {
                errorBranch.enter(this);
                throw TemporalErrors.createTypeErrorFieldsNotAnObject();
            }
            JSDynamicObject options = this.getOptionsObject(optionsParam, this, errorBranch, optionUndefined);
            JSObject fields = TemporalUtil.prepareTemporalFields(this.getContext(), fieldsParam, TemporalUtil.listDMMCY, TemporalUtil.listD);
            TemporalUtil.Overflow overflow = TemporalUtil.toTemporalOverflow(options, getOptionNode);
            TemporalUtil.isoResolveMonth(this.getContext(), fields, toIntOrInfinityNode);
            ISODateRecord result = TemporalUtil.isoMonthDayFromFields(fields, overflow);
            return JSTemporalPlainMonthDay.create(this.getContext(), this.getRealm(), result.month(), result.day(), calendar.getId(), result.year(), this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object fields, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarDateAdd
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarDateAdd(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object dateAdd(JSTemporalCalendarObject calendar, Object dateObj, Object durationObj, Object optionsParam, @Cached ToTemporalDurationNode toTemporalDurationNode, @Cached ToTemporalDateNode toTemporalDate, @Cached TemporalGetOptionNode getOptionNode, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            assert (calendar.getId().equals(TemporalConstants.ISO8601));
            JSTemporalPlainDateObject date = toTemporalDate.execute(dateObj);
            JSTemporalDurationObject duration = toTemporalDurationNode.execute(durationObj);
            JSDynamicObject options = this.getOptionsObject(optionsParam, this, errorBranch, optionUndefined);
            TemporalUtil.Overflow overflow = TemporalUtil.toTemporalOverflow(options, getOptionNode);
            JSRealm realm = this.getRealm();
            BigInt norm = TemporalUtil.normalizeTimeDuration(duration.getHours(), duration.getMinutes(), duration.getSeconds(), duration.getMilliseconds(), duration.getMicroseconds(), duration.getNanoseconds());
            TimeDurationRecord balanceResult = TemporalUtil.balanceTimeDuration(norm, TemporalUtil.Unit.DAY);
            double days = duration.getDays() + balanceResult.days();
            ISODateRecord result = TemporalUtil.addISODate(date.getYear(), date.getMonth(), date.getDay(), duration.getYears(), duration.getMonths(), duration.getWeeks(), days, overflow);
            return JSTemporalPlainDate.create(this.getContext(), realm, result.year(), result.month(), result.day(), calendar, this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object dateObj, Object durationObj, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarDateUntil
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarDateUntil(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected Object dateUntil(JSTemporalCalendarObject calendar, Object oneObj, Object twoObj, Object optionsParam, @Cached ToTemporalDateNode toTemporalDate, @Cached GetTemporalUnitNode getLargestUnit, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile optionUndefined) {
            assert (calendar.getId().equals(TemporalConstants.ISO8601));
            JSTemporalPlainDateObject one = toTemporalDate.execute(oneObj);
            JSTemporalPlainDateObject two = toTemporalDate.execute(twoObj);
            JSDynamicObject options = this.getOptionsObject(optionsParam, this, errorBranch, optionUndefined);
            TemporalUtil.Unit largestUnit = getLargestUnit.execute(options, TemporalConstants.LARGEST_UNIT, TemporalUtil.unitMappingDateOrAuto, TemporalUtil.Unit.AUTO);
            if (largestUnit == TemporalUtil.Unit.AUTO) {
                largestUnit = TemporalUtil.Unit.DAY;
            }
            JSTemporalDurationRecord result = JSTemporalPlainDate.differenceISODate(one.getYear(), one.getMonth(), one.getDay(), two.getYear(), two.getMonth(), two.getDay(), largestUnit);
            return JSTemporalDuration.createTemporalDuration(this.getContext(), this.getRealm(), result.getYears(), result.getMonths(), result.getWeeks(), result.getDays(), 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, this, errorBranch);
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object oneObj, Object twoObj, Object optionsParam) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarYear
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarYear(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected long year(JSTemporalCalendarObject calendar, Object temporalDateLike, @Cached ToTemporalDateNode toTemporalDate) {
            int year;
            assert (calendar.getId().equals(TemporalConstants.ISO8601));
            if (temporalDateLike instanceof JSTemporalPlainDateObject) {
                JSTemporalPlainDateObject date = (JSTemporalPlainDateObject)temporalDateLike;
                year = date.getYear();
            } else if (temporalDateLike instanceof JSTemporalPlainDateTimeObject) {
                JSTemporalPlainDateTimeObject dateTime = (JSTemporalPlainDateTimeObject)temporalDateLike;
                year = dateTime.getYear();
            } else if (temporalDateLike instanceof JSTemporalPlainYearMonthObject) {
                JSTemporalPlainYearMonthObject yearMonth = (JSTemporalPlainYearMonthObject)temporalDateLike;
                year = yearMonth.getYear();
            } else {
                JSTemporalPlainDateObject date = toTemporalDate.execute(temporalDateLike);
                year = date.getYear();
            }
            return year;
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDateLike) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarMonth
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarMonth(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected long month(JSTemporalCalendarObject calendar, Object temporalDateLike, @Cached ToTemporalDateNode toTemporalDate) {
            int month;
            assert (calendar.getId().equals(TemporalConstants.ISO8601));
            if (temporalDateLike instanceof JSTemporalPlainDateObject) {
                JSTemporalPlainDateObject date = (JSTemporalPlainDateObject)temporalDateLike;
                month = date.getMonth();
            } else if (temporalDateLike instanceof JSTemporalPlainDateTimeObject) {
                JSTemporalPlainDateTimeObject dateTime = (JSTemporalPlainDateTimeObject)temporalDateLike;
                month = dateTime.getMonth();
            } else if (temporalDateLike instanceof JSTemporalPlainYearMonthObject) {
                JSTemporalPlainYearMonthObject yearMonth = (JSTemporalPlainYearMonthObject)temporalDateLike;
                month = yearMonth.getMonth();
            } else {
                if (temporalDateLike instanceof JSTemporalPlainMonthDayObject) {
                    throw Errors.createTypeError("PlainMonthDay not expected");
                }
                JSTemporalPlainDateObject date = toTemporalDate.execute(temporalDateLike);
                month = date.getMonth();
            }
            return month;
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDateLike) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarMonthCode
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarMonthCode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected TruffleString monthCode(JSTemporalCalendarObject calendar, Object temporalDateLike, @Cached ToTemporalDateNode toTemporalDate) {
            int month;
            assert (calendar.getId().equals(TemporalConstants.ISO8601));
            if (temporalDateLike instanceof JSTemporalPlainDateObject) {
                JSTemporalPlainDateObject date = (JSTemporalPlainDateObject)temporalDateLike;
                month = date.getMonth();
            } else if (temporalDateLike instanceof JSTemporalPlainDateTimeObject) {
                JSTemporalPlainDateTimeObject dateTime = (JSTemporalPlainDateTimeObject)temporalDateLike;
                month = dateTime.getMonth();
            } else if (temporalDateLike instanceof JSTemporalPlainYearMonthObject) {
                JSTemporalPlainYearMonthObject yearMonth = (JSTemporalPlainYearMonthObject)temporalDateLike;
                month = yearMonth.getMonth();
            } else if (temporalDateLike instanceof JSTemporalPlainMonthDayObject) {
                JSTemporalPlainMonthDayObject monthDay = (JSTemporalPlainMonthDayObject)temporalDateLike;
                month = monthDay.getMonth();
            } else {
                JSTemporalPlainDateObject date = toTemporalDate.execute(temporalDateLike);
                month = date.getMonth();
            }
            return TemporalUtil.buildISOMonthCode(month);
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDateLike) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarDay
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarDay(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected long day(JSTemporalCalendarObject calendar, Object temporalDateLike, @Cached ToTemporalDateNode toTemporalDate) {
            int day;
            assert (calendar.getId().equals(TemporalConstants.ISO8601));
            if (temporalDateLike instanceof JSTemporalPlainDateObject) {
                JSTemporalPlainDateObject date = (JSTemporalPlainDateObject)temporalDateLike;
                day = date.getDay();
            } else if (temporalDateLike instanceof JSTemporalPlainDateTimeObject) {
                JSTemporalPlainDateTimeObject dateTime = (JSTemporalPlainDateTimeObject)temporalDateLike;
                day = dateTime.getDay();
            } else if (temporalDateLike instanceof JSTemporalPlainMonthDayObject) {
                JSTemporalPlainMonthDayObject monthDay = (JSTemporalPlainMonthDayObject)temporalDateLike;
                day = monthDay.getDay();
            } else {
                JSTemporalPlainDateObject date = toTemporalDate.execute(temporalDateLike);
                day = date.getDay();
            }
            return day;
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDateLike) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarDayOfWeek
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarDayOfWeek(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected long dayOfWeek(JSTemporalCalendarObject calendar, Object temporalDateLike, @Cached ToTemporalDateNode toTemporalDate) {
            assert (calendar.getId().equals(TemporalConstants.ISO8601));
            JSTemporalPlainDateObject date = toTemporalDate.execute(temporalDateLike);
            return TemporalUtil.toISODayOfWeek(date.getYear(), date.getMonth(), date.getDay());
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDateLike) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarDayOfYear
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarDayOfYear(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected long dayOfYear(JSTemporalCalendarObject calendar, Object temporalDateLike, @Cached ToTemporalDateNode toTemporalDate) {
            assert (calendar.getId().equals(TemporalConstants.ISO8601));
            JSTemporalPlainDateObject date = toTemporalDate.execute(temporalDateLike);
            return TemporalUtil.toISODayOfYear(date.getYear(), date.getMonth(), date.getDay());
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDateLike) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarDaysInWeek
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarDaysInWeek(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected long daysInWeek(JSTemporalCalendarObject calendar, Object temporalDateLike, @Cached ToTemporalDateNode toTemporalDate) {
            assert (calendar.getId().equals(TemporalConstants.ISO8601));
            toTemporalDate.execute(temporalDateLike);
            return 7L;
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDateLike) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarWeekOfYear
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarWeekOfYear(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected long weekOfYear(JSTemporalCalendarObject calendar, Object temporalDateLike, @Cached ToTemporalDateNode toTemporalDate) {
            assert (calendar.getId().equals(TemporalConstants.ISO8601));
            JSTemporalPlainDateObject date = toTemporalDate.execute(temporalDateLike);
            return TemporalUtil.weekOfToISOWeekOfYear(date.getYear(), date.getMonth(), date.getDay());
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDateLike) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarYearOfWeek
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarYearOfWeek(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected long yearOfWeek(JSTemporalCalendarObject calendar, Object temporalDateLike, @Cached ToTemporalDateNode toTemporalDate) {
            assert (calendar.getId().equals(TemporalConstants.ISO8601));
            JSTemporalPlainDateObject date = toTemporalDate.execute(temporalDateLike);
            return TemporalUtil.yearOfToISOWeekOfYear(date.getYear(), date.getMonth(), date.getDay());
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDateLike) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarDaysInMonth
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarDaysInMonth(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected long daysInMonth(JSTemporalCalendarObject calendar, Object temporalDateLike, @Cached ToTemporalDateNode toTemporalDate) {
            int month;
            int year;
            assert (calendar.getId().equals(TemporalConstants.ISO8601));
            if (temporalDateLike instanceof JSTemporalPlainDateObject) {
                JSTemporalPlainDateObject date = (JSTemporalPlainDateObject)temporalDateLike;
                year = date.getYear();
                month = date.getMonth();
            } else if (temporalDateLike instanceof JSTemporalPlainDateTimeObject) {
                JSTemporalPlainDateTimeObject dateTime = (JSTemporalPlainDateTimeObject)temporalDateLike;
                year = dateTime.getYear();
                month = dateTime.getMonth();
            } else if (temporalDateLike instanceof JSTemporalPlainYearMonthObject) {
                JSTemporalPlainYearMonthObject yearMonth = (JSTemporalPlainYearMonthObject)temporalDateLike;
                year = yearMonth.getYear();
                month = yearMonth.getMonth();
            } else {
                JSTemporalPlainDateObject date = toTemporalDate.execute(temporalDateLike);
                year = date.getYear();
                month = date.getMonth();
            }
            return TemporalUtil.isoDaysInMonth(year, month);
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDateLike) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarDaysInYear
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarDaysInYear(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected int daysInYear(JSTemporalCalendarObject calendar, Object temporalDateLike, @Cached ToTemporalDateNode toTemporalDate) {
            int year;
            assert (calendar.getId().equals(TemporalConstants.ISO8601));
            if (temporalDateLike instanceof JSTemporalPlainDateObject) {
                JSTemporalPlainDateObject date = (JSTemporalPlainDateObject)temporalDateLike;
                year = date.getYear();
            } else if (temporalDateLike instanceof JSTemporalPlainDateTimeObject) {
                JSTemporalPlainDateTimeObject dateTime = (JSTemporalPlainDateTimeObject)temporalDateLike;
                year = dateTime.getYear();
            } else if (temporalDateLike instanceof JSTemporalPlainYearMonthObject) {
                JSTemporalPlainYearMonthObject yearMonth = (JSTemporalPlainYearMonthObject)temporalDateLike;
                year = yearMonth.getYear();
            } else {
                JSTemporalPlainDateObject date = toTemporalDate.execute(temporalDateLike);
                year = date.getYear();
            }
            return TemporalUtil.isoDaysInYear(year);
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDateLike) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarMonthsInYear
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarMonthsInYear(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected long monthsInYear(JSTemporalCalendarObject calendar, Object temporalDateLike, @Cached ToTemporalDateNode toTemporalDate) {
            assert (calendar.getId().equals(TemporalConstants.ISO8601));
            if (!(temporalDateLike instanceof JSTemporalPlainDateObject || temporalDateLike instanceof JSTemporalPlainDateTimeObject || temporalDateLike instanceof JSTemporalPlainYearMonthObject)) {
                toTemporalDate.execute(temporalDateLike);
            }
            return 12L;
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDateLike) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }

    public static abstract class JSTemporalCalendarInLeapYear
    extends JSTemporalBuiltinOperation {
        protected JSTemporalCalendarInLeapYear(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected boolean inLeapYear(JSTemporalCalendarObject calendar, Object temporalDateLike, @Cached ToTemporalDateNode toTemporalDate) {
            int year;
            assert (calendar.getId().equals(TemporalConstants.ISO8601));
            if (temporalDateLike instanceof JSTemporalPlainDateObject) {
                JSTemporalPlainDateObject date = (JSTemporalPlainDateObject)temporalDateLike;
                year = date.getYear();
            } else if (temporalDateLike instanceof JSTemporalPlainDateTimeObject) {
                JSTemporalPlainDateTimeObject dateTime = (JSTemporalPlainDateTimeObject)temporalDateLike;
                year = dateTime.getYear();
            } else if (temporalDateLike instanceof JSTemporalPlainYearMonthObject) {
                JSTemporalPlainYearMonthObject yearMonth = (JSTemporalPlainYearMonthObject)temporalDateLike;
                year = yearMonth.getYear();
            } else {
                JSTemporalPlainDateObject dateLike = toTemporalDate.execute(temporalDateLike);
                year = dateLike.getYear();
            }
            return JSDate.isLeapYear(year);
        }

        @Specialization(guards={"!isJSTemporalCalendar(thisObj)"})
        protected static Object invalidReceiver(Object thisObj, Object temporalDateLike) {
            throw TemporalErrors.createTypeErrorTemporalCalendarExpected();
        }
    }
}

