/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.math;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.js.builtins.math.MathOperation;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;

public abstract class AsinhNode
extends MathOperation {
    public AsinhNode(JSContext context, JSBuiltin builtin) {
        super(context, builtin);
    }

    @Specialization
    protected double asinhDouble(double x2, @Cached @Cached.Shared InlinedConditionProfile isNegative) {
        if (JSRuntime.isNegativeZero(x2)) {
            return -0.0;
        }
        if (x2 < 0.0 && Double.isInfinite(x2)) {
            return x2;
        }
        if (isNegative.profile(this, x2 < 0.0)) {
            return -AsinhNode.asinhImpl(-x2);
        }
        return AsinhNode.asinhImpl(x2);
    }

    private static double asinhImpl(double x2) {
        return Math.log(x2 + Math.sqrt(x2 * x2 + 1.0));
    }

    @Specialization
    protected double asinhGeneric(Object a2, @Cached @Cached.Shared InlinedConditionProfile isNegative) {
        return this.asinhDouble(this.toDouble(a2), isNegative);
    }
}

