/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.profiles;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.AbstractInlinedValueProfile;
import com.oracle.truffle.api.profiles.LongValueProfile;
import com.oracle.truffle.api.profiles.Profile;

public final class InlinedLongValueProfile
extends AbstractInlinedValueProfile {
    private static final InlinedLongValueProfile DISABLED;
    private final InlineSupport.LongField cachedValue;

    private InlinedLongValueProfile() {
        this.cachedValue = null;
    }

    private InlinedLongValueProfile(InlineSupport.InlineTarget target) {
        super(target);
        this.cachedValue = target.getPrimitive(1, InlineSupport.LongField.class);
    }

    public long profile(Node node, long value) {
        int localState;
        if (this.state != null && (localState = this.state.get(node)) != 2) {
            long v2;
            if (localState == 1 && (v2 = this.cachedValue.get(node)) == value) {
                return v2;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            if (localState == 0) {
                this.cachedValue.set(node, value);
                this.state.set(node, 1);
            } else {
                this.state.set(node, 2);
            }
        }
        return value;
    }

    long getCachedValue(Node node) {
        return this.cachedValue.get(node);
    }

    @Override
    public String toString(Node node) {
        if (this.state == null) {
            return this.toStringDisabled();
        }
        return this.toString(LongValueProfile.class, this.isUninitialized(node), this.isGeneric(node), String.format("value == (long)%s", this.getCachedValue(node)));
    }

    public static InlinedLongValueProfile inline(@InlineSupport.RequiredFields(value={@InlineSupport.RequiredField(value=InlineSupport.StateField.class, bits=2), @InlineSupport.RequiredField(value=InlineSupport.LongField.class)}) InlineSupport.InlineTarget target) {
        if (Profile.isProfilingEnabled()) {
            return new InlinedLongValueProfile(target);
        }
        return InlinedLongValueProfile.getUncached();
    }

    public static InlinedLongValueProfile getUncached() {
        return DISABLED;
    }

    static {
        InlinedLongValueProfile profile;
        DISABLED = profile = new InlinedLongValueProfile();
    }
}

