/*
 * Decompiled with CFR 0.152.
 */
package net.commoble.hyperbox.blocks;

import io.netty.buffer.ByteBuf;
import net.commoble.hyperbox.Hyperbox;
import net.commoble.hyperbox.blocks.HyperboxMenu;
import net.commoble.hyperbox.dimension.HyperboxDimension;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record C2SSaveHyperboxPacket(String name, boolean enterImmediate) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<C2SSaveHyperboxPacket> TYPE = new CustomPacketPayload.Type(Hyperbox.id("save_hyperbox"));
    public static final StreamCodec<ByteBuf, C2SSaveHyperboxPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, C2SSaveHyperboxPacket::name, (StreamCodec)ByteBufCodecs.BOOL, C2SSaveHyperboxPacket::enterImmediate, C2SSaveHyperboxPacket::new);

    public void handle(IPayloadContext context) {
        context.enqueueWork(() -> this.handleMainThread(context));
    }

    private void handleMainThread(IPayloadContext context) {
        AbstractContainerMenu abstractContainerMenu;
        ServerPlayer player;
        block5: {
            block4: {
                Player p = context.player();
                if (!(p instanceof ServerPlayer)) break block4;
                player = (ServerPlayer)p;
                abstractContainerMenu = player.containerMenu;
                if (abstractContainerMenu instanceof HyperboxMenu) break block5;
            }
            return;
        }
        HyperboxMenu menu = (HyperboxMenu)abstractContainerMenu;
        ResourceLocation dimensionId = HyperboxDimension.generateId((Player)player, this.name);
        ResourceKey levelKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimensionId);
        ServerLevel level = player.serverLevel();
        if (level.getServer().getLevel(levelKey) != null) {
            player.displayClientMessage((Component)Component.translatable((String)"menu.hyperbox.message.existing_id", (Object[])new Object[]{dimensionId}), false);
            player.closeContainer();
            return;
        }
        menu.hyperbox().ifPresentOrElse(hyperbox -> {
            hyperbox.setLevelKey((ResourceKey<Level>)levelKey);
            if (this.name != null && !this.name.isEmpty()) {
                hyperbox.setName((Component)Component.literal((String)this.name));
            }
            if (this.enterImmediate) {
                hyperbox.teleportPlayerOrOpenMenu(player, Direction.DOWN);
            } else {
                player.closeContainer();
            }
        }, () -> ((ServerPlayer)player).closeContainer());
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

