/*
 * Decompiled with CFR 0.152.
 */
package net.commoble.hyperbox;

import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.commoble.hyperbox.dimension.HyperboxChunkGenerator;
import net.commoble.hyperbox.dimension.HyperboxDimension;
import net.commoble.hyperbox.dimension.HyperboxRegionFileStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.chunk.storage.RegionFileStorage;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.dimension.DimensionType;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class MixinCallbacks {
    public static void onIOWorkerConstruction(RegionStorageInfo info, Path path, boolean sync, Consumer<RegionFileStorage> cacheConsumer) {
        String s = path.toString();
        if (s.contains("dimensions/hyperbox") || s.contains("dimensions\\hyperbox")) {
            cacheConsumer.accept(new HyperboxRegionFileStorage(info, path, sync));
        }
    }

    public static void onServerWorldPlaySound(ServerLevel serverLevel, @Nullable Player ignoredPlayer, double x, double y, double z, Holder<SoundEvent> sound, SoundSource category, float volume, float pitch, long seed, CallbackInfo info) {
        MinecraftServer server = serverLevel.getServer();
        List players = server.getPlayerList().getPlayers();
        int playerCount = players.size();
        for (int i = 0; i < playerCount; ++i) {
            double radius;
            DimensionType hyperboxDimensionType;
            ServerLevel playerLevel;
            ServerPlayer serverPlayer = (ServerPlayer)players.get(i);
            if (serverPlayer == null || serverPlayer == ignoredPlayer || (playerLevel = serverPlayer.serverLevel()) == null || (hyperboxDimensionType = HyperboxDimension.getDimensionType(server)) != playerLevel.dimensionType()) continue;
            HyperboxDimension.IterationResult result = HyperboxDimension.getHyperboxIterationDepth(server, serverLevel, playerLevel);
            int iterations = result.iterations();
            BlockPos pos = result.parentPos();
            if (iterations < 0 || pos == null) continue;
            double dx = x - (double)pos.getX();
            double dy = y - (double)pos.getY();
            double dz = z - (double)pos.getZ();
            double d = radius = volume > 1.0f ? (double)volume * 16.0 : 16.0;
            if (!(dx * dx + dy * dy + dz * dz < radius * radius)) continue;
            double soundMultiplier = Math.pow(0.5, iterations);
            float scaledVolume = (float)(soundMultiplier * (double)volume * 0.5);
            float scaledPitch = (float)(soundMultiplier * (double)pitch);
            double packetX = (double)HyperboxChunkGenerator.CENTER.getX() + dx;
            double packetY = (double)HyperboxChunkGenerator.CENTER.getY() + dy;
            double packetZ = (double)HyperboxChunkGenerator.CENTER.getZ() + dz;
            ClientboundSoundPacket packet = new ClientboundSoundPacket(sound, category, packetX, packetY, packetZ, scaledVolume, scaledPitch, seed);
            serverPlayer.connection.send((Packet)packet);
        }
    }
}

