/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.network;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.blockentity.BlockEntityEnergyBattery;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.network.NetworkElementBase;

public class EnergyBatteryNetworkElement
extends NetworkElementBase {
    private final DimPos pos;

    protected Optional<BlockEntityEnergyBattery> getTile() {
        return BlockEntityHelpers.get((DimPos)this.getPos(), BlockEntityEnergyBattery.class);
    }

    @Override
    public int getUpdateInterval() {
        return 0;
    }

    @Override
    public boolean isUpdate() {
        return false;
    }

    @Override
    public void update(INetwork network) {
    }

    @Override
    public void beforeNetworkKill(INetwork network) {
    }

    @Override
    public void afterNetworkAlive(INetwork network) {
    }

    @Override
    public void addDrops(List<ItemStack> itemStacks, boolean dropMainElement, boolean saveState) {
    }

    @Override
    public boolean onNetworkAddition(INetwork network) {
        PartPos pos = PartPos.of(this.getPos(), null);
        boolean added = NetworkHelpers.getEnergyNetworkChecked(network).addPosition(pos, 0, 0);
        this.scheduleNetworkObservation(network, pos);
        return added;
    }

    @Override
    public void onNetworkRemoval(INetwork network) {
        PartPos pos = PartPos.of(this.getPos(), null);
        this.scheduleNetworkObservation(network, pos);
        NetworkHelpers.getEnergyNetworkChecked(network).removePosition(pos);
    }

    protected void scheduleNetworkObservation(INetwork network, PartPos pos) {
        NetworkHelpers.getEnergyNetwork(network).ifPresent(energyNetwork -> energyNetwork.scheduleObservationForced(0, pos));
    }

    @Override
    public void onPreRemoved(INetwork network) {
    }

    @Override
    public void onNeighborBlockChange(@Nullable INetwork network, BlockGetter world, Block neighbourBlock, BlockPos neighbourBlockPos) {
    }

    @Override
    public void setPriorityAndChannel(INetwork network, int priority, int channel) {
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public int getChannel() {
        return 0;
    }

    @Override
    public boolean canRevalidate(INetwork network) {
        return this.canRevalidatePositioned(network, this.pos);
    }

    @Override
    public void revalidate(INetwork network) {
        super.revalidate(network);
        this.revalidatePositioned(network, this.pos);
    }

    @Override
    public int compareTo(INetworkElement o) {
        if (o instanceof EnergyBatteryNetworkElement) {
            return this.getPos().compareTo(((EnergyBatteryNetworkElement)o).getPos());
        }
        return this.getClass().getCanonicalName().compareTo(o.getClass().getCanonicalName());
    }

    @Override
    public boolean isLoaded() {
        return INetworkElement.shouldTick(this.getPos());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnergyBatteryNetworkElement)) {
            return false;
        }
        EnergyBatteryNetworkElement other = (EnergyBatteryNetworkElement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DimPos this$pos = this.getPos();
        DimPos other$pos = other.getPos();
        return !(this$pos == null ? other$pos != null : !this$pos.equals(other$pos));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof EnergyBatteryNetworkElement;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DimPos $pos = this.getPos();
        result = result * 59 + ($pos == null ? 43 : $pos.hashCode());
        return result;
    }

    public EnergyBatteryNetworkElement(DimPos pos) {
        this.pos = pos;
    }

    public DimPos getPos() {
        return this.pos;
    }

    @Override
    public String toString() {
        return "EnergyBatteryNetworkElement(pos=" + String.valueOf(this.getPos()) + ")";
    }
}

