/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.network.diagnostics;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.core.network.diagnostics.NetworkDiagnosticsPartOverlayRenderer;
import org.cyclops.integrateddynamics.core.network.diagnostics.RawNetworkData;
import org.cyclops.integrateddynamics.core.network.diagnostics.RawObserverData;
import org.cyclops.integrateddynamics.core.network.diagnostics.RawPartData;
import org.cyclops.integrateddynamics.network.packet.PlayerTeleportPacket;

public class NetworkDataClient {
    public static final String[] LOCALIZE_ENTRIES = new String[]{"gui.integrateddynamics.diagnostics.title", "gui.integrateddynamics.diagnostics.parts", "gui.integrateddynamics.diagnostics.observers", "gui.integrateddynamics.diagnostics.table.network", "gui.integrateddynamics.diagnostics.table.cables", "gui.integrateddynamics.diagnostics.table.part", "gui.integrateddynamics.diagnostics.table.ticktime", "gui.integrateddynamics.diagnostics.table.dimension", "gui.integrateddynamics.diagnostics.table.position", "gui.integrateddynamics.diagnostics.table.side", "gui.integrateddynamics.diagnostics.table.actions"};
    private static final Multimap<Integer, ObservablePartData> networkDataParts = ArrayListMultimap.create();
    private static final Multimap<Integer, ObservableObserverData> networkDataObservers = ArrayListMultimap.create();

    public static void clearNetworkData() {
        networkDataParts.clear();
        networkDataObservers.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setNetworkData(int id, RawNetworkData rawNetworkData) {
        Multimap<Integer, ObservablePartData> multimap = networkDataParts;
        synchronized (multimap) {
            PartPos pos;
            Collection previous = networkDataParts.removeAll((Object)id);
            HashSet previousPositionsWithRender = Sets.newHashSet();
            for (Object partData : previous) {
                PartPos pos2 = ((ObservablePartData)partData).toPartPos();
                if (pos2 == null || !NetworkDiagnosticsPartOverlayRenderer.getInstance().hasPartPos(pos2)) continue;
                previousPositionsWithRender.add(pos2);
            }
            if (rawNetworkData != null) {
                ArrayList parts = Lists.newArrayList();
                for (RawPartData rawPartData : rawNetworkData.getParts()) {
                    Object partData = new ObservablePartData(rawNetworkData.getId(), rawNetworkData.getCables(), rawPartData.getDimension(), rawPartData.getPos(), rawPartData.getSide(), rawPartData.getName(), rawPartData.getLast20TicksDurationNs());
                    parts.add(partData);
                    pos = ((ObservablePartData)partData).toPartPos();
                    if (pos == null) continue;
                    previousPositionsWithRender.remove(pos);
                }
                for (Object partPos : previousPositionsWithRender) {
                    NetworkDiagnosticsPartOverlayRenderer.getInstance().removePos((PartPos)partPos);
                }
                networkDataParts.putAll((Object)id, (Iterable)parts);
            }
            Collection previousObservers = networkDataObservers.removeAll((Object)id);
            HashSet previousPositionsWithRenderObservers = Sets.newHashSet();
            for (Object partData : previousObservers) {
                pos = ((ObservableObserverData)partData).toPartPos();
                if (pos == null || !NetworkDiagnosticsPartOverlayRenderer.getInstance().hasPartPos(pos)) continue;
                previousPositionsWithRenderObservers.add(pos);
            }
            if (rawNetworkData != null) {
                ArrayList observers = Lists.newArrayList();
                for (RawObserverData rawPartData : rawNetworkData.getObservers()) {
                    ObservableObserverData partData = new ObservableObserverData(rawNetworkData.getId(), rawPartData.getDimension(), rawPartData.getPos(), rawPartData.getSide(), rawPartData.getName(), rawPartData.getLast20TicksDurationNs());
                    observers.add(partData);
                    PartPos pos3 = partData.toPartPos();
                    if (pos3 == null) continue;
                    previousPositionsWithRenderObservers.remove(pos3);
                }
                for (PartPos partPos : previousPositionsWithRenderObservers) {
                    NetworkDiagnosticsPartOverlayRenderer.getInstance().removePos(partPos);
                }
                networkDataObservers.putAll((Object)id, (Iterable)observers);
            }
        }
    }

    public static String getAsJsonString() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonObject responseObject = new JsonObject();
        responseObject.add("localization", NetworkDataClient.getLocalizationJson());
        responseObject.add("parts", NetworkDataClient.getPartsJson());
        responseObject.add("observers", NetworkDataClient.getObserversJson());
        return gson.toJson((JsonElement)responseObject) + "\n";
    }

    private static JsonElement getLocalizationJson() {
        JsonObject jsonObject = new JsonObject();
        for (String entry : LOCALIZE_ENTRIES) {
            jsonObject.addProperty(entry, L10NHelpers.localize((String)entry, (Object[])new Object[0]));
        }
        return jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JsonElement getPartsJson() {
        JsonArray jsonArray = new JsonArray();
        Multimap<Integer, ObservablePartData> multimap = networkDataParts;
        synchronized (multimap) {
            for (Map.Entry entry : networkDataParts.entries()) {
                JsonObject jsonPart = new JsonObject();
                ObservablePartData part = (ObservablePartData)entry.getValue();
                jsonPart.addProperty("network", (Number)part.getNetworkId());
                jsonPart.addProperty("cables", (Number)part.getNetworkCables());
                jsonPart.addProperty("part", L10NHelpers.localize((String)part.getName(), (Object[])new Object[0]));
                jsonPart.addProperty("ticktime", (Number)Float.valueOf(Float.parseFloat(String.format(Locale.ENGLISH, "%.6f", (double)part.getLast20TicksDurationNs() / 20.0 / 1000000.0))));
                jsonPart.addProperty("dimension", part.getDimension().location().toString());
                jsonPart.addProperty("position", part.getPos().toShortString());
                jsonPart.addProperty("side", part.getSide().name());
                jsonPart.addProperty("highlighted", Boolean.valueOf(NetworkDiagnosticsPartOverlayRenderer.getInstance().hasPartPos(part.toPartPos())));
                jsonArray.add((JsonElement)jsonPart);
            }
        }
        return jsonArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JsonElement getObserversJson() {
        JsonArray jsonArray = new JsonArray();
        Multimap<Integer, ObservablePartData> multimap = networkDataParts;
        synchronized (multimap) {
            for (Map.Entry entry : networkDataObservers.entries()) {
                JsonObject jsonPart = new JsonObject();
                ObservableObserverData observer = (ObservableObserverData)entry.getValue();
                jsonPart.addProperty("network", (Number)observer.getNetworkId());
                jsonPart.addProperty("part", observer.getName());
                jsonPart.addProperty("ticktime", String.format("%.6f", (double)observer.getLast20TicksDurationNs() / 20.0 / 1000000.0));
                jsonPart.addProperty("dimension", observer.getDimension().location().toString());
                jsonPart.addProperty("position", observer.getPos().toShortString());
                jsonPart.addProperty("side", observer.getSide() != null ? observer.getSide().name() : "null");
                jsonPart.addProperty("highlighted", Boolean.valueOf(NetworkDiagnosticsPartOverlayRenderer.getInstance().hasPartPos(observer.toPartPos())));
                jsonArray.add((JsonElement)jsonPart);
            }
        }
        return jsonArray;
    }

    public static void highlightEnable(JsonObject data) {
        PartPos pos = NetworkDataClient.parsePosString(data.get("dimension").getAsString(), data.get("position").getAsString(), data.get("side").getAsString());
        NetworkDiagnosticsPartOverlayRenderer.getInstance().addPos(pos);
    }

    public static void highlightDisable(JsonObject data) {
        PartPos pos = NetworkDataClient.parsePosString(data.get("dimension").getAsString(), data.get("position").getAsString(), data.get("side").getAsString());
        if (NetworkDiagnosticsPartOverlayRenderer.getInstance().hasPartPos(pos)) {
            NetworkDiagnosticsPartOverlayRenderer.getInstance().removePos(pos);
        }
    }

    public static void teleport(JsonObject data) {
        PartPos pos = NetworkDataClient.parsePosString(data.get("dimension").getAsString(), data.get("position").getAsString(), data.get("side").getAsString());
        BlockPos blockPos = pos.getPos().getBlockPos();
        float yaw = 0.0f;
        if (pos.getSide() != null) {
            blockPos = blockPos.relative(pos.getSide());
            yaw = pos.getSide().getOpposite().toYRot();
        }
        IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new PlayerTeleportPacket((ResourceKey<Level>)pos.getPos().getLevelKey(), blockPos.getX(), blockPos.getY() - 1, blockPos.getZ(), yaw, 0.0f));
    }

    private static PartPos parsePosString(String dimensionString, String positionString, String sideString) {
        String[] posParts = positionString.split(", ");
        BlockPos pos = new BlockPos(Integer.parseInt(posParts[0]), Integer.parseInt(posParts[1]), Integer.parseInt(posParts[2]));
        return PartPos.of(DimPos.of((String)dimensionString, (BlockPos)pos), Direction.byName((String)sideString.toLowerCase(Locale.ROOT)));
    }

    private static class ObservablePartData {
        private final int networkId;
        private final int networkCables;
        private final ResourceKey<Level> dimension;
        private final BlockPos pos;
        private final Direction side;
        private final String name;
        private final long last20TicksDurationNs;

        public PartPos toPartPos() {
            ClientLevel world = Minecraft.getInstance().level;
            if (this.getDimension().location().equals((Object)world.dimension().location())) {
                return PartPos.of(DimPos.of((Level)world, (BlockPos)this.getPos()), this.getSide());
            }
            return null;
        }

        public ObservablePartData(int networkId, int networkCables, ResourceKey<Level> dimension, BlockPos pos, Direction side, String name, long last20TicksDurationNs) {
            this.networkId = networkId;
            this.networkCables = networkCables;
            this.dimension = dimension;
            this.pos = pos;
            this.side = side;
            this.name = name;
            this.last20TicksDurationNs = last20TicksDurationNs;
        }

        public int getNetworkId() {
            return this.networkId;
        }

        public int getNetworkCables() {
            return this.networkCables;
        }

        public ResourceKey<Level> getDimension() {
            return this.dimension;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public Direction getSide() {
            return this.side;
        }

        public String getName() {
            return this.name;
        }

        public long getLast20TicksDurationNs() {
            return this.last20TicksDurationNs;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ObservablePartData)) {
                return false;
            }
            ObservablePartData other = (ObservablePartData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getNetworkId() != other.getNetworkId()) {
                return false;
            }
            if (this.getNetworkCables() != other.getNetworkCables()) {
                return false;
            }
            if (this.getLast20TicksDurationNs() != other.getLast20TicksDurationNs()) {
                return false;
            }
            ResourceKey<Level> this$dimension = this.getDimension();
            ResourceKey<Level> other$dimension = other.getDimension();
            if (this$dimension == null ? other$dimension != null : !this$dimension.equals(other$dimension)) {
                return false;
            }
            BlockPos this$pos = this.getPos();
            BlockPos other$pos = other.getPos();
            if (this$pos == null ? other$pos != null : !this$pos.equals(other$pos)) {
                return false;
            }
            Direction this$side = this.getSide();
            Direction other$side = other.getSide();
            if (this$side == null ? other$side != null : !this$side.equals(other$side)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ObservablePartData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getNetworkId();
            result = result * 59 + this.getNetworkCables();
            long $last20TicksDurationNs = this.getLast20TicksDurationNs();
            result = result * 59 + (int)($last20TicksDurationNs >>> 32 ^ $last20TicksDurationNs);
            ResourceKey<Level> $dimension = this.getDimension();
            result = result * 59 + ($dimension == null ? 43 : $dimension.hashCode());
            BlockPos $pos = this.getPos();
            result = result * 59 + ($pos == null ? 43 : $pos.hashCode());
            Direction $side = this.getSide();
            result = result * 59 + ($side == null ? 43 : $side.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "NetworkDataClient.ObservablePartData(networkId=" + this.getNetworkId() + ", networkCables=" + this.getNetworkCables() + ", dimension=" + String.valueOf(this.getDimension()) + ", pos=" + String.valueOf(this.getPos()) + ", side=" + String.valueOf(this.getSide()) + ", name=" + this.getName() + ", last20TicksDurationNs=" + this.getLast20TicksDurationNs() + ")";
        }
    }

    private static class ObservableObserverData {
        private final int networkId;
        private final ResourceKey<Level> dimension;
        private final BlockPos pos;
        private final Direction side;
        private final String name;
        private final long last20TicksDurationNs;

        public PartPos toPartPos() {
            ClientLevel world = Minecraft.getInstance().level;
            if (this.getDimension().location().equals((Object)world.dimension().location())) {
                return PartPos.of(DimPos.of((Level)world, (BlockPos)this.getPos()), this.getSide());
            }
            return null;
        }

        public ObservableObserverData(int networkId, ResourceKey<Level> dimension, BlockPos pos, Direction side, String name, long last20TicksDurationNs) {
            this.networkId = networkId;
            this.dimension = dimension;
            this.pos = pos;
            this.side = side;
            this.name = name;
            this.last20TicksDurationNs = last20TicksDurationNs;
        }

        public int getNetworkId() {
            return this.networkId;
        }

        public ResourceKey<Level> getDimension() {
            return this.dimension;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public Direction getSide() {
            return this.side;
        }

        public String getName() {
            return this.name;
        }

        public long getLast20TicksDurationNs() {
            return this.last20TicksDurationNs;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ObservableObserverData)) {
                return false;
            }
            ObservableObserverData other = (ObservableObserverData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getNetworkId() != other.getNetworkId()) {
                return false;
            }
            if (this.getLast20TicksDurationNs() != other.getLast20TicksDurationNs()) {
                return false;
            }
            ResourceKey<Level> this$dimension = this.getDimension();
            ResourceKey<Level> other$dimension = other.getDimension();
            if (this$dimension == null ? other$dimension != null : !this$dimension.equals(other$dimension)) {
                return false;
            }
            BlockPos this$pos = this.getPos();
            BlockPos other$pos = other.getPos();
            if (this$pos == null ? other$pos != null : !this$pos.equals(other$pos)) {
                return false;
            }
            Direction this$side = this.getSide();
            Direction other$side = other.getSide();
            if (this$side == null ? other$side != null : !this$side.equals(other$side)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ObservableObserverData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getNetworkId();
            long $last20TicksDurationNs = this.getLast20TicksDurationNs();
            result = result * 59 + (int)($last20TicksDurationNs >>> 32 ^ $last20TicksDurationNs);
            ResourceKey<Level> $dimension = this.getDimension();
            result = result * 59 + ($dimension == null ? 43 : $dimension.hashCode());
            BlockPos $pos = this.getPos();
            result = result * 59 + ($pos == null ? 43 : $pos.hashCode());
            Direction $side = this.getSide();
            result = result * 59 + ($side == null ? 43 : $side.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "NetworkDataClient.ObservableObserverData(networkId=" + this.getNetworkId() + ", dimension=" + String.valueOf(this.getDimension()) + ", pos=" + String.valueOf(this.getPos()) + ", side=" + String.valueOf(this.getSide()) + ", name=" + this.getName() + ", last20TicksDurationNs=" + this.getLast20TicksDurationNs() + ")";
        }
    }
}

