/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueCastRegistry;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueCastMappings;

public abstract class ValueBase
implements IValue {
    private final IValueType type;

    protected ValueBase(IValueType type) {
        this.type = type;
    }

    @Override
    public IValueType getType() {
        return this.type;
    }

    protected IValueCastRegistry getValueCastRegistry() {
        return ValueCastMappings.REGISTRY;
    }

    @Override
    public <V extends IValue> V cast(IValueType<V> valueType) throws IValueCastRegistry.ValueCastException {
        if (valueType == this.getType()) {
            return (V)this;
        }
        return (V)this.getValueCastRegistry().cast(valueType, this);
    }

    @Override
    public <V extends IValue> boolean canCast(IValueType<V> valueType) {
        return this.getValueCastRegistry().canCast(valueType, this);
    }

    public String toString() {
        return "ValueBase(type=" + String.valueOf(this.getType()) + ")";
    }
}

