/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.capability.dynamicredstone;

import net.minecraft.core.Direction;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.integrateddynamics.api.block.IDynamicRedstone;
import org.cyclops.integrateddynamics.core.blockentity.BlockEntityMultipartTicking;

public class DynamicRedstoneTileMultipartTicking
implements IDynamicRedstone {
    private final BlockEntityMultipartTicking tile;
    private final Direction side;

    public DynamicRedstoneTileMultipartTicking(BlockEntityMultipartTicking tile, Direction side) {
        this.tile = tile;
        this.side = side;
    }

    protected EnumFacingMap<Integer> getRedstoneLevels() {
        return this.tile.getRedstoneLevels();
    }

    protected EnumFacingMap<Boolean> getRedstoneInputs() {
        return this.tile.getRedstoneInputs();
    }

    protected EnumFacingMap<Boolean> getRedstoneStrong() {
        return this.tile.getRedstoneStrong();
    }

    @Override
    public void setRedstoneLevel(int level, boolean direct) {
        if (!this.tile.getLevel().isClientSide) {
            EnumFacingMap<Integer> redstoneLevels = this.getRedstoneLevels();
            EnumFacingMap<Boolean> redstoneStrongs = this.getRedstoneStrong();
            boolean sendUpdate = false;
            boolean sendUpdateStrong = false;
            if (redstoneLevels.containsKey((Object)this.side)) {
                if ((Integer)redstoneLevels.get((Object)this.side) != level) {
                    sendUpdate = true;
                    redstoneLevels.put((Enum)this.side, (Object)level);
                }
            } else {
                sendUpdate = true;
                redstoneLevels.put((Enum)this.side, (Object)level);
            }
            if (redstoneStrongs.containsKey((Object)this.side)) {
                if ((Boolean)redstoneStrongs.get((Object)this.side) != direct) {
                    sendUpdateStrong = true;
                    sendUpdate = true;
                    redstoneStrongs.put((Enum)this.side, (Object)direct);
                }
            } else {
                sendUpdateStrong = true;
                sendUpdate = true;
                redstoneStrongs.put((Enum)this.side, (Object)direct);
            }
            if (sendUpdate) {
                this.tile.updateRedstoneInfo(this.side, direct || sendUpdateStrong);
            }
        }
    }

    @Override
    public int getRedstoneLevel() {
        EnumFacingMap<Integer> redstoneLevels = this.getRedstoneLevels();
        if (redstoneLevels.containsKey((Object)this.side)) {
            return (Integer)redstoneLevels.get((Object)this.side);
        }
        return -1;
    }

    @Override
    public boolean isDirect() {
        EnumFacingMap<Boolean> redstoneStrongs = this.getRedstoneStrong();
        if (redstoneStrongs.containsKey((Object)this.side)) {
            return (Boolean)redstoneStrongs.get((Object)this.side);
        }
        return false;
    }

    @Override
    public void setAllowRedstoneInput(boolean allow) {
        EnumFacingMap<Boolean> redstoneInputs = this.getRedstoneInputs();
        redstoneInputs.put((Enum)this.side, (Object)allow);
    }

    @Override
    public boolean isAllowRedstoneInput() {
        EnumFacingMap<Boolean> redstoneInputs = this.getRedstoneInputs();
        if (redstoneInputs.containsKey((Object)this.side)) {
            return (Boolean)redstoneInputs.get((Object)this.side);
        }
        return false;
    }

    @Override
    public void setLastPulseValue(int value) {
        EnumFacingMap<Integer> pulses = this.tile.getLastRedstonePulses();
        pulses.put((Enum)this.side, (Object)value);
    }

    @Override
    public int getLastPulseValue() {
        EnumFacingMap<Integer> pulses = this.tile.getLastRedstonePulses();
        if (pulses.containsKey((Object)this.side)) {
            return (Integer)pulses.get((Object)this.side);
        }
        return 0;
    }
}

