/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.balm.neoforge;

import java.util.HashMap;
import java.util.Map;
import net.blay09.mods.balm.api.BalmHooks;
import net.blay09.mods.balm.api.entity.BalmEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.EffectCures;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;

public class NeoForgeBalmHooks
implements BalmHooks {
    public final Map<Item, Integer> burnTimes = new HashMap<Item, Integer>();

    public NeoForgeBalmHooks() {
        NeoForge.EVENT_BUS.addListener(this::furnaceFuelBurnTime);
    }

    private void furnaceFuelBurnTime(FurnaceFuelBurnTimeEvent event) {
        Integer found = this.burnTimes.get(event.getItemStack().getItem());
        if (found != null) {
            event.setBurnTime(found.intValue());
        }
    }

    @Override
    public boolean blockGrowFeature(Level level, RandomSource random, BlockPos pos, @Nullable Holder<ConfiguredFeature<?, ?>> holder) {
        return !EventHooks.fireBlockGrowFeature((LevelAccessor)level, (RandomSource)random, (BlockPos)pos, holder).isCanceled();
    }

    @Override
    public boolean growCrop(ItemStack itemStack, Level level, BlockPos pos, Player player) {
        if (player != null) {
            return BoneMealItem.applyBonemeal((ItemStack)itemStack, (Level)level, (BlockPos)pos, (Player)player);
        }
        return BoneMealItem.growCrop((ItemStack)itemStack, (Level)level, (BlockPos)pos);
    }

    @Override
    public CompoundTag getPersistentData(Entity entity) {
        CompoundTag balmData;
        CompoundTag persistentData = entity.getPersistentData();
        if (entity instanceof Player) {
            CompoundTag persistedTag = persistentData.getCompound("PlayerPersisted");
            persistentData.put("PlayerPersisted", (Tag)persistedTag);
            persistentData = persistedTag;
        }
        if ((balmData = persistentData.getCompound("BalmData")).isEmpty()) {
            balmData = ((BalmEntity)entity).getFabricBalmData();
        }
        if (!balmData.isEmpty()) {
            persistentData.put("BalmData", (Tag)balmData);
        }
        return balmData;
    }

    @Override
    public void curePotionEffects(LivingEntity entity, ItemStack curativeItem) {
        if (curativeItem.getItem() == Items.MILK_BUCKET) {
            entity.removeEffectsCuredBy(EffectCures.MILK);
        } else if (curativeItem.getItem() == Items.HONEY_BOTTLE) {
            entity.removeEffectsCuredBy(EffectCures.HONEY);
        }
    }

    @Override
    public boolean isFakePlayer(Player player) {
        return player instanceof FakePlayer;
    }

    @Override
    public ItemStack getCraftingRemainingItem(ItemStack itemStack) {
        return itemStack.getCraftingRemainingItem();
    }

    @Override
    public DyeColor getColor(ItemStack itemStack) {
        return DyeColor.getColor((ItemStack)itemStack);
    }

    @Override
    public boolean canItemsStack(ItemStack first, ItemStack second) {
        return ItemStack.isSameItemSameComponents((ItemStack)first, (ItemStack)second);
    }

    @Override
    public int getBurnTime(ItemStack itemStack) {
        return itemStack.getBurnTime(RecipeType.SMELTING);
    }

    @Override
    public void setBurnTime(Item item, int burnTime) {
        this.burnTimes.put(item, burnTime);
    }

    @Override
    public void firePlayerCraftingEvent(Player player, ItemStack crafted, Container craftMatrix) {
        EventHooks.firePlayerCraftingEvent((Player)player, (ItemStack)crafted, (Container)craftMatrix);
    }

    @Override
    public boolean useFluidTank(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (Level)level, (BlockPos)pos, (Direction)hitResult.getDirection());
    }

    @Override
    public boolean isShield(ItemStack itemStack) {
        return itemStack.getItem().canPerformAction(itemStack, ItemAbilities.SHIELD_BLOCK);
    }

    @Override
    public boolean isRepairable(ItemStack itemStack) {
        return itemStack.isRepairable();
    }

    @Override
    public void setForcedPose(Player player, Pose pose) {
        player.setForcedPose(pose);
    }

    @Override
    public MinecraftServer getServer() {
        return ServerLifecycleHooks.getCurrentServer();
    }
}

