/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.world;

import com.hollingsworth.arsnouveau.common.block.SourceLamp;
import com.hollingsworth.arsnouveau.setup.registry.BlockRegistry;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.neoforged.neoforge.common.Tags;

public class SourcestoneFormationFeature
extends Feature<NoneFeatureConfiguration> {
    public SourcestoneFormationFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    private boolean isValidGround(BlockState state) {
        return state.is(BlockTags.DIRT) || state.is(Blocks.DEEPSLATE) || state.is(Tags.Blocks.STONES);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos origin = context.origin();
        RandomSource random = context.random();
        BlockState baseSourcestone = ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"ars_nouveau", (String)"sourcestone"))).defaultBlockState();
        BlockState var1Sourcestone = ((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"ars_nouveau", (String)"sourcestone_alternating"))).defaultBlockState();
        BlockState var2Sourcestone = (BlockState)((BlockState)BlockRegistry.SOURCE_LAMP.defaultBlockState().setValue((Property)SourceLamp.LIT, (Comparable)Boolean.valueOf(true))).setValue((Property)SourceLamp.LIGHT_LEVEL, (Comparable)Integer.valueOf(8));
        BlockPos blockpos = origin;
        while (blockpos.getY() > level.getMinBuildHeight() + 3) {
            BlockState stateBelow = level.getBlockState(blockpos.below());
            if (!level.isEmptyBlock(blockpos.below()) && this.isValidGround(stateBelow)) break;
            blockpos = blockpos.below();
        }
        if (blockpos.getY() <= level.getMinBuildHeight() + 3) {
            return false;
        }
        blockpos = blockpos.below();
        int height = random.nextInt(12) + 6;
        int baseRadius = random.nextInt(3) + 2;
        int top = height * 9 / 10;
        for (int y = 0; y < height; ++y) {
            int radius = baseRadius - y / (height / baseRadius);
            if (radius < 0 || y >= height - 2) {
                radius = 0;
            }
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    if (dx * dx + dz * dz > radius * radius) continue;
                    BlockPos pos = blockpos.offset(dx, y, dz);
                    if (y >= top) {
                        level.setBlock(pos, var2Sourcestone, 2);
                        continue;
                    }
                    BlockState whiteRock = random.nextBoolean() ? var1Sourcestone : baseSourcestone;
                    level.setBlock(pos, whiteRock, 2);
                }
            }
        }
        return true;
    }
}

