/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.datagen;

import com.google.gson.JsonElement;
import com.hollingsworth.arsnouveau.common.crafting.recipes.CrushRecipe;
import com.hollingsworth.arsnouveau.common.datagen.CrushRecipeProvider;
import com.hollingsworth.arsnouveau.common.datagen.SimpleDataProvider;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class AECrushProvider
extends SimpleDataProvider {
    public List<CrushRecipeProvider.CrushWrapper> recipes = new ArrayList<CrushRecipeProvider.CrushWrapper>();

    public AECrushProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public void collectJsons(CachedOutput pOutput) {
        this.recipes.add(new CrushRecipeProvider.CrushWrapper("blaze_powder", Ingredient.of((ItemStack[])new ItemStack[]{Items.BLAZE_ROD.getDefaultInstance()})).withItems(new ItemStack((ItemLike)Items.BLAZE_POWDER, 3)).withItems(new ItemStack((ItemLike)Items.BLAZE_POWDER), 0.5f));
        this.recipes.add(new CrushRecipeProvider.CrushWrapper("bone_meal", Ingredient.of((ItemStack[])new ItemStack[]{Items.BONE.getDefaultInstance()})).withItems(new ItemStack((ItemLike)Items.BONE_MEAL, 3)).withItems(new ItemStack((ItemLike)Items.BONE_MEAL), 0.5f).withItems(new ItemStack((ItemLike)Items.BONE_MEAL), 0.5f));
        this.recipes.add(new CrushRecipeProvider.CrushWrapper("wool_to_string", Ingredient.of((TagKey)ItemTags.WOOL)).withItems(new ItemStack((ItemLike)Items.STRING, 3)).withItems(new ItemStack((ItemLike)Items.STRING), 0.5f));
        for (CrushRecipeProvider.CrushWrapper g : this.recipes) {
            Path path = AECrushProvider.getRecipePath(this.output, g.path.getPath());
            this.saveStable(pOutput, (JsonElement)CrushRecipe.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)g.asRecipe()).getOrThrow(), path);
        }
    }

    private static Path getRecipePath(Path pathIn, String str) {
        return pathIn.resolve("data/ars_elemental/recipe/" + str + ".json");
    }

    @NotNull
    public String getName() {
        return "Elemental Crush";
    }
}

