/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.glyphs;

import alexthw.ars_elemental.common.glyphs.ElementalAbstractEffect;
import alexthw.ars_elemental.registry.ModAdvTriggers;
import alexthw.ars_elemental.registry.ModItems;
import alexthw.ars_elemental.registry.ModPotions;
import alexthw.ars_elemental.registry.ModRegistry;
import alexthw.ars_elemental.util.CompatUtils;
import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.spell.AbstractAugment;
import com.hollingsworth.arsnouveau.api.spell.IDamageEffect;
import com.hollingsworth.arsnouveau.api.spell.IPotionEffect;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.SpellStats;
import com.hollingsworth.arsnouveau.api.spell.SpellTier;
import com.hollingsworth.arsnouveau.api.util.DamageUtil;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAOE;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentAmplify;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDampen;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentDurationDown;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentExtendTime;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentFortune;
import com.hollingsworth.arsnouveau.common.spell.augment.AugmentRandomize;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;

public class EffectSpores
extends ElementalAbstractEffect
implements IDamageEffect,
IPotionEffect {
    public static EffectSpores INSTANCE = new EffectSpores();

    public EffectSpores() {
        super("poison_spores", "Poison Spores");
    }

    public String getBookDescription() {
        return "A fog of poison spores erupts from the target, damaging it and causing poison and hunger to spread to nearby entities. It can only damage mobs poisoned or afflicted by hunger.";
    }

    public void onResolveEntity(EntityHitResult rayTraceResult, Level level, @Nonnull LivingEntity shooter, SpellStats spellStats, SpellContext spellContext, SpellResolver resolver) {
        LivingEntity livingEntity;
        block8: {
            block7: {
                Entity entity = rayTraceResult.getEntity();
                if (!(entity instanceof LivingEntity)) break block7;
                livingEntity = (LivingEntity)entity;
                if (level instanceof ServerLevel) break block8;
            }
            return;
        }
        ServerLevel world = (ServerLevel)level;
        Vec3 vec = this.safelyGetHitPos((HitResult)rayTraceResult);
        float damage = (float)((Double)this.DAMAGE.get() + (Double)this.AMP_VALUE.get() * spellStats.getAmpMultiplier());
        double range = 3.0 + spellStats.getAoeMultiplier();
        int effectSec = (int)((double)((Integer)this.POTION_TIME.get()).intValue() + (double)((Integer)this.EXTEND_TIME.get()).intValue() * spellStats.getDurationMultiplier());
        MobEffectInstance venom = livingEntity.getEffect(ModPotions.VENOM);
        if (venom != null) {
            damage += (float)(2 + 3 * venom.getAmplifier());
        }
        if (!this.canDamage(shooter, spellStats, spellContext, resolver, (Entity)livingEntity)) {
            return;
        }
        this.damage(vec, world, shooter, spellStats, damage, effectSec, livingEntity, spellContext, resolver);
        for (LivingEntity e : world.getEntitiesOfClass(LivingEntity.class, new AABB(livingEntity.position().add(range, range, range), livingEntity.position().subtract(range, range, range)))) {
            if (e.equals((Object)livingEntity) || e.equals((Object)shooter)) continue;
            if (this.canDamage(e, spellStats, spellContext, resolver, (Entity)e)) {
                vec = e.position();
                this.damage(vec, world, shooter, spellStats, damage, effectSec, e, spellContext, resolver);
                continue;
            }
            e.addEffect(new MobEffectInstance(MobEffects.POISON, 20 * effectSec, (int)spellStats.getAmpMultiplier()));
        }
    }

    public boolean canDamage(LivingEntity shooter, SpellStats stats, SpellContext spellContext, SpellResolver resolver, @NotNull Entity entity) {
        LivingEntity living;
        return !(!(entity instanceof LivingEntity) || (living = (LivingEntity)entity).getHealth() <= 0.0f || !living.hasEffect(MobEffects.POISON) && !living.hasEffect(MobEffects.HUNGER) && !living.hasEffect(ModPotions.VENOM));
    }

    public void damage(Vec3 vec, ServerLevel world, @Nonnull LivingEntity shooter, SpellStats stats, float damage, int snareTime, LivingEntity livingEntity, SpellContext spellContext, SpellResolver resolver) {
        if (livingEntity.getType().is(EntityTypeTags.UNDEAD)) {
            damage *= 1.25f;
        }
        this.attemptDamage((Level)world, shooter, stats, spellContext, resolver, (Entity)livingEntity, this.buildDamageSource((Level)world, shooter), damage);
        world.sendParticles((ParticleOptions)ParticleTypes.SPORE_BLOSSOM_AIR, vec.x, vec.y + 0.5, vec.z, 50, ParticleUtil.inRange((double)-0.1, (double)0.1), ParticleUtil.inRange((double)-0.1, (double)0.1), ParticleUtil.inRange((double)-0.1, (double)0.1), 0.5);
        if (livingEntity.isDeadOrDying() && world.getRandom().nextInt(100) < 5 && CompatUtils.earthCheck(resolver)) {
            BlockPos feet = livingEntity.getOnPos();
            BlockState underfoot = world.getBlockState(feet);
            if ((underfoot.getBlock() == Blocks.MOSS_BLOCK || underfoot.is(BlockTags.DIRT) || underfoot.is(BlockTags.LEAVES)) && world.getBlockState(feet.above()).isAir()) {
                ServerPlayer serverPlayer;
                world.setBlockAndUpdate(feet.above(), ((Block)ModItems.GROUND_BLOSSOM.get()).defaultBlockState());
                if (shooter instanceof ServerPlayer && !((serverPlayer = (ServerPlayer)shooter) instanceof FakePlayer)) {
                    ((PlayerTrigger)ModAdvTriggers.BLOSSOM.get()).trigger(serverPlayer);
                }
            }
        } else {
            livingEntity.addEffect(new MobEffectInstance(MobEffects.HUNGER, 20 * snareTime));
        }
    }

    public DamageSource buildDamageSource(Level world, LivingEntity shooter) {
        shooter = !(shooter instanceof Player) ? ANFakePlayer.getPlayer((ServerLevel)((ServerLevel)world)) : shooter;
        return DamageUtil.source((LevelAccessor)world, ModRegistry.POISON, (Entity)shooter);
    }

    public void buildConfig(ModConfigSpec.Builder builder) {
        super.buildConfig(builder);
        this.addDamageConfig(builder, 6.0);
        this.addAmpConfig(builder, 2.5);
        this.addPotionConfig(builder, 10);
        this.addExtendTimeConfig(builder, 3);
    }

    protected void addDefaultAugmentLimits(Map<ResourceLocation, Integer> defaults) {
        defaults.put(AugmentAmplify.INSTANCE.getRegistryName(), 2);
    }

    public int getDefaultManaCost() {
        return 30;
    }

    @Nonnull
    public Set<AbstractAugment> getCompatibleAugments() {
        return this.augmentSetOf(new AbstractAugment[]{AugmentAmplify.INSTANCE, AugmentDampen.INSTANCE, AugmentExtendTime.INSTANCE, AugmentDurationDown.INSTANCE, AugmentAOE.INSTANCE, AugmentFortune.INSTANCE, AugmentRandomize.INSTANCE});
    }

    public SpellTier defaultTier() {
        return SpellTier.TWO;
    }

    @Nonnull
    public Set<SpellSchool> getSchools() {
        return this.setOf(new SpellSchool[]{SpellSchools.ELEMENTAL_EARTH});
    }

    public int getBaseDuration() {
        return this.POTION_TIME == null ? 30 : (Integer)this.POTION_TIME.get();
    }

    public int getExtendTimeDuration() {
        return this.EXTEND_TIME == null ? 8 : (Integer)this.EXTEND_TIME.get();
    }

    public void addAugmentDescriptions(Map<AbstractAugment, String> map) {
        super.addAugmentDescriptions(map);
        map.put((AbstractAugment)AugmentAOE.INSTANCE, "Increases the range of the poison spores released.");
    }
}

