/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.placement;

import com.ldtteam.structurize.placement.AbstractBlueprintIterator;
import com.ldtteam.structurize.placement.structure.IStructureHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import org.jetbrains.annotations.NotNull;

public class BlueprintIteratorHilbert
extends AbstractBlueprintIterator {
    private final List<BlockPos> positions = new ArrayList<BlockPos>();
    private int index;

    public BlueprintIteratorHilbert(@NotNull IStructureHandler structureHandler) {
        super(structureHandler);
        this.generateLayerPattern();
    }

    @Override
    public AbstractBlueprintIterator.Result increment() {
        this.prevProgressPos.set((Vec3i)this.progressPos);
        if (this.progressPos.equals((Object)NULL_POS)) {
            this.index = 0;
            this.progressPos.set((Vec3i)this.positions.get(0));
            return AbstractBlueprintIterator.Result.NEW_BLOCK;
        }
        return this.iterate((this.progressPos.getY() & 1) == 0, true);
    }

    @Override
    public AbstractBlueprintIterator.Result decrement() {
        this.prevProgressPos.set((Vec3i)this.progressPos);
        if (this.progressPos.equals((Object)NULL_POS)) {
            this.index = (this.size.getY() & 1) == 0 ? this.positions.size() - 1 : 0;
            this.progressPos.set((Vec3i)this.positions.get(this.index).above(this.size.getY() - 1));
            return AbstractBlueprintIterator.Result.NEW_BLOCK;
        }
        return this.iterate((this.progressPos.getY() & 1) == 0, false);
    }

    @Override
    public void setProgressPos(@NotNull BlockPos localPosition) {
        super.setProgressPos(localPosition);
        if (!this.progressPos.equals((Object)NULL_POS)) {
            for (int i = 0; i < this.positions.size(); ++i) {
                BlockPos pos = this.positions.get(i);
                if (pos.getX() != this.progressPos.getX() || pos.getZ() != this.progressPos.getZ()) continue;
                this.index = i;
                return;
            }
            this.index = 0;
        }
    }

    private AbstractBlueprintIterator.Result iterate(boolean forward, boolean up) {
        if (forward) {
            if (this.index < this.positions.size() - 1) {
                ++this.index;
                this.progressPos.set((Vec3i)this.positions.get(this.index).above(this.progressPos.getY()));
                return AbstractBlueprintIterator.Result.NEW_BLOCK;
            }
        } else if (this.index > 0) {
            --this.index;
            this.progressPos.set((Vec3i)this.positions.get(this.index).above(this.progressPos.getY()));
            return AbstractBlueprintIterator.Result.NEW_BLOCK;
        }
        return up ? this.moveUp() : this.moveDown();
    }

    private AbstractBlueprintIterator.Result moveUp() {
        int y = this.progressPos.getY() + 1;
        if (y < this.size.getY()) {
            this.progressPos.set((Vec3i)this.positions.get(this.index).above(y));
            return AbstractBlueprintIterator.Result.NEW_BLOCK;
        }
        return AbstractBlueprintIterator.Result.AT_END;
    }

    private AbstractBlueprintIterator.Result moveDown() {
        int y = this.progressPos.getY() - 1;
        if (y >= 0) {
            this.progressPos.set((Vec3i)this.positions.get(this.index).above(y));
            return AbstractBlueprintIterator.Result.NEW_BLOCK;
        }
        return AbstractBlueprintIterator.Result.AT_END;
    }

    private void generateLayerPattern() {
        if (this.size.getX() >= this.size.getZ()) {
            this.generateHilbert(0, 0, this.size.getX(), 0, 0, this.size.getZ());
        } else {
            this.generateHilbert(0, 0, 0, this.size.getZ(), this.size.getX(), 0);
        }
    }

    private void generateHilbert(int x, int z, int ax, int az, int bx, int bz) {
        int width = Math.abs(ax + az);
        int height = Math.abs(bx + bz);
        int dax = Integer.compare(ax, 0);
        int daz = Integer.compare(az, 0);
        int dbx = Integer.compare(bx, 0);
        int dbz = Integer.compare(bz, 0);
        if (height == 1) {
            int i = 0;
            while (i < width) {
                this.positions.add(new BlockPos(x, 0, z));
                ++i;
                x += dax;
                z += daz;
            }
            return;
        }
        if (width == 1) {
            int i = 0;
            while (i < height) {
                this.positions.add(new BlockPos(x, 0, z));
                ++i;
                x += dbx;
                z += dbz;
            }
            return;
        }
        int ax2 = ax / 2;
        int az2 = az / 2;
        int bx2 = bx / 2;
        int bz2 = bz / 2;
        int width2 = Math.abs(ax2 + az2);
        int height2 = Math.abs(bx2 + bz2);
        if (2 * width > 3 * height) {
            if ((width2 & 1) != 0 && width > 2) {
                ax2 += dax;
                az2 += daz;
            }
            this.generateHilbert(x, z, ax2, az2, bx, bz);
            this.generateHilbert(x + ax2, z + az2, ax - ax2, az - az2, bx, bz);
        } else {
            if ((height2 & 1) != 0 && height > 2) {
                bx2 += dbx;
                bz2 += dbz;
            }
            this.generateHilbert(x, z, bx2, bz2, ax2, az2);
            this.generateHilbert(x + bx2, z + bz2, ax, az, bx - bx2, bz - bz2);
            this.generateHilbert(x + (ax - dax) + (bx2 - dbx), z + (az - daz) + (bz2 - dbz), -bx2, -bz2, -(ax - ax2), -(az - az2));
        }
    }
}

