/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.operations;

import com.ldtteam.structurize.operations.AreaOperation;
import com.ldtteam.structurize.util.BlockUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class RemoveBlockOperation
extends AreaOperation {
    private final ItemStack block;

    public RemoveBlockOperation(Player player, BlockPos startPos, BlockPos endPos, ItemStack block) {
        super((Component)Component.translatable((String)"com.ldtteam.structurize.remove_block", (Object[])new Object[]{block.getDisplayName()}), player, startPos, endPos);
        this.block = block;
    }

    @Override
    protected void apply(ServerLevel world, BlockPos position) {
        if (BlockUtils.doBlocksMatch(this.block, world, position)) {
            this.storage.addPreviousDataFor(position, (Level)world);
            world.removeBlock(position, false);
            if (!world.getFluidState(position).isEmpty()) {
                world.setBlock(position, Blocks.AIR.defaultBlockState(), 3);
            }
            this.storage.addPostDataFor(position, (Level)world);
        }
    }
}

