/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.common.network.AbstractServerPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.network.messages.BlueprintSyncMessage;
import com.ldtteam.structurize.storage.BlueprintPlacementHandling;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class BuildToolPlacementMessage
extends AbstractServerPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"structurize", (String)"buildtool_placement", BuildToolPlacementMessage::new);
    public final HandlerType type;
    public final String handlerId;
    public final String structurePackId;
    public final String blueprintPath;
    public final BlockPos pos;
    public final RotationMirror rotationMirror;
    public Level world;
    public ServerPlayer player;
    public boolean clientPack = false;

    protected BuildToolPlacementMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.type = HandlerType.values()[buf.readInt()];
        this.handlerId = buf.readUtf(Short.MAX_VALUE);
        this.structurePackId = buf.readUtf(Short.MAX_VALUE);
        this.blueprintPath = buf.readUtf(Short.MAX_VALUE);
        this.pos = buf.readBlockPos();
        this.rotationMirror = RotationMirror.values()[buf.readInt()];
    }

    public BuildToolPlacementMessage(HandlerType type, String handlerId, String structurePackId, String blueprintPath, BlockPos pos, RotationMirror rotMir) {
        super(TYPE);
        this.type = type;
        this.handlerId = handlerId;
        this.structurePackId = structurePackId;
        this.blueprintPath = blueprintPath;
        this.pos = pos;
        this.rotationMirror = rotMir;
    }

    public BuildToolPlacementMessage(BlueprintSyncMessage msg, ServerPlayer player, Level world) {
        super(TYPE);
        this.type = msg.type;
        this.handlerId = msg.handlerId;
        this.structurePackId = msg.structurePackId;
        this.blueprintPath = msg.blueprintPath;
        this.pos = msg.pos;
        this.rotationMirror = msg.rotationMirror;
        this.clientPack = true;
        this.player = player;
        this.world = world;
    }

    protected void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.type.ordinal());
        buf.writeUtf(this.handlerId);
        buf.writeUtf(this.structurePackId);
        buf.writeUtf(this.blueprintPath);
        buf.writeBlockPos(this.pos);
        buf.writeInt(this.rotationMirror.ordinal());
    }

    protected void onExecute(IPayloadContext context, ServerPlayer player) {
        this.world = player.level();
        this.player = player;
        BlueprintPlacementHandling.handlePlacement(this);
    }

    public static enum HandlerType {
        Complete,
        Pretty,
        Survival;

    }
}

