/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.commands;

import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.blocks.interfaces.ILeveledBlueprintAnchorBlock;
import com.ldtteam.structurize.blocks.interfaces.ISpecialCreativeHandlerAnchorBlock;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.commands.AbstractCommand;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.operations.PlaceStructureOperation;
import com.ldtteam.structurize.placement.StructurePlacer;
import com.ldtteam.structurize.placement.structure.AbstractStructureHandler;
import com.ldtteam.structurize.placement.structure.CreativeStructureHandler;
import com.ldtteam.structurize.storage.ServerFutureProcessor;
import com.ldtteam.structurize.storage.StructurePacks;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.server.command.EnumArgument;
import org.jetbrains.annotations.Nullable;

public class PasteFolderCommand
extends AbstractCommand {
    public static final String commandName = "pasteFolder";
    private static final String PLAYER_NOT_FOUND = "com.structurize.command.playernotfound";
    private static final String PASTE_SUCCESS_MESSAGE = "com.structurize.command.paste.success";
    private static final String NO_PERMISSION_MESSAGE = "com.structurize.command.paste.no.perm";
    private static final String NO_PACK_MESSAGE = "com.structurize.command.paste.no.pack";
    private static final String POS = "pos";
    private static final String PACK_NAME = "pack";
    private static final String FILE_PATH = "path";
    private static final String ROT_MIR = "rotation_mirror";
    private static final String PRETTY = "pretty";
    private static final String PLOT_SIZE = "plotSize";

    private static int execute(CommandSourceStack source, BlockPos pos, String pack, String tempPath, RotationMirror rotMir, boolean pretty, int plotSize) throws CommandSyntaxException {
        @Nullable ServerLevel world = source.getLevel();
        if (source.getEntity() instanceof Player && !source.getPlayerOrException().isCreative()) {
            source.sendFailure((Component)Component.literal((String)NO_PERMISSION_MESSAGE));
            return 0;
        }
        if (!(source.getEntity() instanceof Player)) {
            source.sendFailure((Component)Component.translatable((String)PLAYER_NOT_FOUND));
            return 0;
        }
        ServerPlayer player = source.getPlayerOrException();
        String[] split = tempPath.split("\\.");
        StringBuilder builder = new StringBuilder();
        for (String string : split) {
            if (!builder.toString().isEmpty()) {
                builder.append("/");
            }
            builder.append(string);
        }
        String path = builder.toString();
        String[] packSplit = pack.split("\\.");
        StringBuilder packBuilder = new StringBuilder();
        for (String part : packSplit) {
            if (!packBuilder.toString().isEmpty()) {
                packBuilder.append(" ");
            }
            packBuilder.append(part);
        }
        String string = packBuilder.toString();
        if (!StructurePacks.hasPack(string)) {
            source.sendFailure((Component)Component.translatable((String)NO_PACK_MESSAGE));
            return 0;
        }
        ServerFutureProcessor.queueBlueprintList(new ServerFutureProcessor.BlueprintListProcessingData(StructurePacks.getBlueprintsFuture(string, path, (HolderLookup.Provider)source.registryAccess()), (Level)world, arg_0 -> PasteFolderCommand.lambda$execute$0(rotMir, (Level)world, pos, (Player)player, pretty, string, path, plotSize, arg_0)));
        source.sendSuccess(() -> Component.translatable((String)PASTE_SUCCESS_MESSAGE), true);
        return 1;
    }

    private static int onExecute(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.getSpawnablePos(context, (String)POS);
        String packName = StringArgumentType.getString(context, (String)PACK_NAME);
        String path = StringArgumentType.getString(context, (String)FILE_PATH);
        return PasteFolderCommand.execute((CommandSourceStack)context.getSource(), pos, packName, path, RotationMirror.NONE, true, 34);
    }

    private static int onExecuteWithRotationAndMirror(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.getSpawnablePos(context, (String)POS);
        String packName = StringArgumentType.getString(context, (String)PACK_NAME);
        String path = StringArgumentType.getString(context, (String)FILE_PATH);
        RotationMirror rotMir = (RotationMirror)((Object)context.getArgument(ROT_MIR, RotationMirror.class));
        return PasteFolderCommand.execute((CommandSourceStack)context.getSource(), pos, packName, path, rotMir, true, 34);
    }

    private static int onExecuteWithPretty(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.getSpawnablePos(context, (String)POS);
        String packName = StringArgumentType.getString(context, (String)PACK_NAME);
        String path = StringArgumentType.getString(context, (String)FILE_PATH);
        RotationMirror rotMir = (RotationMirror)((Object)context.getArgument(ROT_MIR, RotationMirror.class));
        boolean pretty = BoolArgumentType.getBool(context, (String)PRETTY);
        return PasteFolderCommand.execute((CommandSourceStack)context.getSource(), pos, packName, path, rotMir, pretty, 34);
    }

    private static int onExecuteWithFull(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        BlockPos pos = BlockPosArgument.getSpawnablePos(context, (String)POS);
        String packName = StringArgumentType.getString(context, (String)PACK_NAME);
        String path = StringArgumentType.getString(context, (String)FILE_PATH);
        RotationMirror rotMir = (RotationMirror)((Object)context.getArgument(ROT_MIR, RotationMirror.class));
        boolean pretty = BoolArgumentType.getBool(context, (String)PRETTY);
        int plotSize = IntegerArgumentType.getInteger(context, (String)PLOT_SIZE);
        return PasteFolderCommand.execute((CommandSourceStack)context.getSource(), pos, packName, path, rotMir, pretty, plotSize);
    }

    protected static LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)PasteFolderCommand.newLiteral(commandName).then(PasteFolderCommand.newArgument(POS, BlockPosArgument.blockPos()).then(PasteFolderCommand.newArgument(PACK_NAME, StringArgumentType.string()).then(((RequiredArgumentBuilder)PasteFolderCommand.newArgument(FILE_PATH, StringArgumentType.string()).executes(PasteFolderCommand::onExecute)).then(((RequiredArgumentBuilder)PasteFolderCommand.newArgument(ROT_MIR, EnumArgument.enumArgument(RotationMirror.class)).executes(PasteFolderCommand::onExecuteWithRotationAndMirror)).then(((RequiredArgumentBuilder)PasteFolderCommand.newArgument(PRETTY, BoolArgumentType.bool()).executes(PasteFolderCommand::onExecuteWithPretty)).then(PasteFolderCommand.newArgument(PLOT_SIZE, IntegerArgumentType.integer((int)16, (int)128)).executes(PasteFolderCommand::onExecuteWithFull)))))));
    }

    private static /* synthetic */ void lambda$execute$0(RotationMirror rotMir, Level world, BlockPos pos, Player player, boolean pretty, String packName, String path, int plotSize, List list) {
        LinkedHashMap<String, List> blueprintMapping = new LinkedHashMap<String, List>();
        for (Blueprint blueprint : list) {
            BlockState anchor = blueprint.getBlockState(blueprint.getPrimaryBlockOffset());
            if (anchor.getBlock() instanceof ILeveledBlueprintAnchorBlock) {
                int level = ((ILeveledBlueprintAnchorBlock)anchor.getBlock()).getLevel(blueprint.getTileEntityData(BlockPos.ZERO, blueprint.getPrimaryBlockOffset()));
                String name = blueprint.getFileName().replace(Integer.toString(level), "");
                List blueprintList = blueprintMapping.getOrDefault(name, new ArrayList());
                blueprintList.add(blueprint);
                blueprintMapping.put(name, blueprintList);
                continue;
            }
            String name = blueprint.getFileName();
            List blueprintList = blueprintMapping.getOrDefault(name, new ArrayList());
            blueprintList.add(blueprint);
            blueprintMapping.put(name, blueprintList);
        }
        int xOffset = 0;
        int zOffset = 0;
        for (List perTypeList : blueprintMapping.values()) {
            for (Blueprint blueprint : perTypeList) {
                AbstractStructureHandler structure;
                BlockState anchor = blueprint.getBlockState(blueprint.getPrimaryBlockOffset());
                blueprint.setRotationMirror(rotMir, world);
                BlockPos placementPos = pos.offset(xOffset, 0, zOffset).offset((Vec3i)blueprint.getPrimaryBlockOffset());
                Block patt0$temp = anchor.getBlock();
                if (patt0$temp instanceof ISpecialCreativeHandlerAnchorBlock) {
                    ISpecialCreativeHandlerAnchorBlock specialAnchor = (ISpecialCreativeHandlerAnchorBlock)patt0$temp;
                    if (!specialAnchor.setup((ServerPlayer)player, world, placementPos, blueprint, rotMir, pretty, packName, path)) {
                        return;
                    }
                    structure = specialAnchor.getStructureHandler(world, placementPos, blueprint, rotMir, pretty);
                } else {
                    structure = new CreativeStructureHandler(world, placementPos, blueprint, rotMir, pretty);
                }
                StructurePlacer instantPlacer = new StructurePlacer(structure);
                Manager.addToQueue(new PlaceStructureOperation(instantPlacer, player));
                zOffset += plotSize;
            }
            xOffset += plotSize;
            zOffset = 0;
        }
    }
}

