/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client.gui;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.views.ScrollingList;
import com.ldtteam.structurize.api.TagManager;
import com.ldtteam.structurize.blockentities.interfaces.IBlueprintDataProviderBE;
import com.ldtteam.structurize.blocks.interfaces.IAnchorBlock;
import com.ldtteam.structurize.client.gui.AbstractWindowSkeleton;
import com.ldtteam.structurize.items.ItemTagTool;
import com.ldtteam.structurize.network.messages.AddRemoveTagMessage;
import com.ldtteam.structurize.network.messages.SetTagInTool;
import com.ldtteam.structurize.util.BlockUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class WindowTagTool
extends AbstractWindowSkeleton {
    private static final String WINDOW_TAG_TOOL = ":gui/windowtagtool.xml";
    private static final String INPUT_FIELD = "currentTag";
    private static final String LIST_TAG_POS = "tagposlist";
    private static final String LIST_BLOCK = "posblock";
    private static final String TAG_TEXT = "tagnames";
    private static final String BUTTON_CANCEL = "cancel";
    private static final String BUTTON_CLOSE = "closeUI";
    private static final String BUTTON_LIST_REMOVE = "removeTag";
    private static final String LIST_TAG_OPTION = "tagoptionlist";
    private static final String TAG_SELECT = "select";
    private String currentTag = "";
    private Level world;
    private BlockPos anchorPos = null;
    private ItemStack stack;
    private ScrollingList tagList;
    private List<BlockPos> positionsList = Collections.emptyList();
    private ScrollingList tagOptionList;
    private List<String> tagOptions = new ArrayList<String>();

    public WindowTagTool(String currentTag, BlockPos anchorPos, Level world, ItemStack stack) {
        super("structurize:gui/windowtagtool.xml");
        Block block;
        this.world = world;
        this.currentTag = currentTag;
        this.anchorPos = anchorPos;
        this.stack = stack;
        this.tagOptions.addAll(TagManager.getGlobalTagOptions());
        if (anchorPos != null && (block = world.getBlockState(anchorPos).getBlock()) instanceof IAnchorBlock) {
            IAnchorBlock anchorBlock = (IAnchorBlock)block;
            this.tagOptions.addAll(TagManager.getMatchingTagOptions(anchorBlock));
        }
        this.registerButton(TAG_SELECT, this::tagOptionSelected);
    }

    private void tagOptionSelected(Button button) {
        int row = this.tagOptionList.getListElementIndexByPane((Pane)button);
        this.currentTag = this.tagOptions.get(row);
        ((TextField)this.findPaneOfTypeByID(INPUT_FIELD, TextField.class)).setText(this.currentTag);
    }

    public void onOpened() {
        super.onOpened();
        ((TextField)this.findPaneOfTypeByID(INPUT_FIELD, TextField.class)).setText(this.currentTag);
        this.tagList = (ScrollingList)this.findPaneOfTypeByID(LIST_TAG_POS, ScrollingList.class);
        this.tagOptionList = (ScrollingList)this.findPaneOfTypeByID(LIST_TAG_OPTION, ScrollingList.class);
        this.registerButton(BUTTON_CANCEL, this::onCancel);
        this.registerButton(BUTTON_CLOSE, this::onCancel);
        this.registerButton(BUTTON_LIST_REMOVE, this::removeTag);
        this.updateResourceList();
        this.updateTagOptionList();
    }

    public void close() {
        super.close();
        this.currentTag = ((TextField)this.findPaneOfTypeByID(INPUT_FIELD, TextField.class)).getText();
        ItemTagTool.TagData.updateItemStack(this.stack, tags -> tags.setCurrentTag(this.currentTag));
        new SetTagInTool(this.currentTag, Minecraft.getInstance().player.getInventory().findSlotMatchingItem(this.stack)).sendToServer();
    }

    public boolean onKeyTyped(char ch, int key) {
        boolean returnValue = super.onKeyTyped(ch, key);
        this.updateTagOptionList();
        this.currentTag = ((TextField)this.findPaneOfTypeByID(INPUT_FIELD, TextField.class)).getText();
        return returnValue;
    }

    private void removeTag(Button button) {
        int row = this.tagList.getListElementIndexByPane((Pane)button);
        BlockPos toRemove = this.positionsList.get(row);
        BlockEntity te = this.world.getBlockEntity(this.anchorPos);
        if (te instanceof IBlueprintDataProviderBE) {
            IBlueprintDataProviderBE dataTE = (IBlueprintDataProviderBE)te;
            Map<BlockPos, List<String>> map = dataTE.getPositionedTags();
            if (map.containsKey(toRemove) && !map.get(toRemove).isEmpty()) {
                String tag = map.get(toRemove).get(map.get(toRemove).size() - 1);
                dataTE.removeTag(toRemove, tag);
                new AddRemoveTagMessage(false, tag, toRemove, this.anchorPos).sendToServer();
            }
            this.updateResourceList();
        } else {
            this.close();
        }
    }

    private void onCancel() {
        this.close();
    }

    public void updateResourceList() {
        this.tagList.enable();
        this.tagList.show();
        BlockEntity te = this.world.getBlockEntity(this.anchorPos);
        if (te instanceof IBlueprintDataProviderBE) {
            IBlueprintDataProviderBE dataTE = (IBlueprintDataProviderBE)te;
            this.positionsList = new ArrayList<BlockPos>(dataTE.getPositionedTags().keySet());
        } else {
            this.close();
        }
        this.tagList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowTagTool.this.positionsList.size();
            }

            public void updateElement(int index, Pane rowPane) {
                BlockEntity te = WindowTagTool.this.world.getBlockEntity(WindowTagTool.this.anchorPos);
                if (te instanceof IBlueprintDataProviderBE) {
                    IBlueprintDataProviderBE dataTE = (IBlueprintDataProviderBE)te;
                    WindowTagTool.this.positionsList = new ArrayList<BlockPos>(dataTE.getPositionedTags().keySet());
                    WindowTagTool.this.positionsList = new ArrayList<BlockPos>(dataTE.getPositionedTags().keySet());
                    BlockPos pos = WindowTagTool.this.positionsList.get(index);
                    List<String> tags = dataTE.getPositionedTags().get(pos);
                    ItemStack displayStack = BlockUtils.getItemStackFromBlockState(WindowTagTool.this.world.getBlockState(dataTE.getRealWorldPos(pos)));
                    ((ItemIcon)rowPane.findPaneOfTypeByID(WindowTagTool.LIST_BLOCK, ItemIcon.class)).setItem(displayStack);
                    Text tagsText = (Text)rowPane.findPaneOfTypeByID(WindowTagTool.TAG_TEXT, Text.class);
                    tagsText.setText(Component.literal((String)tags.toString()));
                } else {
                    WindowTagTool.this.close();
                }
            }
        });
    }

    public void updateTagOptionList() {
        this.tagOptionList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowTagTool.this.tagOptions.size();
            }

            public void updateElement(int index, Pane rowPane) {
                Text tagsText = (Text)rowPane.findPaneOfTypeByID(WindowTagTool.TAG_TEXT, Text.class);
                tagsText.setText(Component.literal((String)WindowTagTool.this.tagOptions.get(index)));
                PaneBuilders.tooltipBuilder().hoverPane((Pane)tagsText).build().setText(Component.translatable((String)("com.ldtteam.tag.tooltip." + WindowTagTool.this.tagOptions.get(index))));
                Button button = (Button)rowPane.findPaneOfTypeByID(WindowTagTool.TAG_SELECT, Button.class);
                button.setEnabled(!WindowTagTool.this.tagOptions.get(index).equals(WindowTagTool.this.currentTag));
            }
        });
    }
}

