/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client;

import com.ldtteam.structurize.items.ItemStackTooltip;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class ClientItemStackTooltip
implements ClientTooltipComponent {
    private final ItemStackTooltip component;

    public ClientItemStackTooltip(@NotNull ItemStackTooltip component) {
        this.component = component;
    }

    public int getHeight() {
        return 20;
    }

    public int getWidth(@NotNull Font font) {
        return 20 + font.width(this.component.getStack().getDisplayName().getVisualOrderText());
    }

    public void renderText(@NotNull Font font, int x, int y, @NotNull Matrix4f pose, @NotNull MultiBufferSource.BufferSource buffers) {
        Component component = this.component.getStack().getHoverName();
        float f = x + 20;
        float f2 = y;
        Objects.requireNonNull(font);
        font.drawInBatch(component, f, f2 + (float)(20 - 9) / 2.0f, -1, false, pose, (MultiBufferSource)buffers, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    public void renderImage(Font font, int x, int y, GuiGraphics target) {
        target.renderItem(this.component.getStack(), x + 2, y + 2);
        target.renderItemDecorations(this.getFont(this.component.getStack()), this.component.getStack(), x + 2, y + 2);
    }

    private Font getFont(ItemStack itemStack) {
        Font font;
        if (itemStack != null && (font = IClientItemExtensions.of((ItemStack)itemStack).getFont(itemStack, IClientItemExtensions.FontContext.ITEM_COUNT)) != null) {
            return font;
        }
        return Minecraft.getInstance().font;
    }
}

