/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.api;

import com.ldtteam.structurize.api.Log;
import java.io.File;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public final class Utils {
    private Utils() {
    }

    public static void playSuccessSound(@NotNull Player player) {
        player.playNotifySound((SoundEvent)SoundEvents.NOTE_BLOCK_BELL.value(), SoundSource.NEUTRAL, 1.0f, 1.0f);
    }

    public static void playErrorSound(@NotNull Player player) {
        player.playNotifySound((SoundEvent)SoundEvents.NOTE_BLOCK_DIDGERIDOO.value(), SoundSource.NEUTRAL, 1.0f, 0.3f);
    }

    public static void checkDirectory(File directory) {
        if (!directory.exists() && !directory.mkdirs()) {
            Log.getLogger().error("Directory doesn't exist and failed to be created: " + directory.toString());
        }
    }

    public static boolean nbtContains(CompoundTag originTag, CompoundTag compareTag) {
        for (String childTagKey : originTag.getAllKeys()) {
            Tag compareChildTag;
            Tag originChildTag = originTag.get(childTagKey);
            if (Objects.equals(originChildTag, compareChildTag = compareTag.get(childTagKey))) continue;
            return false;
        }
        return true;
    }
}

