/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.jupiter.interfaces;

import com.google.gson.JsonParseException;
import com.iafenvoy.jupiter.config.type.ConfigType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.function.Consumer;
import net.minecraft.client.resources.language.I18n;

public interface IConfigEntry<T> {
    public ConfigType<T> getType();

    default public String getJsonKey() {
        return this.getNameKey();
    }

    public String getNameKey();

    public IConfigEntry<T> newInstance();

    default public String getPrettyName() {
        return I18n.get((String)this.getNameKey(), (Object[])new Object[0]);
    }

    public void registerCallback(Consumer<T> var1);

    public T getValue();

    public T getDefaultValue();

    public void setValue(T var1);

    public Codec<T> getCodec();

    default public <R> DataResult<R> encode(DynamicOps<R> ops) {
        return this.getCodec().encodeStart(ops, this.getValue());
    }

    default public <R> void decode(DynamicOps<R> ops, R input) {
        this.setValue(this.getCodec().parse(ops, input).getPartialOrThrow(JsonParseException::new));
    }

    public void reset();
}

