/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.util;

import com.hrznstudio.titanium.block.BasicBlock;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RayTraceUtils {
    public static HitResult rayTraceSimple(Level world, LivingEntity living, double blockReachDistance, float partialTicks) {
        Vec3 vec3d = living.getEyePosition(partialTicks);
        Vec3 vec3d1 = living.getViewVector(partialTicks);
        Vec3 vec3d2 = vec3d.add(vec3d1.x * blockReachDistance, vec3d1.y * blockReachDistance, vec3d1.z * blockReachDistance);
        return world.clip(new ClipContext(vec3d, vec3d2, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)living));
    }

    @Nullable
    public static VoxelShape rayTraceVoxelShape(BlockHitResult original, Level world, LivingEntity living, double blockReachDistance, float partialTicks) {
        BlockState og = world.getBlockState(original.getBlockPos());
        if (og.getBlock() instanceof BasicBlock && ((BasicBlock)og.getBlock()).hasIndividualRenderVoxelShape()) {
            Vec3 vec3d = living.getEyePosition(partialTicks);
            Vec3 vec3d1 = living.getViewVector(partialTicks);
            Vec3 vec3d2 = vec3d.add(vec3d1.x * blockReachDistance, vec3d1.y * blockReachDistance, vec3d1.z * blockReachDistance);
            List<VoxelShape> voxelShapes = ((BasicBlock)og.getBlock()).getBoundingBoxes(og, (BlockGetter)world, original.getBlockPos());
            if (voxelShapes.size() > 0) {
                VoxelShape closest = Shapes.empty();
                double distance = Double.MAX_VALUE;
                for (VoxelShape voxelShape : voxelShapes) {
                    BlockHitResult result = voxelShape.clip(vec3d, vec3d2, original.getBlockPos());
                    if (result == null || !(vec3d.distanceTo(result.getLocation()) < distance)) continue;
                    closest = voxelShape;
                    distance = vec3d.distanceTo(result.getLocation());
                }
                return closest;
            }
        }
        return Shapes.empty();
    }
}

