/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.util;

import javax.annotation.Nullable;
import net.minecraft.core.Direction;

public class FacingUtil {
    public static Sideness getFacingRelative(Direction relative, @Nullable Direction facing) {
        if (facing == null) {
            return null;
        }
        if (facing == Direction.UP) {
            return Sideness.TOP;
        }
        if (facing == Direction.DOWN) {
            return Sideness.BOTTOM;
        }
        if (relative == facing) {
            return Sideness.FRONT;
        }
        if (relative == facing.getOpposite()) {
            return Sideness.BACK;
        }
        if (relative == facing.getCounterClockWise()) {
            return Sideness.LEFT;
        }
        if (relative == facing.getClockWise()) {
            return Sideness.RIGHT;
        }
        return Sideness.BOTTOM;
    }

    public static Direction getFacingFromSide(Direction block, Sideness sideness) {
        if (block.getAxis().isHorizontal()) {
            if (sideness == Sideness.TOP) {
                return Direction.UP;
            }
            if (sideness == Sideness.BOTTOM) {
                return Direction.DOWN;
            }
            if (sideness == Sideness.FRONT) {
                return block;
            }
            if (sideness == Sideness.BACK) {
                return block.getOpposite();
            }
            if (sideness == Sideness.RIGHT) {
                return block.getCounterClockWise();
            }
            if (sideness == Sideness.LEFT) {
                return block.getClockWise();
            }
        }
        return Direction.NORTH;
    }

    public static enum Sideness {
        FRONT,
        BACK,
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }
}

