/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.multiblock;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.worlddata.AbstractWorldData;
import mcjty.xnet.multiblock.WorldBlob;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class XNetBlobData
extends AbstractWorldData<XNetBlobData> {
    private static final String NAME = "XNetBlobData";
    private final Map<ResourceKey<Level>, WorldBlob> worldBlobMap = new HashMap<ResourceKey<Level>, WorldBlob>();

    public XNetBlobData() {
    }

    public XNetBlobData(CompoundTag tag) {
        if (tag.contains("worlds")) {
            ListTag worlds = (ListTag)tag.get("worlds");
            for (Tag world : worlds) {
                CompoundTag tc = (CompoundTag)world;
                ResourceKey dim = LevelTools.getId((String)tc.getString("dimtype"));
                WorldBlob blob = new WorldBlob((ResourceKey<Level>)dim);
                blob.readFromNBT(tc);
                this.worldBlobMap.put((ResourceKey<Level>)dim, blob);
            }
        }
    }

    @Nonnull
    public static XNetBlobData get(Level world) {
        return (XNetBlobData)XNetBlobData.getData((Level)world, XNetBlobData::new, XNetBlobData::new, (String)NAME);
    }

    public WorldBlob getWorldBlob(Level world) {
        return this.getWorldBlob((ResourceKey<Level>)world.dimension());
    }

    public WorldBlob getWorldBlob(ResourceKey<Level> type) {
        if (!this.worldBlobMap.containsKey(type)) {
            this.worldBlobMap.put(type, new WorldBlob(type));
        }
        return this.worldBlobMap.get(type);
    }

    @Nonnull
    public CompoundTag save(@Nonnull CompoundTag compound, HolderLookup.Provider provider) {
        ListTag list = new ListTag();
        for (Map.Entry<ResourceKey<Level>, WorldBlob> entry : this.worldBlobMap.entrySet()) {
            WorldBlob blob = entry.getValue();
            CompoundTag tc = new CompoundTag();
            tc.putString("dimtype", blob.getDimensionType().location().toString());
            blob.writeToNBT(tc);
            list.add((Object)tc);
        }
        compound.put("worlds", (Tag)list);
        return compound;
    }
}

