/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.wireless;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.blocks.RBlock;
import mcjty.lib.blocks.RotationType;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.datagen.DataGen;
import mcjty.lib.datagen.Dob;
import mcjty.lib.modules.IModule;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.modules.various.VariousModule;
import mcjty.xnet.XNet;
import mcjty.xnet.modules.controller.blocks.TileEntityController;
import mcjty.xnet.modules.wireless.blocks.TileEntityWirelessRouter;
import mcjty.xnet.modules.wireless.client.GuiWirelessRouter;
import mcjty.xnet.modules.wireless.data.WirelessRouterData;
import mcjty.xnet.setup.Config;
import mcjty.xnet.setup.Registration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;

public class WirelessRouterModule
implements IModule {
    public static final RBlock<BaseBlock, BlockItem, TileEntityWirelessRouter> WIRELESS_ROUTER = Registration.RBLOCKS.registerBlock("wireless_router", TileEntityWirelessRouter.class, TileEntityWirelessRouter::createBlock, block -> new BlockItem((Block)block.get(), Registration.createStandardProperties()), TileEntityWirelessRouter::new);
    public static final Supplier<MenuType<GenericContainer>> CONTAINER_WIRELESS_ROUTER = Registration.CONTAINERS.register("wireless_router", GenericContainer::createContainerType);
    public static final DeferredBlock<BaseBlock> ANTENNA = Registration.BLOCKS.register("antenna", WirelessRouterModule::createAntennaBlock);
    public static final DeferredItem<Item> ANTENNA_ITEM = Registration.ITEMS.register("antenna", XNet.tab(() -> new BlockItem((Block)ANTENNA.get(), Registration.createStandardProperties())));
    public static final DeferredBlock<BaseBlock> ANTENNA_BASE = Registration.BLOCKS.register("antenna_base", WirelessRouterModule::createAntennaBaseBlock);
    public static final DeferredItem<Item> ANTENNA_BASE_ITEM = Registration.ITEMS.register("antenna_base", XNet.tab(() -> new BlockItem((Block)ANTENNA_BASE.get(), Registration.createStandardProperties())));
    public static final DeferredBlock<BaseBlock> ANTENNA_DISH = Registration.BLOCKS.register("antenna_dish", WirelessRouterModule::createAntennaDishBlock);
    public static final DeferredItem<Item> ANTENNA_DISH_ITEM = Registration.ITEMS.register("antenna_dish", XNet.tab(() -> new BlockItem((Block)ANTENNA_DISH.get(), Registration.createStandardProperties())));
    public static final Supplier<AttachmentType<WirelessRouterData>> WIRELESS_ROUTER_DATA = Registration.ATTACHMENT_TYPES.register("wireless_router_data", () -> AttachmentType.builder(() -> WirelessRouterData.EMPTY).serialize(WirelessRouterData.CODEC).build());
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<WirelessRouterData>> ITEM_WIRELESS_ROUTER_DATA = Registration.COMPONENTS.registerComponentType("wireless_router_data", builder -> builder.persistent(WirelessRouterData.CODEC).networkSynchronized(WirelessRouterData.STREAM_CODEC));
    public static final VoxelShape SMALLER_CUBE = Shapes.box((double)0.01f, (double)0.01f, (double)0.01f, (double)0.99f, (double)0.99f, (double)0.99f);

    private static BaseBlock createAntennaDishBlock() {
        return new BaseBlock(new BlockBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.xnet.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.parameter((String)"info", stack -> Integer.toString((Integer)Config.wirelessRouterRfPerChannel[2].get()) + " rf/t/channel")})){

            public RotationType getRotationType() {
                return RotationType.HORIZROTATION;
            }

            @Nonnull
            public VoxelShape getOcclusionShape(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos) {
                return SMALLER_CUBE;
            }
        };
    }

    private static BaseBlock createAntennaBaseBlock() {
        return new BaseBlock(new BlockBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.xnet.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()})){

            public RotationType getRotationType() {
                return RotationType.NONE;
            }

            @Nonnull
            public VoxelShape getOcclusionShape(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos) {
                return SMALLER_CUBE;
            }
        };
    }

    private static BaseBlock createAntennaBlock() {
        return new BaseBlock(new BlockBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.xnet.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.parameter((String)"one", stack -> "range " + Integer.toString((Integer)Config.antennaTier1Range.get()) + " (" + Integer.toString((Integer)Config.wirelessRouterRfPerChannel[0].get()) + " rf/t/channel)"), TooltipBuilder.parameter((String)"two", stack -> "range " + Integer.toString((Integer)Config.antennaTier2Range.get()) + " (" + Integer.toString((Integer)Config.wirelessRouterRfPerChannel[1].get()) + " rf/t/channel)")})){

            public RotationType getRotationType() {
                return RotationType.HORIZROTATION;
            }

            @Nonnull
            public VoxelShape getOcclusionShape(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos) {
                return SMALLER_CUBE;
            }
        };
    }

    public WirelessRouterModule(IEventBus bus) {
        bus.addListener(this::registerScreens);
    }

    public void init(FMLCommonSetupEvent event) {
    }

    public void initClient(FMLClientSetupEvent event) {
    }

    public void registerScreens(RegisterMenuScreensEvent event) {
        GuiWirelessRouter.register(event);
    }

    public void initConfig(IEventBus bus) {
    }

    public void initDatagen(DataGen dataGen, HolderLookup.Provider provider) {
        dataGen.add(new Dob.Builder[]{Dob.blockBuilder(WIRELESS_ROUTER).ironPickaxeTags().parentedItem("block/wireless_router").standardLoot(new DataComponentType[]{(DataComponentType)ITEM_WIRELESS_ROUTER_DATA.get()}).blockState(p -> {
            ModelFile modelOk = p.frontBasedModel("wireless_router", p.modLoc("block/machine_wireless_router"));
            ModelFile modelError = p.frontBasedModel("wireless_router_error", p.modLoc("block/machine_wireless_router_error"));
            VariantBlockStateBuilder builder = p.getVariantBuilder((Block)WIRELESS_ROUTER.block().get());
            for (Direction direction : OrientationTools.DIRECTION_VALUES) {
                p.applyRotation(builder.partialState().with((Property)BlockStateProperties.FACING, (Comparable)direction).with((Property)TileEntityController.ERROR, (Comparable)Boolean.valueOf(false)).modelForState().modelFile(modelOk), direction);
                p.applyRotation(builder.partialState().with((Property)BlockStateProperties.FACING, (Comparable)direction).with((Property)TileEntityController.ERROR, (Comparable)Boolean.valueOf(true)).modelForState().modelFile(modelError), direction);
            }
        }).shaped(builder -> builder.define(Character.valueOf('F'), (ItemLike)VariousModule.MACHINE_FRAME.get()).define(Character.valueOf('C'), (ItemLike)Items.COMPARATOR).unlockedBy("frame", DataGen.has((ItemLike)((ItemLike)VariousModule.MACHINE_FRAME.get()))), new String[]{"oCo", "rFr", "oro"}), Dob.blockBuilder(ANTENNA).simpleLoot().ironPickaxeTags().shaped(builder -> builder.define(Character.valueOf('I'), (ItemLike)Items.IRON_BARS).unlockedBy("bars", DataGen.has((ItemLike)Items.IRON_BARS)), new String[]{"IiI", "IiI", " i "}), Dob.blockBuilder(ANTENNA_BASE).simpleLoot().ironPickaxeTags().shaped(builder -> builder.define(Character.valueOf('I'), (ItemLike)Items.IRON_BLOCK).unlockedBy("block", DataGen.has((ItemLike)Items.IRON_BLOCK)), new String[]{" i ", " i ", "iIi"}), Dob.blockBuilder(ANTENNA_DISH).simpleLoot().ironPickaxeTags().shaped(builder -> builder.define(Character.valueOf('I'), (ItemLike)Items.IRON_TRAPDOOR).unlockedBy("trapdoor", DataGen.has((ItemLike)Items.IRON_TRAPDOOR)), new String[]{"III", "IoI", " i "})});
    }
}

