/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.cables.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import mcjty.lib.client.CustomRenderTypes;
import mcjty.lib.client.RenderHelper;
import mcjty.xnet.modules.cables.CableColor;
import mcjty.xnet.modules.cables.ConnectorType;
import mcjty.xnet.modules.cables.blocks.GenericCableBlock;
import mcjty.xnet.modules.facade.IFacadeSupport;
import mcjty.xnet.modules.facade.blocks.FacadeBlock;
import mcjty.xnet.setup.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

public class CableWorldRenderer {
    public static void tick(RenderLevelStageEvent evt) {
        Minecraft mc = Minecraft.getInstance();
        ItemStack heldItem = mc.player.getItemInHand(InteractionHand.MAIN_HAND);
        if (!heldItem.isEmpty() && heldItem.getItem() instanceof BlockItem && ((BlockItem)heldItem.getItem()).getBlock() instanceof GenericCableBlock) {
            CableWorldRenderer.renderCables(evt, mc);
        }
    }

    private static void renderCables(RenderLevelStageEvent evt, Minecraft mc) {
        if (evt.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        LocalPlayer p = mc.player;
        PoseStack matrixStack = evt.getPoseStack();
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        VertexConsumer builder = buffer.getBuffer(CustomRenderTypes.OVERLAY_LINES);
        ClientLevel world = mc.level;
        matrixStack.pushPose();
        Vec3 projectedView = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        matrixStack.translate(-projectedView.x, -projectedView.y, -projectedView.z);
        for (int dx = -20; dx <= 20; ++dx) {
            for (int dy = -20; dy <= 20; ++dy) {
                for (int dz = -20; dz <= 20; ++dz) {
                    BlockPos c = p.blockPosition().offset(dx, dy, dz);
                    BlockState state = world.getBlockState(c);
                    Block block = state.getBlock();
                    if (!(block instanceof GenericCableBlock)) continue;
                    BlockEntity te = world.getBlockEntity(c);
                    if (te instanceof IFacadeSupport) {
                        IFacadeSupport facadeSupport = (IFacadeSupport)te;
                        BlockState facadeId = facadeSupport.getMimicBlock();
                        if (!(((Boolean)Config.showNonFacadedCablesWhileSneaking.get()).booleanValue() && p.isShiftKeyDown() || facadeId != null || block instanceof FacadeBlock)) {
                            continue;
                        }
                    } else if (!((Boolean)Config.showNonFacadedCablesWhileSneaking.get()).booleanValue() || !p.isShiftKeyDown()) continue;
                    CableColor color = (CableColor)((Object)state.getValue(GenericCableBlock.COLOR));
                    float r = 0.0f;
                    float g = 0.0f;
                    float b = 0.0f;
                    switch (color) {
                        case BLUE: {
                            r = 0.4f;
                            g = 0.4f;
                            b = 1.0f;
                            break;
                        }
                        case RED: {
                            r = 1.0f;
                            g = 0.4f;
                            b = 0.4f;
                            break;
                        }
                        case YELLOW: {
                            r = 1.0f;
                            g = 1.0f;
                            b = 0.4f;
                            break;
                        }
                        case GREEN: {
                            r = 0.4f;
                            g = 1.0f;
                            b = 0.4f;
                            break;
                        }
                        case ROUTING: {
                            r = 0.7f;
                            g = 0.7f;
                            b = 0.7f;
                        }
                    }
                    List<RenderHelper.Rect> quads = CableWorldRenderer.getQuads(state);
                    for (RenderHelper.Rect quad : quads) {
                        RenderHelper.renderRect((PoseStack)matrixStack, (VertexConsumer)builder, (RenderHelper.Rect)quad, (BlockPos)c, (float)r, (float)g, (float)b, (float)0.5f);
                    }
                }
            }
        }
        matrixStack.popPose();
        RenderSystem.disableDepthTest();
        buffer.endBatch(CustomRenderTypes.OVERLAY_LINES);
    }

    private static Vec3 v(double x, double y, double z) {
        return new Vec3(x, y, z);
    }

    private static List<RenderHelper.Rect> getQuads(BlockState state) {
        ConnectorType north = (ConnectorType)((Object)state.getValue(GenericCableBlock.NORTH));
        ConnectorType south = (ConnectorType)((Object)state.getValue(GenericCableBlock.SOUTH));
        ConnectorType west = (ConnectorType)((Object)state.getValue(GenericCableBlock.WEST));
        ConnectorType east = (ConnectorType)((Object)state.getValue(GenericCableBlock.EAST));
        ConnectorType up = (ConnectorType)((Object)state.getValue(GenericCableBlock.UP));
        ConnectorType down = (ConnectorType)((Object)state.getValue(GenericCableBlock.DOWN));
        ArrayList<RenderHelper.Rect> quads = new ArrayList<RenderHelper.Rect>();
        double o = 0.4;
        double p = 0.1;
        double q = 0.2;
        if (up == ConnectorType.CABLE) {
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(1.0 - o, 1.0, o), CableWorldRenderer.v(1.0 - o, 1.0, 1.0 - o), CableWorldRenderer.v(1.0 - o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(1.0 - o, 1.0 - o, o)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(o, 1.0, 1.0 - o), CableWorldRenderer.v(o, 1.0, o), CableWorldRenderer.v(o, 1.0 - o, o), CableWorldRenderer.v(o, 1.0 - o, 1.0 - o)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(o, 1.0, o), CableWorldRenderer.v(1.0 - o, 1.0, o), CableWorldRenderer.v(1.0 - o, 1.0 - o, o), CableWorldRenderer.v(o, 1.0 - o, o)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(1.0 - o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(1.0 - o, 1.0, 1.0 - o), CableWorldRenderer.v(o, 1.0, 1.0 - o)));
        } else if (up == ConnectorType.BLOCK) {
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(1.0 - o, 1.0 - p, o), CableWorldRenderer.v(1.0 - o, 1.0 - p, 1.0 - o), CableWorldRenderer.v(1.0 - o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(1.0 - o, 1.0 - o, o)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(o, 1.0 - p, 1.0 - o), CableWorldRenderer.v(o, 1.0 - p, o), CableWorldRenderer.v(o, 1.0 - o, o), CableWorldRenderer.v(o, 1.0 - o, 1.0 - o)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(o, 1.0 - p, o), CableWorldRenderer.v(1.0 - o, 1.0 - p, o), CableWorldRenderer.v(1.0 - o, 1.0 - o, o), CableWorldRenderer.v(o, 1.0 - o, o)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(1.0 - o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(1.0 - o, 1.0 - p, 1.0 - o), CableWorldRenderer.v(o, 1.0 - p, 1.0 - o)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(1.0 - q, 1.0 - p, q), CableWorldRenderer.v(1.0 - q, 1.0, q), CableWorldRenderer.v(1.0 - q, 1.0, 1.0 - q), CableWorldRenderer.v(1.0 - q, 1.0 - p, 1.0 - q)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(q, 1.0 - p, 1.0 - q), CableWorldRenderer.v(q, 1.0, 1.0 - q), CableWorldRenderer.v(q, 1.0, q), CableWorldRenderer.v(q, 1.0 - p, q)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(q, 1.0, q), CableWorldRenderer.v(1.0 - q, 1.0, q), CableWorldRenderer.v(1.0 - q, 1.0 - p, q), CableWorldRenderer.v(q, 1.0 - p, q)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(q, 1.0 - p, 1.0 - q), CableWorldRenderer.v(1.0 - q, 1.0 - p, 1.0 - q), CableWorldRenderer.v(1.0 - q, 1.0, 1.0 - q), CableWorldRenderer.v(q, 1.0, 1.0 - q)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(q, 1.0 - p, q), CableWorldRenderer.v(1.0 - q, 1.0 - p, q), CableWorldRenderer.v(1.0 - q, 1.0 - p, 1.0 - q), CableWorldRenderer.v(q, 1.0 - p, 1.0 - q)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(q, 1.0, q), CableWorldRenderer.v(q, 1.0, 1.0 - q), CableWorldRenderer.v(1.0 - q, 1.0, 1.0 - q), CableWorldRenderer.v(1.0 - q, 1.0, q)));
        } else {
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(1.0 - o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(1.0 - o, 1.0 - o, o), CableWorldRenderer.v(o, 1.0 - o, o)));
        }
        if (down == ConnectorType.CABLE) {
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(1.0 - o, o, o), CableWorldRenderer.v(1.0 - o, o, 1.0 - o), CableWorldRenderer.v(1.0 - o, 0.0, 1.0 - o), CableWorldRenderer.v(1.0 - o, 0.0, o)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(o, o, 1.0 - o), CableWorldRenderer.v(o, o, o), CableWorldRenderer.v(o, 0.0, o), CableWorldRenderer.v(o, 0.0, 1.0 - o)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(o, o, o), CableWorldRenderer.v(1.0 - o, o, o), CableWorldRenderer.v(1.0 - o, 0.0, o), CableWorldRenderer.v(o, 0.0, o)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(o, 0.0, 1.0 - o), CableWorldRenderer.v(1.0 - o, 0.0, 1.0 - o), CableWorldRenderer.v(1.0 - o, o, 1.0 - o), CableWorldRenderer.v(o, o, 1.0 - o)));
        } else if (down == ConnectorType.BLOCK) {
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(1.0 - o, o, o), CableWorldRenderer.v(1.0 - o, o, 1.0 - o), CableWorldRenderer.v(1.0 - o, p, 1.0 - o), CableWorldRenderer.v(1.0 - o, p, o)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(o, o, 1.0 - o), CableWorldRenderer.v(o, o, o), CableWorldRenderer.v(o, p, o), CableWorldRenderer.v(o, p, 1.0 - o)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(o, o, o), CableWorldRenderer.v(1.0 - o, o, o), CableWorldRenderer.v(1.0 - o, p, o), CableWorldRenderer.v(o, p, o)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(o, p, 1.0 - o), CableWorldRenderer.v(1.0 - o, p, 1.0 - o), CableWorldRenderer.v(1.0 - o, o, 1.0 - o), CableWorldRenderer.v(o, o, 1.0 - o)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(1.0 - q, 0.0, q), CableWorldRenderer.v(1.0 - q, p, q), CableWorldRenderer.v(1.0 - q, p, 1.0 - q), CableWorldRenderer.v(1.0 - q, 0.0, 1.0 - q)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(q, 0.0, 1.0 - q), CableWorldRenderer.v(q, p, 1.0 - q), CableWorldRenderer.v(q, p, q), CableWorldRenderer.v(q, 0.0, q)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(q, p, q), CableWorldRenderer.v(1.0 - q, p, q), CableWorldRenderer.v(1.0 - q, 0.0, q), CableWorldRenderer.v(q, 0.0, q)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(q, 0.0, 1.0 - q), CableWorldRenderer.v(1.0 - q, 0.0, 1.0 - q), CableWorldRenderer.v(1.0 - q, p, 1.0 - q), CableWorldRenderer.v(q, p, 1.0 - q)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(q, p, 1.0 - q), CableWorldRenderer.v(1.0 - q, p, 1.0 - q), CableWorldRenderer.v(1.0 - q, p, q), CableWorldRenderer.v(q, p, q)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(q, 0.0, 1.0 - q), CableWorldRenderer.v(q, 0.0, q), CableWorldRenderer.v(1.0 - q, 0.0, q), CableWorldRenderer.v(1.0 - q, 0.0, 1.0 - q)));
        } else {
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(o, o, o), CableWorldRenderer.v(1.0 - o, o, o), CableWorldRenderer.v(1.0 - o, o, 1.0 - o), CableWorldRenderer.v(o, o, 1.0 - o)));
        }
        if (east == ConnectorType.CABLE) {
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(1.0, 1.0 - o, 1.0 - o), CableWorldRenderer.v(1.0, 1.0 - o, o), CableWorldRenderer.v(1.0 - o, 1.0 - o, o), CableWorldRenderer.v(1.0 - o, 1.0 - o, 1.0 - o)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(1.0, o, o), CableWorldRenderer.v(1.0, o, 1.0 - o), CableWorldRenderer.v(1.0 - o, o, 1.0 - o), CableWorldRenderer.v(1.0 - o, o, o)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(1.0, 1.0 - o, o), CableWorldRenderer.v(1.0, o, o), CableWorldRenderer.v(1.0 - o, o, o), CableWorldRenderer.v(1.0 - o, 1.0 - o, o)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(1.0, o, 1.0 - o), CableWorldRenderer.v(1.0, 1.0 - o, 1.0 - o), CableWorldRenderer.v(1.0 - o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(1.0 - o, o, 1.0 - o)));
        } else if (east == ConnectorType.BLOCK) {
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(1.0 - p, 1.0 - o, 1.0 - o), CableWorldRenderer.v(1.0 - p, 1.0 - o, o), CableWorldRenderer.v(1.0 - o, 1.0 - o, o), CableWorldRenderer.v(1.0 - o, 1.0 - o, 1.0 - o)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(1.0 - p, o, o), CableWorldRenderer.v(1.0 - p, o, 1.0 - o), CableWorldRenderer.v(1.0 - o, o, 1.0 - o), CableWorldRenderer.v(1.0 - o, o, o)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(1.0 - p, 1.0 - o, o), CableWorldRenderer.v(1.0 - p, o, o), CableWorldRenderer.v(1.0 - o, o, o), CableWorldRenderer.v(1.0 - o, 1.0 - o, o)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(1.0 - p, o, 1.0 - o), CableWorldRenderer.v(1.0 - p, 1.0 - o, 1.0 - o), CableWorldRenderer.v(1.0 - o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(1.0 - o, o, 1.0 - o)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(1.0 - p, 1.0 - q, 1.0 - q), CableWorldRenderer.v(1.0, 1.0 - q, 1.0 - q), CableWorldRenderer.v(1.0, 1.0 - q, q), CableWorldRenderer.v(1.0 - p, 1.0 - q, q)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(1.0 - p, q, q), CableWorldRenderer.v(1.0, q, q), CableWorldRenderer.v(1.0, q, 1.0 - q), CableWorldRenderer.v(1.0 - p, q, 1.0 - q)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(1.0 - p, 1.0 - q, q), CableWorldRenderer.v(1.0, 1.0 - q, q), CableWorldRenderer.v(1.0, q, q), CableWorldRenderer.v(1.0 - p, q, q)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(1.0 - p, q, 1.0 - q), CableWorldRenderer.v(1.0, q, 1.0 - q), CableWorldRenderer.v(1.0, 1.0 - q, 1.0 - q), CableWorldRenderer.v(1.0 - p, 1.0 - q, 1.0 - q)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(1.0 - p, q, 1.0 - q), CableWorldRenderer.v(1.0 - p, 1.0 - q, 1.0 - q), CableWorldRenderer.v(1.0 - p, 1.0 - q, q), CableWorldRenderer.v(1.0 - p, q, q)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(1.0, q, 1.0 - q), CableWorldRenderer.v(1.0, q, q), CableWorldRenderer.v(1.0, 1.0 - q, q), CableWorldRenderer.v(1.0, 1.0 - q, 1.0 - q)));
        } else {
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(1.0 - o, o, o), CableWorldRenderer.v(1.0 - o, 1.0 - o, o), CableWorldRenderer.v(1.0 - o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(1.0 - o, o, 1.0 - o)));
        }
        if (west == ConnectorType.CABLE) {
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(o, 1.0 - o, o), CableWorldRenderer.v(0.0, 1.0 - o, o), CableWorldRenderer.v(0.0, 1.0 - o, 1.0 - o)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(o, o, o), CableWorldRenderer.v(o, o, 1.0 - o), CableWorldRenderer.v(0.0, o, 1.0 - o), CableWorldRenderer.v(0.0, o, o)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(o, 1.0 - o, o), CableWorldRenderer.v(o, o, o), CableWorldRenderer.v(0.0, o, o), CableWorldRenderer.v(0.0, 1.0 - o, o)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(o, o, 1.0 - o), CableWorldRenderer.v(o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(0.0, 1.0 - o, 1.0 - o), CableWorldRenderer.v(0.0, o, 1.0 - o)));
        } else if (west == ConnectorType.BLOCK) {
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(o, 1.0 - o, o), CableWorldRenderer.v(p, 1.0 - o, o), CableWorldRenderer.v(p, 1.0 - o, 1.0 - o)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(o, o, o), CableWorldRenderer.v(o, o, 1.0 - o), CableWorldRenderer.v(p, o, 1.0 - o), CableWorldRenderer.v(p, o, o)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(o, 1.0 - o, o), CableWorldRenderer.v(o, o, o), CableWorldRenderer.v(p, o, o), CableWorldRenderer.v(p, 1.0 - o, o)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(o, o, 1.0 - o), CableWorldRenderer.v(o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(p, 1.0 - o, 1.0 - o), CableWorldRenderer.v(p, o, 1.0 - o)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(0.0, 1.0 - q, 1.0 - q), CableWorldRenderer.v(p, 1.0 - q, 1.0 - q), CableWorldRenderer.v(p, 1.0 - q, q), CableWorldRenderer.v(0.0, 1.0 - q, q)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(0.0, q, q), CableWorldRenderer.v(p, q, q), CableWorldRenderer.v(p, q, 1.0 - q), CableWorldRenderer.v(0.0, q, 1.0 - q)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(0.0, 1.0 - q, q), CableWorldRenderer.v(p, 1.0 - q, q), CableWorldRenderer.v(p, q, q), CableWorldRenderer.v(0.0, q, q)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(0.0, q, 1.0 - q), CableWorldRenderer.v(p, q, 1.0 - q), CableWorldRenderer.v(p, 1.0 - q, 1.0 - q), CableWorldRenderer.v(0.0, 1.0 - q, 1.0 - q)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(p, q, q), CableWorldRenderer.v(p, 1.0 - q, q), CableWorldRenderer.v(p, 1.0 - q, 1.0 - q), CableWorldRenderer.v(p, q, 1.0 - q)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(0.0, q, q), CableWorldRenderer.v(0.0, q, 1.0 - q), CableWorldRenderer.v(0.0, 1.0 - q, 1.0 - q), CableWorldRenderer.v(0.0, 1.0 - q, q)));
        } else {
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(o, o, 1.0 - o), CableWorldRenderer.v(o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(o, 1.0 - o, o), CableWorldRenderer.v(o, o, o)));
        }
        if (north == ConnectorType.CABLE) {
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(o, 1.0 - o, o), CableWorldRenderer.v(1.0 - o, 1.0 - o, o), CableWorldRenderer.v(1.0 - o, 1.0 - o, 0.0), CableWorldRenderer.v(o, 1.0 - o, 0.0)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(o, o, 0.0), CableWorldRenderer.v(1.0 - o, o, 0.0), CableWorldRenderer.v(1.0 - o, o, o), CableWorldRenderer.v(o, o, o)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(1.0 - o, o, 0.0), CableWorldRenderer.v(1.0 - o, 1.0 - o, 0.0), CableWorldRenderer.v(1.0 - o, 1.0 - o, o), CableWorldRenderer.v(1.0 - o, o, o)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(o, o, o), CableWorldRenderer.v(o, 1.0 - o, o), CableWorldRenderer.v(o, 1.0 - o, 0.0), CableWorldRenderer.v(o, o, 0.0)));
        } else if (north == ConnectorType.BLOCK) {
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(o, 1.0 - o, o), CableWorldRenderer.v(1.0 - o, 1.0 - o, o), CableWorldRenderer.v(1.0 - o, 1.0 - o, p), CableWorldRenderer.v(o, 1.0 - o, p)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(o, o, p), CableWorldRenderer.v(1.0 - o, o, p), CableWorldRenderer.v(1.0 - o, o, o), CableWorldRenderer.v(o, o, o)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(1.0 - o, o, p), CableWorldRenderer.v(1.0 - o, 1.0 - o, p), CableWorldRenderer.v(1.0 - o, 1.0 - o, o), CableWorldRenderer.v(1.0 - o, o, o)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(o, o, o), CableWorldRenderer.v(o, 1.0 - o, o), CableWorldRenderer.v(o, 1.0 - o, p), CableWorldRenderer.v(o, o, p)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(q, 1.0 - q, p), CableWorldRenderer.v(1.0 - q, 1.0 - q, p), CableWorldRenderer.v(1.0 - q, 1.0 - q, 0.0), CableWorldRenderer.v(q, 1.0 - q, 0.0)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(q, q, 0.0), CableWorldRenderer.v(1.0 - q, q, 0.0), CableWorldRenderer.v(1.0 - q, q, p), CableWorldRenderer.v(q, q, p)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(1.0 - q, q, 0.0), CableWorldRenderer.v(1.0 - q, 1.0 - q, 0.0), CableWorldRenderer.v(1.0 - q, 1.0 - q, p), CableWorldRenderer.v(1.0 - q, q, p)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(q, q, p), CableWorldRenderer.v(q, 1.0 - q, p), CableWorldRenderer.v(q, 1.0 - q, 0.0), CableWorldRenderer.v(q, q, 0.0)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(q, q, p), CableWorldRenderer.v(1.0 - q, q, p), CableWorldRenderer.v(1.0 - q, 1.0 - q, p), CableWorldRenderer.v(q, 1.0 - q, p)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(q, q, 0.0), CableWorldRenderer.v(q, 1.0 - q, 0.0), CableWorldRenderer.v(1.0 - q, 1.0 - q, 0.0), CableWorldRenderer.v(1.0 - q, q, 0.0)));
        } else {
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(o, 1.0 - o, o), CableWorldRenderer.v(1.0 - o, 1.0 - o, o), CableWorldRenderer.v(1.0 - o, o, o), CableWorldRenderer.v(o, o, o)));
        }
        if (south == ConnectorType.CABLE) {
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(o, 1.0 - o, 1.0), CableWorldRenderer.v(1.0 - o, 1.0 - o, 1.0), CableWorldRenderer.v(1.0 - o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(o, 1.0 - o, 1.0 - o)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(o, o, 1.0 - o), CableWorldRenderer.v(1.0 - o, o, 1.0 - o), CableWorldRenderer.v(1.0 - o, o, 1.0), CableWorldRenderer.v(o, o, 1.0)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(1.0 - o, o, 1.0 - o), CableWorldRenderer.v(1.0 - o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(1.0 - o, 1.0 - o, 1.0), CableWorldRenderer.v(1.0 - o, o, 1.0)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(o, o, 1.0), CableWorldRenderer.v(o, 1.0 - o, 1.0), CableWorldRenderer.v(o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(o, o, 1.0 - o)));
        } else if (south == ConnectorType.BLOCK) {
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(o, 1.0 - o, 1.0 - p), CableWorldRenderer.v(1.0 - o, 1.0 - o, 1.0 - p), CableWorldRenderer.v(1.0 - o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(o, 1.0 - o, 1.0 - o)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(o, o, 1.0 - o), CableWorldRenderer.v(1.0 - o, o, 1.0 - o), CableWorldRenderer.v(1.0 - o, o, 1.0 - p), CableWorldRenderer.v(o, o, 1.0 - p)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(1.0 - o, o, 1.0 - o), CableWorldRenderer.v(1.0 - o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(1.0 - o, 1.0 - o, 1.0 - p), CableWorldRenderer.v(1.0 - o, o, 1.0 - p)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(o, o, 1.0 - p), CableWorldRenderer.v(o, 1.0 - o, 1.0 - p), CableWorldRenderer.v(o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(o, o, 1.0 - o)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(q, 1.0 - q, 1.0), CableWorldRenderer.v(1.0 - q, 1.0 - q, 1.0), CableWorldRenderer.v(1.0 - q, 1.0 - q, 1.0 - p), CableWorldRenderer.v(q, 1.0 - q, 1.0 - p)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(q, q, 1.0 - p), CableWorldRenderer.v(1.0 - q, q, 1.0 - p), CableWorldRenderer.v(1.0 - q, q, 1.0), CableWorldRenderer.v(q, q, 1.0)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(1.0 - q, q, 1.0 - p), CableWorldRenderer.v(1.0 - q, 1.0 - q, 1.0 - p), CableWorldRenderer.v(1.0 - q, 1.0 - q, 1.0), CableWorldRenderer.v(1.0 - q, q, 1.0)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(q, q, 1.0), CableWorldRenderer.v(q, 1.0 - q, 1.0), CableWorldRenderer.v(q, 1.0 - q, 1.0 - p), CableWorldRenderer.v(q, q, 1.0 - p)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(q, 1.0 - q, 1.0 - p), CableWorldRenderer.v(1.0 - q, 1.0 - q, 1.0 - p), CableWorldRenderer.v(1.0 - q, q, 1.0 - p), CableWorldRenderer.v(q, q, 1.0 - p)));
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(q, 1.0 - q, 1.0), CableWorldRenderer.v(q, q, 1.0), CableWorldRenderer.v(1.0 - q, q, 1.0), CableWorldRenderer.v(1.0 - q, 1.0 - q, 1.0)));
        } else {
            quads.add(new RenderHelper.Rect(CableWorldRenderer.v(o, o, 1.0 - o), CableWorldRenderer.v(1.0 - o, o, 1.0 - o), CableWorldRenderer.v(1.0 - o, 1.0 - o, 1.0 - o), CableWorldRenderer.v(o, 1.0 - o, 1.0 - o)));
        }
        return quads;
    }
}

