/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.apiimpl.logic;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.gui.ITranslatableEnum;
import mcjty.lib.varia.FluidTools;
import mcjty.rftoolsbase.api.xnet.channels.Color;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.xnet.apiimpl.energy.EnergyChannelSettings;
import mcjty.xnet.apiimpl.fluids.FluidChannelSettings;
import mcjty.xnet.apiimpl.items.ItemChannelSettings;
import mcjty.xnet.apiimpl.logic.LogicConnectorSettings;
import mcjty.xnet.apiimpl.logic.enums.Operator;
import mcjty.xnet.apiimpl.logic.enums.SensorMode;
import mcjty.xnet.compat.RFToolsSupport;
import mcjty.xnet.utils.CastTools;
import mcjty.xnet.utils.I18nConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;

public class RSSensor {
    private final int index;
    private SensorMode sensorMode = SensorMode.OFF;
    private Operator operator = Operator.EQUAL;
    private int amount = 0;
    private Color outputColor = Color.OFF;
    private ItemStack filter = ItemStack.EMPTY;
    public static final Codec<RSSensor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("index").forGetter(s -> s.index), (App)SensorMode.CODEC.fieldOf("sensorMode").forGetter(RSSensor::getSensorMode), (App)Operator.CODEC.fieldOf("operator").forGetter(RSSensor::getOperator), (App)Codec.INT.fieldOf("amount").forGetter(RSSensor::getAmount), (App)Color.CODEC.fieldOf("outputColor").forGetter(RSSensor::getOutputColor), (App)ItemStack.OPTIONAL_CODEC.fieldOf("filter").forGetter(RSSensor::getFilter)).apply((Applicative)instance, RSSensor::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, RSSensor> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, s -> s.index, SensorMode.STREAM_CODEC, RSSensor::getSensorMode, Operator.STREAM_CODEC, RSSensor::getOperator, (StreamCodec)ByteBufCodecs.INT, RSSensor::getAmount, (StreamCodec)Color.STREAM_CODEC, RSSensor::getOutputColor, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, RSSensor::getFilter, RSSensor::new);

    public RSSensor(int index, SensorMode sensorMode, Operator operator, int amount, Color outputColor, ItemStack filter) {
        this.index = index;
        this.sensorMode = sensorMode;
        this.operator = operator;
        this.amount = amount;
        this.outputColor = outputColor;
        this.filter = filter;
    }

    public RSSensor(int index) {
        this.index = index;
    }

    public SensorMode getSensorMode() {
        return this.sensorMode;
    }

    public void setSensorMode(SensorMode sensorMode) {
        this.sensorMode = sensorMode;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public ItemStack getFilter() {
        return this.filter;
    }

    public void setFilter(ItemStack filter) {
        this.filter = filter;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public Color getOutputColor() {
        return this.outputColor;
    }

    public void setOutputColor(Color outputColor) {
        this.outputColor = outputColor;
    }

    public boolean isEnabled(String tag) {
        if (("mode" + this.index).equals(tag)) {
            return true;
        }
        if (("op" + this.index).equals(tag)) {
            return true;
        }
        if (("amount" + this.index).equals(tag)) {
            return true;
        }
        if (("scolor" + this.index).equals(tag)) {
            return true;
        }
        if (("stack" + this.index).equals(tag)) {
            return this.sensorMode == SensorMode.FLUID || this.sensorMode == SensorMode.ITEM;
        }
        return false;
    }

    public void createGui(IEditorGui gui) {
        gui.translatableChoices("mode" + this.index, (ITranslatableEnum)this.sensorMode, (ITranslatableEnum[])SensorMode.values());
        gui.choices("op" + this.index, I18nConstants.LOGIC_SENSOR_OPERATOR_TOOLTIP.i18n(new Object[0]), (Enum)this.operator, (Enum[])Operator.values()).integer("amount" + this.index, I18nConstants.LOGIC_SENSOR_AMOUNT_TOOLTIP.i18n(new Object[0]), Integer.valueOf(this.amount), 46).colors("scolor" + this.index, I18nConstants.LOGIC_SENSOR_OUT_COLOR_TOOLTIP.i18n(new Object[0]), Integer.valueOf(this.outputColor.getColor()), Color.COLORS).ghostSlot("stack" + this.index, this.filter).nl();
    }

    public boolean test(@Nullable BlockEntity te, @Nonnull Level world, @Nonnull BlockPos pos, LogicConnectorSettings settings) {
        switch (this.sensorMode) {
            case ITEM: {
                if (RFToolsSupport.isStorageScanner(te)) {
                    int cnt = RFToolsSupport.countItems(te, this.filter, this.amount + 1);
                    return this.operator.match(cnt, this.amount);
                }
                IItemHandler handler = ItemChannelSettings.getItemHandlerAt(te, settings.getFacing());
                if (handler == null) {
                    return false;
                }
                int cnt = this.countItem(handler, this.filter, this.amount + 1);
                return this.operator.match(cnt, this.amount);
            }
            case FLUID: {
                IFluidHandler fluidHandler = FluidChannelSettings.getFluidHandlerAt(te, settings.getFacing());
                if (fluidHandler == null) {
                    return false;
                }
                int cnt = this.countFluid(fluidHandler, this.filter, this.amount + 1);
                return this.operator.match(cnt, this.amount);
            }
            case ENERGY: {
                if (!EnergyChannelSettings.isEnergyTE(te, settings.getFacing())) break;
                int cnt = EnergyChannelSettings.getEnergyLevel(te, settings.getFacing());
                return this.operator.match(cnt, this.amount);
            }
            case RS: {
                int cnt = world.getSignal(pos, settings.getFacing());
                return this.operator.match(cnt, this.amount);
            }
        }
        return false;
    }

    public void update(Map<String, Object> data) {
        this.sensorMode = CastTools.safeSensorMode(data.get("mode" + this.index));
        this.operator = CastTools.safeOperator(data.get("op" + this.index));
        this.amount = CastTools.safeInt(data.get("amount" + this.index));
        this.outputColor = CastTools.safeColor(data.get("scolor" + this.index));
        this.filter = CastTools.safeItemStack(data.get("stack" + this.index));
    }

    public void readFromNBT(CompoundTag tag) {
    }

    public void writeToNBT(CompoundTag tag) {
    }

    private int countItem(@Nonnull IItemHandler handler, ItemStack matcher, int maxNeeded) {
        int cnt = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.isEmpty() || !(!matcher.isEmpty() ? ItemStack.isSameItem((ItemStack)matcher, (ItemStack)stack) && (cnt += stack.getCount()) >= maxNeeded : (cnt += stack.getCount()) >= maxNeeded)) continue;
            return cnt;
        }
        return cnt;
    }

    private int countFluid(@Nonnull IFluidHandler handler, ItemStack matcher, int maxNeeded) {
        FluidStack fluidStack = !matcher.isEmpty() ? FluidTools.convertBucketToFluid((ItemStack)matcher) : null;
        int cnt = 0;
        for (int i = 0; i < handler.getTanks(); ++i) {
            FluidStack contents = handler.getFluidInTank(i);
            if (contents.isEmpty() || !(fluidStack != null ? FluidStack.isSameFluidSameComponents((FluidStack)fluidStack, (FluidStack)contents) && (cnt += contents.getAmount()) >= maxNeeded : (cnt += contents.getAmount()) >= maxNeeded)) continue;
            return cnt;
        }
        return cnt;
    }
}

