/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.corgilib.entity.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.corgilib.entity.condition.Condition;
import corgitaco.corgilib.entity.condition.ConditionContext;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;

public class PrecipitationAtCondition
implements Condition {
    public static Codec<PrecipitationAtCondition> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BlockPos.CODEC.optionalFieldOf("offset", (Object)BlockPos.ZERO).forGetter(precipitationAtCondition -> precipitationAtCondition.offset), (App)Codec.BOOL.optionalFieldOf("snow", (Object)false).forGetter(precipitationAtCondition -> precipitationAtCondition.snow)).apply((Applicative)builder, PrecipitationAtCondition::new));
    private final BlockPos offset;
    private final boolean snow;

    public PrecipitationAtCondition(BlockPos offset, boolean snow) {
        this.offset = offset;
        this.snow = snow;
    }

    @Override
    public boolean passes(ConditionContext conditionContext) {
        BlockPos offset = conditionContext.entity().blockPosition().offset((Vec3i)this.offset);
        Level world = conditionContext.world();
        if (world.isRainingAt(offset)) {
            if (this.snow) {
                return ((Biome)world.getBiome(offset).value()).shouldSnow((LevelReader)world, offset);
            }
            return true;
        }
        return false;
    }

    @Override
    public Codec<? extends Condition> codec() {
        return CODEC;
    }
}

