/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.allthewizardgear.item;

import io.redspace.allthewizardgear.ServerConfig;
import io.redspace.allthewizardgear.client.armor.GenericArmorModel;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.spells.IPresetSpellContainer;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.registries.ArmorMaterialRegistry;
import io.redspace.ironsspellbooks.registries.ComponentRegistry;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WizardArmorItem
extends ArmorItem
implements GeoItem,
IPresetSpellContainer {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final Supplier<ServerConfig.ArmorSetConfig> config;
    private Cache<ItemAttributeModifiers> defaultModifiers;

    public void reload() {
        this.defaultModifiers.reload();
    }

    public WizardArmorItem(Supplier<ServerConfig.ArmorSetConfig> config, ArmorItem.Type type) {
        this(config, type, Rarity.EPIC);
    }

    public WizardArmorItem(Supplier<ServerConfig.ArmorSetConfig> config, ArmorItem.Type type, Rarity rarity) {
        super((Holder)ArmorMaterialRegistry.SCHOOL, type, new Item.Properties().stacksTo(1).fireResistant().rarity(rarity));
        this.config = config;
        this.defaultModifiers = new Cache<ItemAttributeModifiers>(this, () -> this.makeAttributeMap((ServerConfig.ArmorSetConfig)config.get(), type.getSlot()));
    }

    private ItemAttributeModifiers makeAttributeMap(ServerConfig.ArmorSetConfig config, EquipmentSlot slot) {
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        double defense = config.getDefenseFor(slot);
        double toughness = ((Integer)config.toughness().get()).intValue();
        double knockbackResistance = (Double)config.knockbackResistance().get();
        double maxMana = ((Integer)config.maxMana().get()).intValue();
        double power = (Double)config.spellPower().get();
        double manaRegen = (Double)config.manaRegen().get();
        ResourceLocation resourcelocation = ResourceLocation.fromNamespaceAndPath((String)"allthewizardgear", (String)("armor." + slot.getName()));
        EquipmentSlotGroup equipmentslotgroup = EquipmentSlotGroup.bySlot((EquipmentSlot)slot);
        if (defense != 0.0) {
            builder.add(Attributes.ARMOR, new AttributeModifier(resourcelocation, defense, AttributeModifier.Operation.ADD_VALUE), equipmentslotgroup);
        }
        if (toughness != 0.0) {
            builder.add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(resourcelocation, toughness, AttributeModifier.Operation.ADD_VALUE), equipmentslotgroup);
        }
        if (knockbackResistance != 0.0) {
            builder.add(Attributes.KNOCKBACK_RESISTANCE, new AttributeModifier(resourcelocation, knockbackResistance, AttributeModifier.Operation.ADD_VALUE), equipmentslotgroup);
        }
        if (maxMana != 0.0) {
            builder.add((Holder)AttributeRegistry.MAX_MANA, new AttributeModifier(resourcelocation, maxMana, AttributeModifier.Operation.ADD_VALUE), equipmentslotgroup);
        }
        if (power != 0.0) {
            builder.add((Holder)AttributeRegistry.SPELL_POWER, new AttributeModifier(resourcelocation, power, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), equipmentslotgroup);
        }
        if (manaRegen != 0.0) {
            builder.add((Holder)AttributeRegistry.MANA_REGEN, new AttributeModifier(resourcelocation, manaRegen, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL), equipmentslotgroup);
        }
        return builder.build();
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return (Boolean)this.config.get().makesPiglinsNeutral().get();
    }

    public ServerConfig.ArmorSetConfig getConfig() {
        return this.config.get();
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers() {
        return this.defaultModifiers.get();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 20, this::predicate));
    }

    private PlayState predicate(AnimationState<WizardArmorItem> extendedArmorItemAnimationState) {
        extendedArmorItemAnimationState.getController().setAnimation(RawAnimation.begin().thenLoop("idle"));
        return PlayState.CONTINUE;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(){
            private GeoArmorRenderer<?> renderer;

            public <T extends LivingEntity> HumanoidModel<?> getGeoArmorRenderer(@Nullable T livingEntity, ItemStack itemStack, @Nullable EquipmentSlot equipmentSlot, @Nullable HumanoidModel<T> original) {
                if (this.renderer == null) {
                    this.renderer = new GeoArmorRenderer(new GenericArmorModel(WizardArmorItem.this.config.get().name()));
                }
                return this.renderer;
            }
        });
    }

    public void initializeSpellContainer(ItemStack itemStack) {
        ArmorItem armorItem;
        Item var3;
        if (itemStack != null && (var3 = itemStack.getItem()) instanceof ArmorItem && (armorItem = (ArmorItem)var3).getType() == ArmorItem.Type.CHESTPLATE && !ISpellContainer.isSpellContainer((ItemStack)itemStack)) {
            ISpellContainer spellContainer = ISpellContainer.create((int)1, (boolean)true, (boolean)true);
            itemStack.set((Supplier)ComponentRegistry.SPELL_CONTAINER, (Object)spellContainer);
        }
    }

    class Cache<T> {
        final Supplier<T> supplier;
        T value;

        Cache(WizardArmorItem this$0, Supplier<T> supplier) {
            this.supplier = supplier;
        }

        T get() {
            if (this.value == null) {
                this.value = this.supplier.get();
            }
            return this.value;
        }

        void reload() {
            this.value = null;
        }
    }
}

