/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.util;

import com.direwolf20.buildinggadgets2.api.gadgets.GadgetModes;
import com.direwolf20.buildinggadgets2.api.gadgets.GadgetTarget;
import com.direwolf20.buildinggadgets2.common.items.BaseGadget;
import com.direwolf20.buildinggadgets2.common.items.GadgetBuilding;
import com.direwolf20.buildinggadgets2.common.items.GadgetCopyPaste;
import com.direwolf20.buildinggadgets2.common.items.GadgetCutPaste;
import com.direwolf20.buildinggadgets2.common.items.GadgetExchanger;
import com.direwolf20.buildinggadgets2.common.worlddata.BG2Data;
import com.direwolf20.buildinggadgets2.setup.BG2DataComponents;
import com.direwolf20.buildinggadgets2.util.modes.BaseMode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class GadgetNBT {
    public static final BlockPos nullPos = new BlockPos(-999, -999, -999);
    static final int undoListSize = 10;

    public static void setBoundPos(ItemStack gadget, GlobalPos globalPos) {
        gadget.set(BG2DataComponents.BOUND_GLOBAL_POS, (Object)globalPos);
    }

    public static GlobalPos getBoundPos(ItemStack gadget) {
        return (GlobalPos)gadget.getOrDefault(BG2DataComponents.BOUND_GLOBAL_POS, null);
    }

    public static void clearBoundPos(ItemStack gadget) {
        gadget.remove(BG2DataComponents.BOUND_GLOBAL_POS);
    }

    public static void setAnchorPos(ItemStack gadget, BlockPos blockPos) {
        gadget.set(BG2DataComponents.ANCHOR_POS, (Object)blockPos);
    }

    public static void setRenderType(ItemStack gadget, byte renderType) {
        gadget.set(BG2DataComponents.RENDER_TYPE, (Object)renderType);
    }

    public static byte getRenderTypeByte(ItemStack stack) {
        return ((Number)stack.getOrDefault(BG2DataComponents.RENDER_TYPE, (Object)0)).byteValue();
    }

    public static RenderTypes getRenderType(ItemStack stack) {
        return RenderTypes.getByOrdinal(GadgetNBT.getRenderTypeByte(stack));
    }

    public static BlockPos getAnchorPos(ItemStack gadget) {
        return (BlockPos)gadget.getOrDefault(BG2DataComponents.ANCHOR_POS, (Object)nullPos);
    }

    public static void clearAnchorPos(ItemStack gadget) {
        gadget.remove(BG2DataComponents.ANCHOR_POS);
        gadget.remove(BG2DataComponents.ANCHOR_LIST);
        gadget.remove(BG2DataComponents.ANCHOR_SIDE);
    }

    public static List<BlockPos> getAnchorList(ItemStack gadget) {
        return (List)gadget.getOrDefault(BG2DataComponents.ANCHOR_LIST, new ArrayList());
    }

    public static void setAnchorList(ItemStack gadget, ArrayList<BlockPos> anchorList) {
        gadget.set(BG2DataComponents.ANCHOR_LIST, anchorList);
    }

    public static void setAnchorSide(ItemStack stack, Direction side) {
        if (side == null) {
            stack.remove(BG2DataComponents.ANCHOR_SIDE);
        } else {
            stack.set(BG2DataComponents.ANCHOR_SIDE, (Object)side.ordinal());
        }
    }

    public static Direction getAnchorSide(ItemStack stack) {
        if (!stack.has(BG2DataComponents.ANCHOR_SIDE)) {
            return null;
        }
        return Direction.values()[(Integer)stack.get(BG2DataComponents.ANCHOR_SIDE)];
    }

    public static void setCopyStartPos(ItemStack gadget, BlockPos blockPos) {
        gadget.set(BG2DataComponents.COPY_START_POS, (Object)blockPos);
    }

    public static BlockPos getCopyStartPos(ItemStack gadget) {
        return (BlockPos)gadget.getOrDefault(BG2DataComponents.COPY_START_POS, (Object)nullPos);
    }

    public static void setRelativePaste(ItemStack gadget, BlockPos blockPos) {
        gadget.set(BG2DataComponents.RELATIVE_PASTE, (Object)blockPos);
    }

    public static BlockPos getRelativePaste(ItemStack gadget) {
        return (BlockPos)gadget.getOrDefault(BG2DataComponents.RELATIVE_PASTE, (Object)BlockPos.ZERO);
    }

    public static void setCopyEndPos(ItemStack gadget, BlockPos blockPos) {
        gadget.set(BG2DataComponents.COPY_END_POS, (Object)blockPos);
    }

    public static BlockPos getCopyEndPos(ItemStack gadget) {
        return (BlockPos)gadget.getOrDefault(BG2DataComponents.COPY_END_POS, (Object)nullPos);
    }

    public static UUID setUUID(ItemStack gadget) {
        UUID uuid = UUID.randomUUID();
        gadget.set(BG2DataComponents.GADGET_UUID, (Object)uuid);
        return uuid;
    }

    public static UUID getUUID(ItemStack gadget) {
        if (!gadget.has(BG2DataComponents.GADGET_UUID)) {
            return GadgetNBT.setUUID(gadget);
        }
        return (UUID)gadget.get(BG2DataComponents.GADGET_UUID);
    }

    public static UUID setCopyUUID(ItemStack gadget) {
        UUID uuid = UUID.randomUUID();
        gadget.set(BG2DataComponents.COPY_UUID, (Object)uuid);
        return uuid;
    }

    public static UUID setCopyUUID(ItemStack gadget, UUID uuid) {
        gadget.set(BG2DataComponents.COPY_UUID, (Object)uuid);
        return uuid;
    }

    public static UUID getCopyUUID(ItemStack gadget) {
        if (!gadget.has(BG2DataComponents.COPY_UUID)) {
            return GadgetNBT.setCopyUUID(gadget);
        }
        return (UUID)gadget.get(BG2DataComponents.COPY_UUID);
    }

    public static boolean hasCopyUUID(ItemStack gadget) {
        return gadget.has(BG2DataComponents.COPY_UUID);
    }

    public static void clearCopyUUID(ItemStack gadget) {
        gadget.remove(BG2DataComponents.COPY_UUID);
    }

    public static void setGadgetBlockState(ItemStack gadget, BlockState blockState) {
        gadget.set(BG2DataComponents.GADGET_BLOCKSTATE, (Object)blockState);
    }

    public static BlockState getGadgetBlockState(ItemStack gadget) {
        return (BlockState)gadget.getOrDefault(BG2DataComponents.GADGET_BLOCKSTATE, (Object)Blocks.AIR.defaultBlockState());
    }

    public static boolean shouldRayTraceFluid(ItemStack stack) {
        return GadgetNBT.getSetting(stack, ToggleableSettings.RAYTRACE_FLUID.getName());
    }

    public static LinkedList<UUID> getUndoList(ItemStack gadget) {
        return new LinkedList<UUID>((Collection)gadget.getOrDefault(BG2DataComponents.UNDO_LIST, new ArrayList()));
    }

    public static void setUndoList(ItemStack gadget, LinkedList<UUID> undoList) {
        gadget.set(BG2DataComponents.UNDO_LIST, undoList);
    }

    public static void addToUndoList(ItemStack gadget, UUID uuid, BG2Data bg2Data) {
        LinkedList<UUID> undoList = GadgetNBT.getUndoList(gadget);
        if (undoList.size() >= 10) {
            UUID removal = undoList.removeFirst();
            bg2Data.removeFromUndoList(removal);
        }
        undoList.add(uuid);
        GadgetNBT.setUndoList(gadget, undoList);
    }

    public static UUID peekUndoList(ItemStack gadget) {
        LinkedList<UUID> undoList = GadgetNBT.getUndoList(gadget);
        if (undoList.isEmpty()) {
            return null;
        }
        return undoList.getLast();
    }

    public static UUID popUndoList(ItemStack gadget) {
        LinkedList<UUID> undoList = GadgetNBT.getUndoList(gadget);
        if (undoList.isEmpty()) {
            return null;
        }
        UUID uuid = undoList.removeLast();
        GadgetNBT.setUndoList(gadget, undoList);
        return uuid;
    }

    public static boolean toggleSetting(ItemStack stack, String setting) {
        ToggleableSettings toggleableSetting = ToggleableSettings.byName(setting);
        stack.update((Supplier)BG2DataComponents.SETTING_TOGGLES.get((Object)toggleableSetting), (Object)false, k -> k == false);
        return (Boolean)stack.getOrDefault((Supplier)BG2DataComponents.SETTING_TOGGLES.get((Object)toggleableSetting), (Object)false);
    }

    public static boolean getSetting(ItemStack stack, String setting) {
        ToggleableSettings toggleableSetting = ToggleableSettings.byName(setting);
        return (Boolean)stack.getOrDefault((Supplier)BG2DataComponents.SETTING_TOGGLES.get((Object)toggleableSetting), (Object)false);
    }

    public static boolean getPasteReplace(ItemStack stack) {
        if (!stack.has((Supplier)BG2DataComponents.SETTING_TOGGLES.get((Object)ToggleableSettings.PASTE_REPLACE))) {
            if (stack.getItem() instanceof GadgetCutPaste) {
                return GadgetNBT.toggleSetting(stack, ToggleableSettings.PASTE_REPLACE.getName());
            }
            return false;
        }
        return GadgetNBT.getSetting(stack, ToggleableSettings.PASTE_REPLACE.getName());
    }

    public static void setToolRange(ItemStack stack, int range) {
        stack.set(BG2DataComponents.GADGET_RANGE, (Object)range);
    }

    public static int getToolRange(ItemStack stack) {
        return (Integer)stack.getOrDefault(BG2DataComponents.GADGET_RANGE, (Object)1);
    }

    public static void setToolValue(ItemStack stack, int value, String valueName) {
        stack.set((Supplier)BG2DataComponents.SETTING_VALUES.get((Object)IntSettings.byName(valueName)), (Object)value);
    }

    public static int getToolValue(ItemStack stack, String valueName) {
        return (Integer)stack.getOrDefault((Supplier)BG2DataComponents.SETTING_VALUES.get((Object)IntSettings.byName(valueName)), (Object)0);
    }

    public static void setTemplateName(ItemStack stack, String name) {
        stack.set(BG2DataComponents.TEMPLATE_NAME, (Object)name);
    }

    public static String getTemplateName(ItemStack stack) {
        return (String)stack.getOrDefault(BG2DataComponents.TEMPLATE_NAME, (Object)"");
    }

    public static boolean getFuzzy(ItemStack stack) {
        return GadgetNBT.getSetting(stack, ToggleableSettings.FUZZY.getName());
    }

    public static BaseMode getMode(ItemStack stack) {
        Preconditions.checkArgument((boolean)(stack.getItem() instanceof BaseGadget), (Object)"You can not get a mode of a non-gadget item");
        String mode = (String)stack.getOrDefault(BG2DataComponents.GADGET_MODE, (Object)"");
        GadgetTarget gadgetTarget = ((BaseGadget)stack.getItem()).gadgetTarget();
        ImmutableSortedSet<BaseMode> modesForGadget = GadgetModes.INSTANCE.getModesForGadget(gadgetTarget);
        if (mode.isEmpty()) {
            if (stack.getItem() instanceof GadgetBuilding) {
                return modesForGadget.stream().filter(m -> m.getId().getPath().equals("build_to_me")).findFirst().orElse((BaseMode)modesForGadget.first());
            }
            if (stack.getItem() instanceof GadgetExchanger) {
                return modesForGadget.stream().filter(m -> m.getId().getPath().equals("surface")).findFirst().orElse((BaseMode)modesForGadget.first());
            }
            if (stack.getItem() instanceof GadgetCutPaste) {
                return modesForGadget.stream().filter(m -> m.getId().getPath().equals("cut")).findFirst().orElse((BaseMode)modesForGadget.first());
            }
            if (stack.getItem() instanceof GadgetCopyPaste) {
                return modesForGadget.stream().filter(m -> m.getId().getPath().equals("copy")).findFirst().orElse((BaseMode)modesForGadget.first());
            }
            return (BaseMode)modesForGadget.first();
        }
        ResourceLocation id = ResourceLocation.parse((String)mode);
        return modesForGadget.stream().filter(m -> m.getId().equals((Object)id)).findFirst().orElse((BaseMode)modesForGadget.first());
    }

    public static void setMode(ItemStack gadget, BaseMode mode) {
        gadget.set(BG2DataComponents.GADGET_MODE, (Object)mode.getId().toString());
    }

    public static enum RenderTypes {
        GROW("buildinggadgets2.grow"),
        FADE("buildinggadgets2.fade"),
        SQUISH("buildinggadgets2.squish"),
        GROWUP("buildinggadgets2.growup"),
        RISEUP("buildinggadgets2.riseup"),
        SNAP("buildinggadgets2.snap");

        private final String lang;

        private RenderTypes(String lang) {
            this.lang = lang;
        }

        public RenderTypes next() {
            return RenderTypes.values()[(this.ordinal() + 1) % RenderTypes.values().length];
        }

        public byte getPosition() {
            return (byte)this.ordinal();
        }

        public String getLang() {
            return this.lang;
        }

        public static RenderTypes getByOrdinal(byte ordinal) {
            return RenderTypes.values()[ordinal];
        }
    }

    public static enum ToggleableSettings {
        AFFECT_TILES,
        RAYTRACE_FLUID,
        PLACE_ON_TOP,
        PASTE_REPLACE,
        BIND,
        FUZZY,
        CONNECTED_AREA;


        public static ToggleableSettings byName(String name) {
            return ToggleableSettings.valueOf(name.toUpperCase(Locale.ROOT));
        }

        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static enum IntSettings {
        BIND_DIRECTION,
        LEFT,
        RIGHT,
        UP,
        DOWN,
        DEPTH;


        public static IntSettings byName(String name) {
            return IntSettings.valueOf(name.toUpperCase(Locale.ROOT));
        }

        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

