/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.common.items;

import com.direwolf20.buildinggadgets2.client.screen.ScreenOpener;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class TemplateItem
extends Item {
    public TemplateItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null || mc.player == null) {
            return;
        }
        String templateName = GadgetNBT.getTemplateName(stack);
        if (!templateName.isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"buildinggadgets2.templatename", (Object[])new Object[]{templateName}).withStyle(ChatFormatting.AQUA));
        }
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (!playerIn.isShiftKeyDown()) {
            return super.use(worldIn, playerIn, handIn);
        }
        if (worldIn.isClientSide) {
            ScreenOpener.openMaterialList(playerIn.getItemInHand(handIn));
        }
        return super.use(worldIn, playerIn, handIn);
    }
}

