/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.common.containers;

import com.direwolf20.buildinggadgets2.common.blockentities.TemplateManagerBE;
import com.direwolf20.buildinggadgets2.common.containers.BaseContainer;
import com.direwolf20.buildinggadgets2.setup.Registration;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class TemplateManagerContainer
extends BaseContainer {
    public static final String TEXTURE_LOC_SLOT_TOOL = "buildinggadgets2:textures/gui/slot_copy_paste_gadget.png";
    public static final String TEXTURE_LOC_SLOT_TEMPLATE = "buildinggadgets2:gui/slot_template";
    public static final int SLOTS = 2;
    private TemplateManagerBE be;

    public TemplateManagerContainer(int windowId, Inventory playerInventory, FriendlyByteBuf extraData) {
        super((MenuType)Registration.TemplateManager_Container.get(), windowId);
        BlockPos pos = extraData.readBlockPos();
        this.be = (TemplateManagerBE)playerInventory.player.level().getBlockEntity(pos);
        this.addOwnSlots();
        this.addPlayerSlots(playerInventory, -12, 70);
    }

    public TemplateManagerContainer(int windowId, Inventory playerInventory, TemplateManagerBE tileEntity) {
        super((MenuType)Registration.TemplateManager_Container.get(), windowId);
        this.be = Objects.requireNonNull(tileEntity);
        this.addOwnSlots();
        this.addPlayerSlots(playerInventory, -12, 70);
    }

    public boolean stillValid(Player playerIn) {
        return TemplateManagerContainer.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.be.getLevel(), (BlockPos)this.be.getBlockPos()), (Player)playerIn, (Block)((Block)Registration.TemplateManager.get()));
    }

    private void addOwnSlots() {
        IItemHandler cap = (IItemHandler)this.be.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, this.be.getBlockPos(), this.be.getBlockState(), (BlockEntity)this.be, null);
        if (cap != null) {
            int x = 132;
            this.addSlot((Slot)new SlotTemplateManager(cap, 0, x, 18, TEXTURE_LOC_SLOT_TOOL));
            this.addSlot((Slot)new SlotTemplateManager(cap, 1, x, 63, TEXTURE_LOC_SLOT_TEMPLATE));
        }
    }

    @Nonnull
    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack currentStack = slot.getItem();
            itemstack = currentStack.copy();
            if (index < 2 ? !this.moveItemStackTo(currentStack, 2, this.slots.size(), true) : !this.moveItemStackTo(currentStack, 0, 2, false)) {
                return ItemStack.EMPTY;
            }
            if (currentStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public TemplateManagerBE getTe() {
        return this.be;
    }

    public static class SlotTemplateManager
    extends SlotItemHandler {
        private String backgroundLoc;

        public SlotTemplateManager(IItemHandler itemHandler, int index, int xPosition, int yPosition, String backgroundLoc) {
            super(itemHandler, index, xPosition, yPosition);
            this.backgroundLoc = backgroundLoc;
        }

        public int getMaxStackSize() {
            return 1;
        }
    }
}

