/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.client.events;

import com.direwolf20.buildinggadgets2.client.renderer.DestructionRenderer;
import com.direwolf20.buildinggadgets2.client.renderer.MyRenderMethods;
import com.direwolf20.buildinggadgets2.client.renderer.OurRenderTypes;
import com.direwolf20.buildinggadgets2.client.renderer.VBORenderer;
import com.direwolf20.buildinggadgets2.common.items.BaseGadget;
import com.direwolf20.buildinggadgets2.common.items.GadgetDestruction;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;

public class RenderLevelLast {
    @SubscribeEvent
    static void renderWorldLastEvent(RenderLevelStageEvent evt) {
        if (evt.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ItemStack heldItem = BaseGadget.getGadget((Player)player);
        if (heldItem.isEmpty()) {
            return;
        }
        if (heldItem.getItem() instanceof GadgetDestruction) {
            DestructionRenderer.render(evt, (Player)player, heldItem);
            BlockPos anchorPos = GadgetNBT.getAnchorPos(heldItem);
            if (anchorPos != null && !anchorPos.equals((Object)GadgetNBT.nullPos)) {
                RenderLevelLast.renderSelectedBlock(evt, anchorPos);
            }
        } else {
            VBORenderer.buildRender(evt, (Player)player, heldItem);
            VBORenderer.drawRender(evt, (Player)player, heldItem);
            BlockPos anchorPos = GadgetNBT.getAnchorPos(heldItem);
            if (anchorPos != null && !anchorPos.equals((Object)GadgetNBT.nullPos)) {
                RenderLevelLast.renderSelectedBlock(evt, anchorPos);
            }
        }
    }

    public static void renderSelectedBlock(RenderLevelStageEvent event, BlockPos pos) {
        Minecraft mc = Minecraft.getInstance();
        MultiBufferSource.BufferSource buffer = Minecraft.getInstance().renderBuffers().bufferSource();
        Vec3 view = mc.gameRenderer.getMainCamera().getPosition();
        PoseStack matrix = event.getPoseStack();
        matrix.pushPose();
        matrix.translate(-view.x(), -view.y(), -view.z());
        matrix.pushPose();
        matrix.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
        matrix.translate(-0.005f, -0.005f, -0.005f);
        matrix.scale(1.01f, 1.01f, 1.01f);
        Matrix4f positionMatrix = matrix.last().pose();
        MyRenderMethods.renderBoxSolid(matrix, positionMatrix, (MultiBufferSource)buffer, BlockPos.ZERO, 0.0f, 1.0f, 0.0f, 0.25f);
        MyRenderMethods.renderLines(matrix, BlockPos.ZERO, BlockPos.ZERO, Color.WHITE, (MultiBufferSource)buffer);
        matrix.popPose();
        matrix.popPose();
        buffer.endBatch(OurRenderTypes.TRANSPARENT_BOX);
    }
}

