/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.client.blockentityrenders;

import com.direwolf20.buildinggadgets2.client.renderer.DireVertexConsumer;
import com.direwolf20.buildinggadgets2.client.renderer.DireVertexConsumerSquished;
import com.direwolf20.buildinggadgets2.client.renderer.MyRenderMethods;
import com.direwolf20.buildinggadgets2.client.renderer.OurRenderTypes;
import com.direwolf20.buildinggadgets2.client.renderer.RenderFluidBlock;
import com.direwolf20.buildinggadgets2.common.blockentities.RenderBlockBE;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.BitSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;

public class RenderBlockBER
implements BlockEntityRenderer<RenderBlockBE> {
    public RenderBlockBER(BlockEntityRendererProvider.Context p_173636_) {
    }

    public void render(RenderBlockBE blockentity, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightsIn, int combinedOverlayIn) {
        BlockState renderState;
        float nextScale;
        Level level = blockentity.getLevel();
        BlockPos pos = blockentity.getBlockPos();
        byte drawSize = blockentity.drawSize;
        float nowScale = (float)drawSize / (float)blockentity.getMaxSize();
        float scale = Mth.lerp((float)partialTicks, (float)nowScale, (float)(nextScale = (float)blockentity.nextDrawSize() / (float)blockentity.getMaxSize()));
        if (scale >= 1.0f) {
            scale = 1.0f;
        }
        if (scale <= 0.0f) {
            scale = 0.0f;
        }
        if ((renderState = blockentity.renderBlock) == null) {
            return;
        }
        BlockRenderDispatcher blockrendererdispatcher = Minecraft.getInstance().getBlockRenderer();
        BakedModel ibakedmodel = blockrendererdispatcher.getBlockModel(renderState);
        boolean isNormalRender = false;
        for (Direction direction : Direction.values()) {
            if (!ibakedmodel.getQuads(renderState, direction, RandomSource.create(), ModelData.EMPTY, null).isEmpty()) {
                isNormalRender = true;
                break;
            }
            if (ibakedmodel.getQuads(renderState, null, RandomSource.create(), ModelData.EMPTY, null).isEmpty()) continue;
            isNormalRender = true;
        }
        BlockColors blockColors = Minecraft.getInstance().getBlockColors();
        ModelBlockRenderer modelBlockRenderer = new ModelBlockRenderer(blockColors);
        if (blockentity.renderType == 0) {
            this.renderGrow(level, pos, matrixStackIn, bufferIn, combinedLightsIn, combinedOverlayIn, scale, renderState, ibakedmodel, blockrendererdispatcher, modelBlockRenderer, isNormalRender);
        } else if (blockentity.renderType == 1) {
            this.renderFade(level, pos, matrixStackIn, bufferIn, combinedLightsIn, combinedOverlayIn, scale, renderState, ibakedmodel, modelBlockRenderer, isNormalRender, blockentity);
        } else if (blockentity.renderType == 2 || blockentity.renderType == 3 || blockentity.renderType == 4) {
            boolean adjustUV = blockentity.renderType != 2;
            boolean bottomUp = blockentity.renderType == 4;
            this.renderSquished(level, pos, matrixStackIn, bufferIn, combinedLightsIn, combinedOverlayIn, scale, renderState, ibakedmodel, blockrendererdispatcher, modelBlockRenderer, isNormalRender, adjustUV, bottomUp);
        } else if (blockentity.renderType == 5) {
            this.renderSquishedSnap(level, pos, matrixStackIn, bufferIn, combinedLightsIn, combinedOverlayIn, scale, renderState, ibakedmodel, modelBlockRenderer, isNormalRender, blockentity);
        } else {
            this.renderGrow(level, pos, matrixStackIn, bufferIn, combinedLightsIn, combinedOverlayIn, scale, renderState, ibakedmodel, blockrendererdispatcher, modelBlockRenderer, isNormalRender);
        }
    }

    public void renderGrow(Level level, BlockPos pos, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightsIn, int combinedOverlayIn, float scale, BlockState renderState, BakedModel ibakedmodel, BlockRenderDispatcher blockrendererdispatcher, ModelBlockRenderer modelBlockRenderer, boolean isNormalRender) {
        matrixStackIn.pushPose();
        VertexConsumer builder = bufferIn.getBuffer(RenderType.cutout());
        matrixStackIn.translate((1.0f - scale) / 2.0f, (1.0f - scale) / 2.0f, (1.0f - scale) / 2.0f);
        matrixStackIn.scale(scale, scale, scale);
        if (renderState.getFluidState().isEmpty()) {
            if (isNormalRender) {
                modelBlockRenderer.tesselateBlock((BlockAndTintGetter)level, ibakedmodel, renderState, pos, matrixStackIn, builder, false, RandomSource.create(), renderState.getSeed(pos), combinedOverlayIn, ModelData.EMPTY, null);
            } else {
                blockrendererdispatcher.renderSingleBlock(renderState, matrixStackIn, bufferIn, combinedLightsIn, combinedOverlayIn, ModelData.EMPTY, null);
            }
        } else {
            RenderFluidBlock.renderFluidBlock(renderState, level, pos, matrixStackIn, builder, true);
        }
        matrixStackIn.popPose();
    }

    public void renderSquished(Level level, BlockPos pos, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightsIn, int combinedOverlayIn, float scale, BlockState renderState, BakedModel ibakedmodel, BlockRenderDispatcher blockrendererdispatcher, ModelBlockRenderer modelBlockRenderer, boolean isNormalRender, boolean adjustUV, boolean bottomUp) {
        matrixStackIn.pushPose();
        VertexConsumer builder = renderState.isSolidRender((BlockGetter)level, pos) ? bufferIn.getBuffer(OurRenderTypes.RenderBlockBackface) : bufferIn.getBuffer(OurRenderTypes.RenderBlockFadeNoCull);
        scale = Mth.lerp((float)scale, (float)0.0f, (float)1.0f);
        DireVertexConsumerSquished chunksConsumer = new DireVertexConsumerSquished(builder, 0.0f, 0.0f, 0.0f, 1.0f, scale, 1.0f, matrixStackIn.last().pose());
        chunksConsumer.adjustUV = adjustUV;
        chunksConsumer.bottomUp = bottomUp;
        if (!renderState.isSolidRender((BlockGetter)level, pos)) {
            chunksConsumer.adjustUV = false;
        }
        float[] afloat = new float[Direction.values().length * 2];
        BitSet bitset = new BitSet(3);
        RandomSource randomSource = RandomSource.create();
        randomSource.setSeed(renderState.getSeed(pos));
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.mutable();
        if (!renderState.getFluidState().isEmpty()) {
            RenderFluidBlock.renderFluidBlock(renderState, level, pos, matrixStackIn, (VertexConsumer)chunksConsumer, true);
        } else if (isNormalRender) {
            ModelBlockRenderer.AmbientOcclusionFace modelblockrenderer$ambientocclusionface = new ModelBlockRenderer.AmbientOcclusionFace();
            for (Direction direction : Direction.values()) {
                List list = ibakedmodel.getQuads(renderState, direction, randomSource, ModelData.EMPTY, null);
                if (list.isEmpty()) continue;
                TextureAtlasSprite sprite = ((BakedQuad)list.get(0)).getSprite();
                chunksConsumer.setSprite(sprite);
                chunksConsumer.setDirection(direction);
                blockpos$mutableblockpos.setWithOffset((Vec3i)pos, direction);
                modelBlockRenderer.renderModelFaceAO((BlockAndTintGetter)level, renderState, pos, matrixStackIn, (VertexConsumer)chunksConsumer, list, afloat, bitset, modelblockrenderer$ambientocclusionface, combinedOverlayIn);
            }
            List list = ibakedmodel.getQuads(renderState, null, randomSource, ModelData.EMPTY, null);
            if (!list.isEmpty()) {
                TextureAtlasSprite sprite = ((BakedQuad)list.get(0)).getSprite();
                chunksConsumer.setSprite(sprite);
                chunksConsumer.setDirection(null);
                modelBlockRenderer.renderModelFaceAO((BlockAndTintGetter)level, renderState, pos, matrixStackIn, (VertexConsumer)chunksConsumer, list, afloat, bitset, modelblockrenderer$ambientocclusionface, combinedOverlayIn);
            }
        } else {
            MyRenderMethods.renderBESquished(renderState, matrixStackIn, bufferIn, combinedLightsIn, combinedOverlayIn, scale);
        }
        matrixStackIn.popPose();
    }

    public void renderFade(Level level, BlockPos pos, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightsIn, int combinedOverlayIn, float scale, BlockState renderState, BakedModel ibakedmodel, ModelBlockRenderer modelBlockRenderer, boolean isNormalRender, RenderBlockBE thisBlockEntity) {
        VertexConsumer builder = renderState.isSolidRender((BlockGetter)level, pos) ? bufferIn.getBuffer(OurRenderTypes.RenderBlockFade) : bufferIn.getBuffer(OurRenderTypes.RenderBlockFadeNoCull);
        scale = Mth.lerp((float)scale, (float)0.25f, (float)1.0f);
        DireVertexConsumer direVertexConsumer = new DireVertexConsumer(builder, scale);
        float[] afloat = new float[Direction.values().length * 2];
        BitSet bitset = new BitSet(3);
        RandomSource randomSource = RandomSource.create();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.mutable();
        if (!renderState.getFluidState().isEmpty()) {
            RenderFluidBlock.renderFluidBlock(renderState, level, pos, matrixStackIn, (VertexConsumer)direVertexConsumer, false);
        } else if (isNormalRender) {
            ModelBlockRenderer.AmbientOcclusionFace modelblockrenderer$ambientocclusionface = new ModelBlockRenderer.AmbientOcclusionFace();
            for (Direction direction : Direction.values()) {
                randomSource.setSeed(renderState.getSeed(pos));
                List list = ibakedmodel.getQuads(renderState, direction, randomSource, ModelData.EMPTY, null);
                if (list.isEmpty()) continue;
                blockpos$mutableblockpos.setWithOffset((Vec3i)pos, direction);
                BlockEntity blockEntity = level.getBlockEntity(pos.relative(direction));
                boolean renderAdjacent = true;
                if (blockEntity instanceof RenderBlockBE) {
                    RenderBlockBE renderBlockBE = (RenderBlockBE)blockEntity;
                    if (renderBlockBE.renderBlock != null && renderBlockBE.renderBlock.isSolidRender((BlockGetter)level, pos) && Math.abs(thisBlockEntity.drawSize - renderBlockBE.drawSize) < 5 && thisBlockEntity.drawSize < renderBlockBE.drawSize) {
                        renderAdjacent = false;
                    }
                }
                if (!renderAdjacent) continue;
                modelBlockRenderer.renderModelFaceAO((BlockAndTintGetter)level, renderState, pos, matrixStackIn, (VertexConsumer)direVertexConsumer, list, afloat, bitset, modelblockrenderer$ambientocclusionface, combinedOverlayIn);
            }
            randomSource.setSeed(renderState.getSeed(pos));
            List list = ibakedmodel.getQuads(renderState, null, randomSource, ModelData.EMPTY, null);
            if (!list.isEmpty()) {
                modelBlockRenderer.renderModelFaceAO((BlockAndTintGetter)level, renderState, pos, matrixStackIn, (VertexConsumer)direVertexConsumer, list, afloat, bitset, modelblockrenderer$ambientocclusionface, combinedOverlayIn);
            }
        } else {
            MyRenderMethods.renderBETransparent(renderState, matrixStackIn, bufferIn, combinedLightsIn, combinedOverlayIn, scale);
        }
    }

    public void renderSquishedSnap(Level level, BlockPos pos, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightsIn, int combinedOverlayIn, float scale, BlockState renderState, BakedModel ibakedmodel, ModelBlockRenderer modelBlockRenderer, boolean isNormalRender, RenderBlockBE thisRenderBlockBE) {
        if (!thisRenderBlockBE.shrinking && scale < 0.1f) {
            return;
        }
        matrixStackIn.pushPose();
        VertexConsumer builder = bufferIn.getBuffer(RenderType.cutout());
        float darkness = Mth.lerp((float)scale, (float)0.25f, (float)1.0f);
        scale = Mth.lerp((float)scale, (float)0.75f, (float)1.0f);
        DireVertexConsumerSquished chunksConsumer = new DireVertexConsumerSquished(builder, 0.0f, 0.0f, 0.0f, 1.0f, scale, 1.0f, matrixStackIn.last().pose(), darkness, darkness, darkness);
        chunksConsumer.adjustUV = true;
        chunksConsumer.bottomUp = false;
        if (!renderState.isSolidRender((BlockGetter)level, pos)) {
            chunksConsumer.adjustUV = false;
        }
        float[] afloat = new float[Direction.values().length * 2];
        BitSet bitset = new BitSet(3);
        RandomSource randomSource = RandomSource.create();
        randomSource.setSeed(renderState.getSeed(pos));
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.mutable();
        if (!renderState.getFluidState().isEmpty()) {
            RenderFluidBlock.renderFluidBlock(renderState, level, pos, matrixStackIn, (VertexConsumer)chunksConsumer, true);
        } else if (isNormalRender) {
            ModelBlockRenderer.AmbientOcclusionFace modelblockrenderer$ambientocclusionface = new ModelBlockRenderer.AmbientOcclusionFace();
            for (Direction direction : Direction.values()) {
                List list = ibakedmodel.getQuads(renderState, direction, randomSource, ModelData.EMPTY, null);
                if (list.isEmpty()) continue;
                TextureAtlasSprite sprite = ((BakedQuad)list.get(0)).getSprite();
                chunksConsumer.setSprite(sprite);
                chunksConsumer.setDirection(direction);
                blockpos$mutableblockpos.setWithOffset((Vec3i)pos, direction);
                modelBlockRenderer.renderModelFaceAO((BlockAndTintGetter)level, renderState, pos, matrixStackIn, (VertexConsumer)chunksConsumer, list, afloat, bitset, modelblockrenderer$ambientocclusionface, combinedOverlayIn);
            }
            List list = ibakedmodel.getQuads(renderState, null, randomSource, ModelData.EMPTY, null);
            if (!list.isEmpty()) {
                TextureAtlasSprite sprite = ((BakedQuad)list.get(0)).getSprite();
                chunksConsumer.setSprite(sprite);
                chunksConsumer.setDirection(null);
                modelBlockRenderer.renderModelFaceAO((BlockAndTintGetter)level, renderState, pos, matrixStackIn, (VertexConsumer)chunksConsumer, list, afloat, bitset, modelblockrenderer$ambientocclusionface, combinedOverlayIn);
            }
        } else {
            MyRenderMethods.renderBESquished(renderState, matrixStackIn, bufferIn, combinedLightsIn, combinedOverlayIn, scale);
        }
        matrixStackIn.popPose();
    }

    public void renderSnapFade(Level level, BlockPos pos, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightsIn, int combinedOverlayIn, float scale, BlockState renderState, BakedModel ibakedmodel, ModelBlockRenderer modelBlockRenderer, boolean isNormalRender, RenderBlockBE thisBlockEntity) {
        VertexConsumer builder = renderState.isSolidRender((BlockGetter)level, pos) ? bufferIn.getBuffer(OurRenderTypes.RenderBlockFade) : bufferIn.getBuffer(OurRenderTypes.RenderBlockFadeNoCull);
        float rgbScale = Mth.lerp((float)((float)Math.pow(scale, 2.0)), (float)0.05f, (float)1.0f);
        float alphaScale = 1.0f;
        if (scale < 0.5f) {
            alphaScale = Mth.lerp((float)((float)Math.pow(scale / 0.5f, 0.25)), (float)0.25f, (float)1.0f);
        }
        DireVertexConsumer direVertexConsumer = new DireVertexConsumer(builder, alphaScale, rgbScale, rgbScale, rgbScale);
        float[] afloat = new float[Direction.values().length * 2];
        BitSet bitset = new BitSet(3);
        RandomSource randomSource = RandomSource.create();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pos.mutable();
        if (!renderState.getFluidState().isEmpty()) {
            RenderFluidBlock.renderFluidBlock(renderState, level, pos, matrixStackIn, (VertexConsumer)direVertexConsumer, false);
        } else if (isNormalRender) {
            ModelBlockRenderer.AmbientOcclusionFace modelblockrenderer$ambientocclusionface = new ModelBlockRenderer.AmbientOcclusionFace();
            for (Direction direction : Direction.values()) {
                randomSource.setSeed(renderState.getSeed(pos));
                List list = ibakedmodel.getQuads(renderState, direction, randomSource, ModelData.EMPTY, null);
                if (list.isEmpty()) continue;
                blockpos$mutableblockpos.setWithOffset((Vec3i)pos, direction);
                BlockEntity blockEntity = level.getBlockEntity(pos.relative(direction));
                boolean renderAdjacent = true;
                if (blockEntity instanceof RenderBlockBE) {
                    RenderBlockBE renderBlockBE = (RenderBlockBE)blockEntity;
                    if (renderBlockBE.renderBlock != null && renderBlockBE.renderBlock.isSolidRender((BlockGetter)level, pos) && Math.abs(thisBlockEntity.drawSize - renderBlockBE.drawSize) < 5 && thisBlockEntity.drawSize <= renderBlockBE.drawSize) {
                        renderAdjacent = false;
                    }
                }
                if (!renderAdjacent) continue;
                modelBlockRenderer.renderModelFaceAO((BlockAndTintGetter)level, renderState, pos, matrixStackIn, (VertexConsumer)direVertexConsumer, list, afloat, bitset, modelblockrenderer$ambientocclusionface, combinedOverlayIn);
            }
            randomSource.setSeed(renderState.getSeed(pos));
            List list = ibakedmodel.getQuads(renderState, null, randomSource, ModelData.EMPTY, null);
            if (!list.isEmpty()) {
                modelBlockRenderer.renderModelFaceAO((BlockAndTintGetter)level, renderState, pos, matrixStackIn, (VertexConsumer)direVertexConsumer, list, afloat, bitset, modelblockrenderer$ambientocclusionface, combinedOverlayIn);
            }
        } else {
            MyRenderMethods.renderBETransparent(renderState, matrixStackIn, bufferIn, combinedLightsIn, combinedOverlayIn, scale);
        }
    }
}

