/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.unification.loot;

import com.almostreliable.unified.AlmostUnifiedCommon;
import com.almostreliable.unified.api.AlmostUnifiedRuntime;
import com.almostreliable.unified.api.unification.UnificationSettings;
import com.almostreliable.unified.unification.loot.LootUnificationHandler;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootTable;

public final class LootUnification {
    private LootUnification() {
    }

    public static void unifyLoot(AlmostUnifiedRuntime runtime, HolderLookup.Provider registries) {
        try {
            Collection<? extends UnificationSettings> handlers = runtime.getUnificationSettings();
            boolean enableLootUnification = handlers.stream().anyMatch(UnificationSettings::shouldUnifyLoot);
            if (!enableLootUnification) {
                return;
            }
            HolderLookup.RegistryLookup lootTableRegistry = registries.lookupOrThrow(Registries.LOOT_TABLE);
            lootTableRegistry.listElements().forEach(holder -> LootUnification.unifyLoot((LootTable)holder.value(), holder.key().location(), handlers));
        }
        catch (Exception e) {
            AlmostUnifiedCommon.LOGGER.error("Failed to unify loot", (Throwable)e);
        }
    }

    public static void unifyLoot(LootTable lootTable, ResourceLocation tableId, Collection<? extends UnificationSettings> unificationSettings) {
        LootUnificationHandler lootUnificationHandler = LootUnificationHandler.cast(lootTable);
        HashSet<UnificationSettings> modifiedTable = new HashSet<UnificationSettings>();
        for (UnificationSettings unificationSettings2 : unificationSettings) {
            if (!unificationSettings2.shouldUnifyLoot() || !unificationSettings2.shouldIncludeLootTable(tableId) || !lootUnificationHandler.almostunified$unify(unificationSettings2)) continue;
            modifiedTable.add(unificationSettings2);
        }
        if (!modifiedTable.isEmpty()) {
            AlmostUnifiedCommon.LOGGER.info("Loot table '{}' was unified by: {}", (Object)tableId, (Object)modifiedTable.stream().map(UnificationSettings::getName).collect(Collectors.joining(", ")));
        }
    }
}

