/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.utils;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SaveHandler
extends SavedData {
    @NotNull
    public CompoundTag save(@NotNull CompoundTag tag, HolderLookup.Provider provider) {
        this.saveData(tag);
        return tag;
    }

    public abstract void loadData(CompoundTag var1);

    public abstract void saveData(CompoundTag var1);

    public static <T extends SaveHandler> T read(Level level, HandlerType<T> type, String id) {
        if (!(level instanceof ServerLevel)) {
            return type.clientSide();
        }
        ServerLevel serverLevel = (ServerLevel)level;
        return SaveHandler.read(serverLevel.getServer().overworld().getDataStorage(), type, id);
    }

    public static <T extends SaveHandler> T read(DimensionDataStorage storage, HandlerType<T> factory, String id) {
        return (T)((Object)((SaveHandler)storage.computeIfAbsent(factory.factory(), id)));
    }

    public static <T extends SaveHandler> void handle(Level level, Function<Level, T> getter, Consumer<T> operation) {
        SaveHandler handler = (SaveHandler)((Object)getter.apply(level));
        operation.accept(handler);
        handler.setDirty();
    }

    public record HandlerType<T extends SaveHandler>(@Nullable T clientSide, SavedData.Factory<T> factory) {
        public static <T extends SaveHandler> HandlerType<T> create(Supplier<T> creator) {
            return HandlerType.create(null, creator);
        }

        public static <T extends SaveHandler> HandlerType<T> create(T clientSide, Supplier<T> creator) {
            return new HandlerType<T>(clientSide, new SavedData.Factory(creator, (tag, provider) -> {
                SaveHandler handler = (SaveHandler)((Object)((Object)creator.get()));
                handler.loadData((CompoundTag)tag);
                return handler;
            }, DataFixTypes.OPTIONS));
        }
    }
}

