/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.data.loot;

import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import sonar.fluxnetworks.api.FluxDataComponents;
import sonar.fluxnetworks.common.block.FluxDeviceBlock;
import sonar.fluxnetworks.register.RegistryBlocks;

public class FluxBlockLoot
extends BlockLootSubProvider {
    private final Set<Block> knownBlocks = new ObjectArraySet();

    public FluxBlockLoot(HolderLookup.Provider registries) {
        super(Collections.emptySet(), FeatureFlags.REGISTRY.allFlags(), registries);
    }

    @Nonnull
    public final Iterable<Block> getKnownBlocks() {
        return this.knownBlocks;
    }

    protected final void add(@Nonnull Block blockIn, @Nonnull LootTable.Builder table) {
        super.add(blockIn, table);
        this.knownBlocks.add(blockIn);
    }

    protected void generate() {
        this.dropSelf((Block)RegistryBlocks.FLUX_BLOCK.get());
        this.add((Block)RegistryBlocks.FLUX_PLUG.get(), this::createDevice);
        this.add((Block)RegistryBlocks.FLUX_POINT.get(), this::createDevice);
        this.add((Block)RegistryBlocks.FLUX_CONTROLLER.get(), this::createDevice);
        this.add((Block)RegistryBlocks.BASIC_FLUX_STORAGE.get(), this::createDevice);
        this.add((Block)RegistryBlocks.HERCULEAN_FLUX_STORAGE.get(), this::createDevice);
        this.add((Block)RegistryBlocks.GARGANTUAN_FLUX_STORAGE.get(), this::createDevice);
    }

    @Nonnull
    protected LootTable.Builder createDevice(Block block) {
        if (!(block instanceof FluxDeviceBlock)) {
            throw new IllegalArgumentException();
        }
        CopyComponentsFunction.Builder copyComponent = CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY);
        copyComponent.include(FluxDataComponents.FLUX_CONFIG);
        copyComponent.include(FluxDataComponents.STORED_ENERGY);
        LootPool.Builder pool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)copyComponent));
        return LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)pool));
    }
}

