/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.crafting;

import com.mojang.serialization.MapCodec;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.block.Block;
import sonar.fluxnetworks.api.FluxDataComponents;
import sonar.fluxnetworks.common.block.FluxStorageBlock;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ConfigWipeRecipe
extends ShapelessRecipe {
    public ConfigWipeRecipe(String group, CraftingBookCategory category, ItemStack result, NonNullList<Ingredient> ingredients) {
        super(group, category, result, ingredients);
    }

    public ConfigWipeRecipe(ShapelessRecipe recipe) {
        super(recipe.getGroup(), recipe.category(), recipe.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY), recipe.getIngredients());
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack originalStack = input.items().stream().filter(stack -> !stack.isEmpty() && stack.get(FluxDataComponents.FLUX_CONFIG) != null).findFirst().orElse(null);
        ItemStack output = super.assemble(input, registries);
        if (originalStack != null) {
            if (Block.byItem((Item)output.getItem()) instanceof FluxStorageBlock) {
                output.copyFrom((DataComponentHolder)originalStack, new DataComponentType[]{FluxDataComponents.STORED_ENERGY});
            }
            return output;
        }
        return output;
    }

    public RecipeSerializer<?> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements RecipeSerializer<ConfigWipeRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final MapCodec<ConfigWipeRecipe> CODEC = RecipeSerializer.SHAPELESS_RECIPE.codec().xmap(ConfigWipeRecipe::new, Function.identity());
        public static final StreamCodec<RegistryFriendlyByteBuf, ConfigWipeRecipe> STREAM_CODEC = RecipeSerializer.SHAPELESS_RECIPE.streamCodec().map(ConfigWipeRecipe::new, Function.identity());

        public MapCodec<ConfigWipeRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, ConfigWipeRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private Serializer() {
        }
    }
}

