/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.block;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import sonar.fluxnetworks.common.block.FluxDeviceBlock;
import sonar.fluxnetworks.common.device.TileFluxConnector;
import sonar.fluxnetworks.common.util.FluxUtils;

@ParametersAreNonnullByDefault
public abstract class FluxConnectorBlock
extends FluxDeviceBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty[] SIDES_CONNECTED = new BooleanProperty[]{BlockStateProperties.DOWN, BlockStateProperties.UP, BlockStateProperties.NORTH, BlockStateProperties.SOUTH, BlockStateProperties.WEST, BlockStateProperties.EAST};

    protected FluxConnectorBlock(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.DOWN, (Comparable)Boolean.FALSE)).setValue((Property)BlockStateProperties.UP, (Comparable)Boolean.FALSE)).setValue((Property)BlockStateProperties.NORTH, (Comparable)Boolean.FALSE)).setValue((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.FALSE)).setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.FALSE)).setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.FALSE)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity;
        super.neighborChanged(state, level, pos, block, fromPos, isMoving);
        if (!level.isClientSide && (blockEntity = level.getBlockEntity(pos)) instanceof TileFluxConnector) {
            TileFluxConnector c = (TileFluxConnector)blockEntity;
            Direction dir = FluxUtils.getBlockDirection(pos, fromPos);
            if (dir != null) {
                c.updateSideTransfer(dir, level.getBlockEntity(fromPos));
            }
        }
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        BlockEntity blockEntity;
        super.onNeighborChange(state, level, pos, neighbor);
        if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof TileFluxConnector) {
            TileFluxConnector c = (TileFluxConnector)blockEntity;
            Direction dir = FluxUtils.getBlockDirection(pos, neighbor);
            if (dir != null) {
                c.updateSideTransfer(dir, level.getBlockEntity(neighbor));
            }
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER));
    }

    @Nonnull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, level, currentPos, neighborPos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add((Property[])SIDES_CONNECTED);
        builder.add(new Property[]{BlockStateProperties.WATERLOGGED});
    }

    @Nonnull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }
}

