/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.gui.basic;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.joml.Matrix4f;
import sonar.fluxnetworks.FluxConfig;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.client.gui.EnumNavigationTab;
import sonar.fluxnetworks.client.gui.basic.GuiPopupCore;
import sonar.fluxnetworks.client.gui.basic.GuiPopupHost;
import sonar.fluxnetworks.client.gui.basic.GuiTabCore;
import sonar.fluxnetworks.client.gui.button.FluxEditBox;
import sonar.fluxnetworks.common.connection.FluxMenu;

public abstract class GuiFocusable
extends AbstractContainerScreen<FluxMenu> {
    public static final int TEXTURE_SIZE = 512;
    public static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"fluxnetworks", (String)"textures/gui/gui_background.png");
    public static final ResourceLocation FRAME = ResourceLocation.fromNamespaceAndPath((String)"fluxnetworks", (String)"textures/gui/gui_frame.png");
    public static final ResourceLocation ICON = ResourceLocation.fromNamespaceAndPath((String)"fluxnetworks", (String)"textures/gui/gui_icon.png");
    private static final boolean sHasExtendedGuiGraphics;

    public GuiFocusable(FluxMenu menu, @Nonnull Player player) {
        super((AbstractContainerMenu)menu, player.getInventory(), CommonComponents.EMPTY);
    }

    public void setFocused(@Nullable GuiEventListener listener) {
        super.setFocused(listener);
        for (GuiEventListener child : this.children()) {
            FluxEditBox editBox;
            if (child == listener || !(child instanceof FluxEditBox) || !(editBox = (FluxEditBox)child).isFocused()) continue;
            editBox.setFocused(false);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        boolean result;
        InputConstants.Key key = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (this.getFocused() != null) {
            if (keyCode == 256 || keyCode == 257 || keyCode == 335) {
                this.setFocused(null);
                return true;
            }
            if (this.getMinecraft().options.keyInventory.isActiveAndMatches(key)) {
                return true;
            }
        } else if (keyCode == 256 || this.getMinecraft().options.keyInventory.isActiveAndMatches(key)) {
            GuiFocusable guiFocusable = this;
            if (guiFocusable instanceof GuiPopupCore) {
                GuiPopupCore core = (GuiPopupCore)guiFocusable;
                ((GuiPopupHost)((Object)core.mHost)).closePopup();
                return true;
            }
            guiFocusable = this;
            if (guiFocusable instanceof GuiTabCore) {
                GuiTabCore core = (GuiTabCore)guiFocusable;
                if (core.getNavigationTab() == EnumNavigationTab.TAB_HOME) {
                    this.onClose();
                } else {
                    core.switchTab(EnumNavigationTab.TAB_HOME, true);
                }
            }
            return true;
        }
        return (result = super.keyPressed(keyCode, scanCode, modifiers)) || this.getFocused() != null;
    }

    protected void containerTick() {
        super.containerTick();
    }

    protected void blitBackgroundOrFrame(@Nonnull GuiGraphics gr) {
        float cx = (float)this.width / 2.0f;
        float cy = (float)this.height / 2.0f + 5.0f;
        GuiFocusable.blitF(gr.pose().last().pose(), cx - 86.0f, cy - 86.0f, 0.0f, 172.0f, 172.0f, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    public static void blitF(@Nonnull GuiGraphics gr, float x, float y, float width, float height, float uOffset, float vOffset, float uWidth, float vHeight) {
        float minU = uOffset / 512.0f;
        float minV = vOffset / 512.0f;
        float maxU = (uOffset + uWidth) / 512.0f;
        float maxV = (vOffset + vHeight) / 512.0f;
        GuiFocusable.blitF(gr.pose().last().pose(), x, y, 0.0f, width, height, minU, minV, maxU, maxV);
    }

    public static void blitF(Matrix4f matrix, float x, float y, float z, float width, float height, float minU, float minV, float maxU, float maxV) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        BufferBuilder builder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        builder.addVertex(matrix, x + width, y, z).setUv(maxU, minV);
        builder.addVertex(matrix, x, y, z).setUv(minU, minV);
        builder.addVertex(matrix, x, y + height, z).setUv(minU, maxV);
        builder.addVertex(matrix, x + width, y + height, z).setUv(maxU, maxV);
        BufferUploader.drawWithShader((MeshData)builder.buildOrThrow());
    }

    public static boolean useModernDesign() {
        return sHasExtendedGuiGraphics && FluxConfig.enableModernDesign;
    }

    static {
        boolean found = false;
        try {
            Class.forName("icyllis.modernui.mc.ExtendedGuiGraphics", false, GuiFocusable.class.getClassLoader());
            found = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (Exception e) {
            FluxNetworks.LOGGER.error((Object)e);
        }
        sHasExtendedGuiGraphics = found;
    }
}

