/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.util;

import java.io.IOException;
import org.apache.lucene.ars_nouveau.search.DocIdSetIterator;
import org.apache.lucene.ars_nouveau.util.Accountable;
import org.apache.lucene.ars_nouveau.util.Bits;
import org.apache.lucene.ars_nouveau.util.FixedBitSet;
import org.apache.lucene.ars_nouveau.util.SparseFixedBitSet;

public abstract class BitSet
implements Bits,
Accountable {
    public static BitSet of(DocIdSetIterator it, int maxDoc) throws IOException {
        int threshold;
        long cost = it.cost();
        BitSet set = cost < (long)(threshold = maxDoc >>> 7) ? new SparseFixedBitSet(maxDoc) : new FixedBitSet(maxDoc);
        set.or(it);
        return set;
    }

    public void clear() {
        this.clear(0, this.length());
    }

    public abstract void set(int var1);

    public abstract boolean getAndSet(int var1);

    public abstract void clear(int var1);

    public abstract void clear(int var1, int var2);

    public abstract int cardinality();

    public abstract int approximateCardinality();

    public abstract int prevSetBit(int var1);

    public int nextSetBit(int index) {
        return this.nextSetBit(index, this.length());
    }

    public abstract int nextSetBit(int var1, int var2);

    protected final void checkUnpositioned(DocIdSetIterator iter) {
        if (iter.docID() != -1) {
            throw new IllegalStateException("This operation only works with an unpositioned iterator, got current position = " + iter.docID());
        }
    }

    public void or(DocIdSetIterator iter) throws IOException {
        this.checkUnpositioned(iter);
        int doc = iter.nextDoc();
        while (doc != Integer.MAX_VALUE) {
            this.set(doc);
            doc = iter.nextDoc();
        }
    }
}

