/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.search;

import java.io.IOException;
import org.apache.lucene.ars_nouveau.index.ImpactsEnum;
import org.apache.lucene.ars_nouveau.index.NumericDocValues;
import org.apache.lucene.ars_nouveau.index.PostingsEnum;
import org.apache.lucene.ars_nouveau.index.SlowImpactsEnum;
import org.apache.lucene.ars_nouveau.search.DocIdSetIterator;
import org.apache.lucene.ars_nouveau.search.ImpactsDISI;
import org.apache.lucene.ars_nouveau.search.MaxScoreCache;
import org.apache.lucene.ars_nouveau.search.Scorer;
import org.apache.lucene.ars_nouveau.search.similarities.Similarity;

public final class TermScorer
extends Scorer {
    private final PostingsEnum postingsEnum;
    private final DocIdSetIterator iterator;
    private final Similarity.SimScorer scorer;
    private final NumericDocValues norms;
    private final ImpactsDISI impactsDisi;
    private final MaxScoreCache maxScoreCache;

    public TermScorer(PostingsEnum postingsEnum, Similarity.SimScorer scorer, NumericDocValues norms) {
        this.postingsEnum = postingsEnum;
        this.iterator = this.postingsEnum;
        SlowImpactsEnum impactsEnum = new SlowImpactsEnum(postingsEnum);
        this.maxScoreCache = new MaxScoreCache(impactsEnum, scorer);
        this.impactsDisi = null;
        this.scorer = scorer;
        this.norms = norms;
    }

    public TermScorer(ImpactsEnum impactsEnum, Similarity.SimScorer scorer, NumericDocValues norms, boolean topLevelScoringClause) {
        this.postingsEnum = impactsEnum;
        this.maxScoreCache = new MaxScoreCache(impactsEnum, scorer);
        if (topLevelScoringClause) {
            this.impactsDisi = new ImpactsDISI(impactsEnum, this.maxScoreCache);
            this.iterator = this.impactsDisi;
        } else {
            this.impactsDisi = null;
            this.iterator = impactsEnum;
        }
        this.scorer = scorer;
        this.norms = norms;
    }

    @Override
    public int docID() {
        return this.postingsEnum.docID();
    }

    public final int freq() throws IOException {
        return this.postingsEnum.freq();
    }

    @Override
    public DocIdSetIterator iterator() {
        return this.iterator;
    }

    @Override
    public float score() throws IOException {
        PostingsEnum postingsEnum = this.postingsEnum;
        NumericDocValues norms = this.norms;
        long norm = 1L;
        if (norms != null && norms.advanceExact(postingsEnum.docID())) {
            norm = norms.longValue();
        }
        return this.scorer.score(postingsEnum.freq(), norm);
    }

    @Override
    public float smoothingScore(int docId) throws IOException {
        long norm = 1L;
        if (this.norms != null && this.norms.advanceExact(docId)) {
            norm = this.norms.longValue();
        }
        return this.scorer.score(0.0f, norm);
    }

    @Override
    public int advanceShallow(int target) throws IOException {
        return this.maxScoreCache.advanceShallow(target);
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        return this.maxScoreCache.getMaxScore(upTo);
    }

    @Override
    public void setMinCompetitiveScore(float minScore) {
        if (this.impactsDisi != null) {
            this.impactsDisi.setMinCompetitiveScore(minScore);
        }
    }
}

