/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.queries.intervals;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.lucene.ars_nouveau.index.LeafReaderContext;
import org.apache.lucene.ars_nouveau.index.Terms;
import org.apache.lucene.ars_nouveau.index.TermsEnum;
import org.apache.lucene.ars_nouveau.queries.intervals.DisjunctionIntervalsSource;
import org.apache.lucene.ars_nouveau.queries.intervals.IntervalIterator;
import org.apache.lucene.ars_nouveau.queries.intervals.IntervalMatchesIterator;
import org.apache.lucene.ars_nouveau.queries.intervals.IntervalQuery;
import org.apache.lucene.ars_nouveau.queries.intervals.IntervalsSource;
import org.apache.lucene.ars_nouveau.queries.intervals.TermIntervalsSource;
import org.apache.lucene.ars_nouveau.search.IndexSearcher;
import org.apache.lucene.ars_nouveau.search.MatchesIterator;
import org.apache.lucene.ars_nouveau.search.MatchesUtils;
import org.apache.lucene.ars_nouveau.search.Query;
import org.apache.lucene.ars_nouveau.search.QueryVisitor;
import org.apache.lucene.ars_nouveau.util.BytesRef;
import org.apache.lucene.ars_nouveau.util.automaton.CompiledAutomaton;

class MultiTermIntervalsSource
extends IntervalsSource {
    private final CompiledAutomaton automaton;
    private final int maxExpansions;
    private final String pattern;

    MultiTermIntervalsSource(CompiledAutomaton automaton, int maxExpansions, String pattern) {
        this.automaton = automaton;
        if (maxExpansions > IndexSearcher.getMaxClauseCount()) {
            throw new IllegalArgumentException("maxExpansions [" + maxExpansions + "] cannot be greater than BooleanQuery.getMaxClauseCount [" + IndexSearcher.getMaxClauseCount() + "]");
        }
        this.maxExpansions = maxExpansions;
        this.pattern = pattern;
    }

    @Override
    public IntervalIterator intervals(String field, LeafReaderContext ctx) throws IOException {
        BytesRef term;
        Terms terms = ctx.reader().terms(field);
        if (terms == null) {
            return null;
        }
        ArrayList<IntervalIterator> subSources = new ArrayList<IntervalIterator>();
        TermsEnum te = this.automaton.getTermsEnum(terms);
        int count = 0;
        while ((term = te.next()) != null) {
            subSources.add(TermIntervalsSource.intervals(term, te));
            if (++count <= this.maxExpansions) continue;
            throw new IllegalStateException("Automaton [" + this.pattern + "] expanded to too many terms (limit " + this.maxExpansions + ")");
        }
        if (subSources.size() == 0) {
            return null;
        }
        return new DisjunctionIntervalsSource.DisjunctionIntervalIterator(subSources);
    }

    @Override
    public IntervalMatchesIterator matches(String field, LeafReaderContext ctx, int doc) throws IOException {
        MatchesIterator mi;
        BytesRef term;
        Terms terms = ctx.reader().terms(field);
        if (terms == null) {
            return null;
        }
        ArrayList<MatchesIterator> subMatches = new ArrayList<MatchesIterator>();
        TermsEnum te = this.automaton.getTermsEnum(terms);
        int count = 0;
        while ((term = te.next()) != null) {
            mi = TermIntervalsSource.matches(te, doc, field);
            if (mi == null) continue;
            subMatches.add(mi);
            if (count++ <= this.maxExpansions) continue;
            throw new IllegalStateException("Automaton " + String.valueOf(term) + " expanded to too many terms (limit " + this.maxExpansions + ")");
        }
        mi = MatchesUtils.disjunction(subMatches);
        if (mi == null) {
            return null;
        }
        return new IntervalMatchesIterator(){

            @Override
            public int gaps() {
                return 0;
            }

            @Override
            public int width() {
                return 1;
            }

            @Override
            public boolean next() throws IOException {
                return mi.next();
            }

            @Override
            public int startPosition() {
                return mi.startPosition();
            }

            @Override
            public int endPosition() {
                return mi.endPosition();
            }

            @Override
            public int startOffset() throws IOException {
                return mi.startOffset();
            }

            @Override
            public int endOffset() throws IOException {
                return mi.endOffset();
            }

            @Override
            public MatchesIterator getSubMatches() throws IOException {
                return mi.getSubMatches();
            }

            @Override
            public Query getQuery() {
                return mi.getQuery();
            }
        };
    }

    @Override
    public void visit(String field, QueryVisitor visitor) {
        this.automaton.visit(visitor, new IntervalQuery(field, this), field);
    }

    @Override
    public int minExtent() {
        return 1;
    }

    @Override
    public Collection<IntervalsSource> pullUpDisjunctions() {
        return Collections.singleton(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiTermIntervalsSource that = (MultiTermIntervalsSource)o;
        return this.maxExpansions == that.maxExpansions && Objects.equals(this.automaton, that.automaton) && Objects.equals(this.pattern, that.pattern);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.automaton, this.maxExpansions, this.pattern);
    }

    @Override
    public String toString() {
        return "MultiTerm(" + this.pattern + ")";
    }
}

