/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ars_nouveau.facet.facetset;

import java.util.Arrays;
import org.apache.lucene.ars_nouveau.facet.facetset.FacetSet;
import org.apache.lucene.ars_nouveau.util.NumericUtils;

public class DoubleFacetSet
extends FacetSet {
    public final double[] values;

    public DoubleFacetSet(double ... values) {
        super(DoubleFacetSet.validateValuesAndGetNumDims(values));
        this.values = values;
    }

    @Override
    public long[] getComparableValues() {
        return Arrays.stream(this.values).mapToLong(NumericUtils::doubleToSortableLong).toArray();
    }

    private static int validateValuesAndGetNumDims(double ... values) {
        if (values == null || values.length == 0) {
            throw new IllegalArgumentException("values cannot be null or empty");
        }
        return values.length;
    }
}

